/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.chartattr.Legend;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Funnel;
import com.fr.chart.chartglyph.FunnelPlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;

public class FunnelPlot
extends Plot {
    private static final int FUNNEL_CHART = 0;
    private static final String[] FUNNELCATE = new String[]{"Funnel"};
    private static final String[] FUNNELSERIES = new String[]{"FS1", "FS2", "FS3", "FS4", "FS5", "FS6", "FS7"};
    private static final String[][] FUNNELVALUE = new String[][]{{"100"}, {"80"}, {"70"}, {"60"}, {"40"}, {"30"}, {"20"}};
    private static final NormalChartData FUNNELDATA = new NormalChartData(FUNNELCATE, FUNNELSERIES, FUNNELVALUE);

    public FunnelPlot() {
        this.resetNullLegendAttr();
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        FunnelPlotGlyph funnelPlotGlyph = new FunnelPlotGlyph();
        this.install4PlotGlyph(funnelPlotGlyph, chartData);
        return funnelPlotGlyph;
    }

    protected void addSeriesByIndex(int n2, int n3, PlotGlyph plotGlyph, ChartData chartData) {
        this.addSeriesByIndexWithoutNull(n2, n3, plotGlyph, chartData);
    }

    protected DataPoint createDataPoint() {
        return new DataPoint4Funnel();
    }

    public void clearConditionAttrAndRenewLegend(Plot plot) {
        super.clearConditionAttrAndRenewLegend(plot);
        this.resetNullLegendAttr();
    }

    public boolean match4GUI(Plot plot) {
        if (plot == null) {
            return false;
        }
        return plot instanceof FunnelPlot && super.match4GUI(plot);
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof FunnelPlot;
    }

    public boolean isSupportCategoryFilter() {
        return false;
    }

    public boolean isSupportLeadLine() {
        return true;
    }

    public boolean isHaveAxis() {
        return false;
    }

    public ChartData defaultChartData() {
        return FUNNELDATA;
    }

    public int[] getInteractivePaneArrayThatNotSurpport() {
        return new int[]{2};
    }

    public boolean equals(Object object) {
        return object instanceof FunnelPlot && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        FunnelPlot funnelPlot = (FunnelPlot)super.clone();
        return funnelPlot;
    }

    public String getPlotName() {
        return Inter.getLocText("FR-Chart-Type_Funnel");
    }

    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/funnel/0";
    }

    public int getDetailType() {
        return 0;
    }

    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.FUNNEL;
    }

    public Legend getLegend() {
        return null;
    }

    public boolean isSupportDelimiter() {
        return false;
    }

    protected void createDataPointLabel(PlotGlyph plotGlyph) {
        if (plotGlyph.getSeriesSize() > 0) {
            for (int i2 = 0; i2 < plotGlyph.getSeries(0).getDataPointCount(); ++i2) {
                for (int i3 = 0; i3 < plotGlyph.getSeriesSize(); ++i3) {
                    int n2 = i3 - 1;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    double d2 = plotGlyph.getSeries(n2).getDataPoint(i2).getValue();
                    double d3 = plotGlyph.getSeries(i3).getDataPoint(i2).getValue();
                    if (d2 == 0.0) continue;
                    plotGlyph.getSeries(i3).getDataPoint(i2).setPercentValue(d3 / d2);
                }
            }
        }
        this.createDataLabel4EverySeries(plotGlyph);
    }

    public boolean isShowAllDataPointLabel() {
        return true;
    }

    public boolean isSupportPlotBackground() {
        return false;
    }

    public boolean isSupportLegend() {
        return false;
    }

    public String getPlotID() {
        return "FineReportFunnelChart";
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.FUNNEL_CHART;
    }
}

