/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ShadowRenderer;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class OuterLight
implements XMLReadable,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1342740737463578588L;
    public static final String XML_TAG = "OuterLight";
    private Color outerColor;
    private float outerAlpha;
    private int outerSize;

    public OuterLight() {
    }

    public OuterLight(Color color, int n2, float f2) {
        this.outerColor = color;
        this.outerSize = n2;
        this.outerAlpha = f2;
    }

    public void setOuterColor(Color color) {
        this.outerColor = color;
    }

    public void setOuterAlpha(float f2) {
        this.outerAlpha = f2;
    }

    public void setOutSize(int n2) {
        this.outerSize = n2;
    }

    public boolean isNoOuterLight() {
        return this.outerColor != null && this.outerAlpha != 0.0f && this.outerSize != 0;
    }

    public void paint(Graphics graphics, Shape shape) {
        this.paint(graphics, shape, 0);
    }

    public void paint(Graphics graphics, Shape shape, int n2) {
        if (this.skipPaint(shape)) {
            return;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getX() < 0.0 || rectangle2D.getY() < 0.0) {
            return;
        }
        int n3 = this.outerSize / 4;
        if (n3 <= 0) {
            return;
        }
        BufferedImage bufferedImage = ChartBaseUtils.shapeToImage(shape, n2);
        ShadowRenderer shadowRenderer = new ShadowRenderer(n3, 1.0f, this.outerColor);
        BufferedImage bufferedImage2 = shadowRenderer.createShadow(bufferedImage);
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d2 = shape.getBounds().getX();
        double d3 = shape.getBounds().getY();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.outerAlpha));
        graphics2D.translate(d2, d3);
        if (n2 <= 0) {
            graphics2D.drawImage((Image)bufferedImage2, -n3, -n3, null);
        } else {
            graphics2D.drawImage((Image)bufferedImage2, -n3 - n2, -n3 - n2, null);
        }
        graphics2D.setComposite(composite);
        graphics2D.translate(-d2, -d3);
    }

    private boolean skipPaint(Shape shape) {
        return shape == null || this.outerAlpha == 0.0f || this.outerSize == 0 || shape.getBounds2D() == null || shape.getBounds2D().getWidth() <= 0.0 || shape.getBounds2D().getHeight() <= 0.0;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("outerSize", this.outerSize);
        jSONObject.put("outerAlpha", this.outerAlpha);
        if (this.outerColor != null) {
            jSONObject.put("outerColor", StableUtils.javaColorToCSSColor(this.outerColor));
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            this.outerSize = xMLableReader.getAttrAsInt("outerSize", 0);
            this.outerAlpha = xMLableReader.getAttrAsFloat("outerAlpha", 0.0f);
            this.outerColor = xMLableReader.getAttrAsColor("outerColor", null);
        }
    }

    public void writerXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("outerSize", this.outerSize).attr("outerAlpha", this.outerAlpha);
        if (this.outerColor != null) {
            xMLPrintWriter.attr("outerColor", this.outerColor.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        OuterLight outerLight = (OuterLight)super.clone();
        return outerLight;
    }

    public boolean equals(Object object) {
        return object instanceof OuterLight && ((OuterLight)object).outerAlpha == this.outerAlpha && ((OuterLight)object).outerSize == this.outerSize && ComparatorUtils.equals(((OuterLight)object).outerColor, this.outerColor);
    }
}

