/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.list;

import com.fr.cache.list.IntList;
import com.fr.general.FRLogger;
import com.fr.general.ManagerFactory;
import com.fr.stable.StableUtils;
import com.fr.stable.serialize.SerializationUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FRCacheList
extends AbstractList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static List prefix_list = new ArrayList();
    private File cacheDirectory = null;
    private int initCount = 800;
    private String prefix = "FRCL";
    private int activePoolCount = 1;
    private boolean cacheFirst = false;
    private ActiveFileInfo firstCacheInfo = null;
    private List cacheFileList = new ArrayList();
    private IntList cacheIndexList = new IntList();
    private ArrayList lastCachePool = new ArrayList();
    private LinkedList cachedPoolIndexLL;
    private Map activeCachePoolMap = new HashMap();

    public FRCacheList(int n2, String string) {
        this(n2, 1, string, false);
    }

    public FRCacheList(int n2, int n3, String string, boolean bl) {
        this.initCount = n2;
        string = string.replaceAll("_", "");
        String string2 = this.prefix = "FRCL" + string;
        int n4 = 1;
        while (prefix_list.contains(string2)) {
            string2 = this.prefix + n4;
            ++n4;
        }
        this.prefix = string2;
        prefix_list.add(this.prefix);
        this.cacheIndexList.add(0);
        this.activePoolCount = n3;
        this.initCachePoolIndexLL();
        this.cacheFirst = bl;
    }

    private void initCachePoolIndexLL() {
        this.cachedPoolIndexLL = new LinkedList();
        for (int i2 = 0; i2 < this.activePoolCount; ++i2) {
            this.cachedPoolIndexLL.add(new ActiveFileInfo(-3, null));
        }
    }

    public synchronized int size() {
        return this.cacheIndexList.get(this.cacheIndexList.size() - 1) + this.lastCachePool.size();
    }

    public synchronized boolean add(Object object) {
        if (this.lastCachePool.size() >= this.initCount) {
            try {
                this.cacheIndexList.add(this.size());
                if (this.cacheIndexList.size() == 2 && this.cacheFirst) {
                    this.firstCacheInfo = new ActiveFileInfo(0, this.lastCachePool);
                    this.lastCachePool = new ArrayList();
                    this.cacheFileList.add(new Object());
                } else {
                    File file = new File(this.getCacheDirectory(), this.getPrefix() + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
                    int n2 = 0;
                    while (file.exists()) {
                        file = new File(this.getCacheDirectory(), this.getPrefix() + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n2);
                        ++n2;
                    }
                    SerializationUtils.serializable(this.lastCachePool, file);
                    this.lastCachePool.clear();
                    file.deleteOnExit();
                    this.cacheFileList.add(file);
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        this.lastCachePool.add(object);
        return true;
    }

    public synchronized Object set(int n2, Object object) {
        this.rangeCheck(n2);
        try {
            int n3 = this.getCachePoolFileIndex(n2);
            if (n3 == -2) {
                return this.lastCachePool.set(n2 - this.cacheIndexList.get(this.cacheIndexList.size() - 1), object);
            }
            ActiveFileInfo activeFileInfo = this.getCachePoolFileByFileIndex(n3);
            if (activeFileInfo != null) {
                Object object2 = activeFileInfo.getActiveCachedPool().set(n2 - this.cacheIndexList.get(activeFileInfo.getFileIndex()), object);
                activeFileInfo.setChanged(true);
                return object2;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return null;
    }

    public synchronized void add(int n2, Object object) {
        this.rangeCheck(n2);
        if (n2 == this.size()) {
            this.add(object);
            return;
        }
        try {
            int n3 = this.getCachePoolFileIndex(n2);
            if (n3 == -2) {
                this.lastCachePool.add(n2 - this.cacheIndexList.get(this.cacheIndexList.size() - 1), object);
                return;
            }
            ActiveFileInfo activeFileInfo = this.getCachePoolFileByFileIndex(n3);
            if (activeFileInfo != null) {
                activeFileInfo.getActiveCachedPool().add(n2 - this.cacheIndexList.get(activeFileInfo.getFileIndex()), object);
                for (int i2 = activeFileInfo.getFileIndex() + 1; i2 < this.cacheIndexList.size(); ++i2) {
                    this.cacheIndexList.set(i2, this.cacheIndexList.get(i2) + 1);
                }
                activeFileInfo.setChanged(true);
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public synchronized Object remove(int n2) {
        this.rangeCheck(n2);
        try {
            int n3 = this.getCachePoolFileIndex(n2);
            if (n3 == -2) {
                return this.lastCachePool.remove(n2 - this.cacheIndexList.get(this.cacheIndexList.size() - 1));
            }
            ActiveFileInfo activeFileInfo = this.getCachePoolFileByFileIndex(n3);
            if (activeFileInfo != null) {
                Object e2 = activeFileInfo.getActiveCachedPool().remove(n2 - this.cacheIndexList.get(activeFileInfo.getFileIndex()));
                for (int i2 = activeFileInfo.getFileIndex() + 1; i2 < this.cacheIndexList.size(); ++i2) {
                    this.cacheIndexList.set(i2, this.cacheIndexList.get(i2) - 1);
                }
                activeFileInfo.setChanged(true);
                return e2;
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return null;
    }

    public synchronized Object get(int n2) {
        try {
            this.rangeCheck(n2);
            int n3 = this.getCachePoolFileIndex(n2);
            if (n3 == -2) {
                return this.lastCachePool.get(n2 - this.cacheIndexList.get(this.cacheIndexList.size() - 1));
            }
            ActiveFileInfo activeFileInfo = this.getCachePoolFileByFileIndex(n3);
            if (activeFileInfo != null) {
                return activeFileInfo.getActiveCachedPool().get(n2 - this.cacheIndexList.get(activeFileInfo.getFileIndex()));
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return null;
    }

    private void rangeCheck(int n2) {
        int n3 = this.size();
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ",Size: " + n3);
        }
    }

    private int getCachePoolFileIndex(int n2) {
        if (n2 >= this.cacheIndexList.get(this.cacheIndexList.size() - 1)) {
            return -2;
        }
        if (n2 < 0) {
            return -1;
        }
        int n3 = n2 / this.initCount;
        if (this.cacheIndexList.get(n3) <= n2) {
            for (int i2 = n3; i2 < this.cacheIndexList.size() - 1; ++i2) {
                if (n2 < this.cacheIndexList.get(i2) || n2 >= this.cacheIndexList.get(i2 + 1)) continue;
                return i2;
            }
        } else {
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                if (n2 < this.cacheIndexList.get(i3) || n2 >= this.cacheIndexList.get(i3 + 1)) continue;
                return i3;
            }
        }
        return -1;
    }

    private ActiveFileInfo getCachePoolFileByFileIndex(int n2) throws IOException, ClassNotFoundException {
        if (n2 < 0) {
            return null;
        }
        if (n2 == 0 && this.firstCacheInfo != null) {
            return this.firstCacheInfo;
        }
        Integer n3 = new Integer(n2);
        if (this.cachedPoolIndexLL.remove(n3)) {
            this.cachedPoolIndexLL.add(n3);
            return (ActiveFileInfo)this.activeCachePoolMap.get(n3);
        }
        ActiveFileInfo activeFileInfo = (ActiveFileInfo)this.activeCachePoolMap.remove(this.cachedPoolIndexLL.removeFirst());
        this.ChangeActiveCachedFile(activeFileInfo);
        ArrayList arrayList = this.getActiveFileFromDisk(n2);
        ActiveFileInfo activeFileInfo2 = new ActiveFileInfo(n2, arrayList);
        this.cachedPoolIndexLL.add(n3);
        this.activeCachePoolMap.put(n3, activeFileInfo2);
        return activeFileInfo2;
    }

    private ArrayList getActiveFileFromDisk(int n2) throws IOException, ClassNotFoundException {
        File file = (File)this.cacheFileList.get(n2);
        return (ArrayList)SerializationUtils.deserializable(file);
    }

    private synchronized void ChangeActiveCachedFile(ActiveFileInfo activeFileInfo) throws IOException {
        if (activeFileInfo == null) {
            return;
        }
        if (!activeFileInfo.isChanged()) {
            return;
        }
        File file = (File)this.cacheFileList.get(activeFileInfo.getFileIndex());
        SerializationUtils.serializable(activeFileInfo.getActiveCachedPool(), file);
    }

    public synchronized void clear() {
        this.lastCachePool.clear();
        this.cacheFileList.clear();
        this.cacheIndexList.clear();
        this.cacheIndexList.add(0);
        this.initCachePoolIndexLL();
        this.activeCachePoolMap.clear();
        if (this.firstCacheInfo != null) {
            this.firstCacheInfo.activeCachedPool.clear();
            this.firstCacheInfo = null;
        }
        if (this.cacheDirectory != null) {
            StableUtils.deleteFile(this.cacheDirectory);
            this.cacheDirectory = null;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    private File getCacheDirectory() {
        if (this.cacheDirectory == null) {
            this.cacheDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n2 = 0;
            while (this.cacheDirectory.exists()) {
                this.cacheDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n2);
                ++n2;
            }
            StableUtils.mkdirs(this.cacheDirectory);
            this.cacheDirectory.deleteOnExit();
        }
        return this.cacheDirectory;
    }

    public String toString() {
        return "FRCacheList" + this.hashCode();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cacheDirectory != null) {
            StableUtils.deleteFile(this.cacheDirectory);
            this.cacheDirectory = null;
        }
    }

    private class ActiveFileInfo
    implements Serializable {
        private int fileIndex;
        private ArrayList activeCachedPool;
        private boolean isChanged;

        public ActiveFileInfo(int n2, ArrayList arrayList) {
            this.fileIndex = n2;
            this.activeCachedPool = arrayList;
            this.isChanged = false;
        }

        public int getFileIndex() {
            return this.fileIndex;
        }

        public ArrayList getActiveCachedPool() {
            return this.activeCachedPool;
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        public void setChanged(boolean bl) {
            this.isChanged = bl;
        }
    }
}

