/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.Prefs;
import ij.process.Blitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class FloatBlitter
implements Blitter {
    public static float divideByZeroValue = (float)Prefs.getDouble("div-by-zero", Double.POSITIVE_INFINITY);
    private FloatProcessor ip;
    private int width;
    private int height;
    private float[] pixels;

    static {
        if (divideByZeroValue == Float.MAX_VALUE) {
            divideByZeroValue = Float.POSITIVE_INFINITY;
        }
    }

    public FloatBlitter(FloatProcessor ip) {
        this.ip = ip;
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.pixels = (float[])ip.getPixels();
    }

    public void setTransparentColor(Color c) {
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        if (!(ip instanceof FloatProcessor)) {
            ip = ip.convertToFloat();
        }
        int srcWidth = ip.getWidth();
        int srcHeight = ip.getHeight();
        Rectangle r1 = new Rectangle(srcWidth, srcHeight);
        r1.setLocation(xloc, yloc);
        Rectangle r2 = new Rectangle(this.width, this.height);
        if (!r1.intersects(r2)) {
            return;
        }
        float[] srcPixels = (float[])ip.getPixels();
        r1 = r1.intersection(r2);
        int xSrcBase = xloc < 0 ? -xloc : 0;
        int ySrcBase = yloc < 0 ? -yloc : 0;
        boolean useDBZValue = !Float.isInfinite(divideByZeroValue);
        int y = r1.y;
        while (y < r1.y + r1.height) {
            int srcIndex = (y - yloc) * srcWidth + (r1.x - xloc);
            int dstIndex = y * this.width + r1.x;
            switch (mode) {
                case 0: 
                case 1: 
                case 2: {
                    int i = r1.width;
                    while (--i >= 0) {
                        this.pixels[dstIndex++] = srcPixels[srcIndex++];
                    }
                    break;
                }
                case 14: {
                    float dst;
                    float src;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = (src = srcPixels[srcIndex++]) == 0.0f ? this.pixels[dstIndex] : src;
                        this.pixels[dstIndex++] = dst;
                    }
                    break;
                }
                case 3: {
                    int i = r1.width;
                    while (--i >= 0) {
                        this.pixels[dstIndex] = srcPixels[srcIndex] + this.pixels[dstIndex];
                        ++srcIndex;
                        ++dstIndex;
                    }
                    break;
                }
                case 7: {
                    float dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = (srcPixels[srcIndex++] + this.pixels[dstIndex]) / 2.0f;
                        this.pixels[dstIndex++] = dst;
                    }
                    break;
                }
                case 8: {
                    float dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = this.pixels[dstIndex] - srcPixels[srcIndex];
                        this.pixels[dstIndex] = dst < 0.0f ? -dst : dst;
                        ++srcIndex;
                        ++dstIndex;
                    }
                    break;
                }
                case 4: {
                    int i = r1.width;
                    while (--i >= 0) {
                        this.pixels[dstIndex] = this.pixels[dstIndex] - srcPixels[srcIndex];
                        ++srcIndex;
                        ++dstIndex;
                    }
                    break;
                }
                case 5: {
                    int i = r1.width;
                    while (--i >= 0) {
                        this.pixels[dstIndex] = srcPixels[srcIndex] * this.pixels[dstIndex];
                        ++srcIndex;
                        ++dstIndex;
                    }
                    break;
                }
                case 6: {
                    float src;
                    int i = r1.width;
                    while (--i >= 0) {
                        src = srcPixels[srcIndex];
                        this.pixels[dstIndex] = useDBZValue && (double)src == 0.0 ? divideByZeroValue : this.pixels[dstIndex] / src;
                        ++srcIndex;
                        ++dstIndex;
                    }
                    break;
                }
                case 9: {
                    float dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = (int)srcPixels[srcIndex++] & (int)this.pixels[dstIndex];
                        this.pixels[dstIndex++] = dst;
                    }
                    break;
                }
                case 10: {
                    float dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = (int)srcPixels[srcIndex++] | (int)this.pixels[dstIndex];
                        this.pixels[dstIndex++] = dst;
                    }
                    break;
                }
                case 11: {
                    float dst;
                    int i = r1.width;
                    while (--i >= 0) {
                        dst = (int)srcPixels[srcIndex++] ^ (int)this.pixels[dstIndex];
                        this.pixels[dstIndex++] = dst;
                    }
                    break;
                }
                case 12: {
                    float dst;
                    float src;
                    int i = r1.width;
                    while (--i >= 0) {
                        int n = srcIndex++;
                        src = srcPixels[n];
                        dst = this.pixels[dstIndex];
                        if (src < dst) {
                            dst = src;
                        }
                        this.pixels[dstIndex++] = dst;
                    }
                    break;
                }
                case 13: {
                    float dst;
                    float src;
                    int i = r1.width;
                    while (--i >= 0) {
                        int n = srcIndex++;
                        src = srcPixels[n];
                        dst = this.pixels[dstIndex];
                        if (src > dst) {
                            dst = src;
                        }
                        this.pixels[dstIndex++] = dst;
                    }
                    break;
                }
            }
            if (y % 20 == 0) {
                ip.showProgress((double)(y - r1.y) / (double)r1.height);
            }
            ++y;
        }
        ip.showProgress(1.0);
    }
}

