/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.ContrastEnhancer;
import ij.plugin.FFT;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;

public class FHT
extends FloatProcessor {
    private boolean isFrequencyDomain;
    private int maxN;
    private float[] C;
    private float[] S;
    private int[] bitrev;
    private float[] tempArr;
    private boolean showProgress = true;
    public boolean quadrantSwapNeeded;
    public ColorProcessor rgb;
    public int originalWidth;
    public int originalHeight;
    public int originalBitDepth;
    public ColorModel originalColorModel;

    public FHT(ImageProcessor ip) {
        this(ip, false);
    }

    public FHT(ImageProcessor ip, boolean isFrequencyDomain) {
        super(ip.getWidth(), ip.getHeight(), (float[])(ip instanceof FloatProcessor ? ip.duplicate().getPixels() : ip.convertToFloat().getPixels()), null);
        this.isFrequencyDomain = isFrequencyDomain;
        this.maxN = this.getWidth();
        this.resetRoi();
    }

    public FHT() {
        super(8, 8);
    }

    public boolean powerOf2Size() {
        int i = 2;
        while (i < this.width) {
            i *= 2;
        }
        return i == this.width && this.width == this.height;
    }

    public void transform() {
        this.transform(false);
    }

    public void inverseTransform() {
        this.transform(true);
    }

    void transform(boolean inverse) {
        if (!this.powerOf2Size()) {
            throw new IllegalArgumentException("Image not power of 2 size or not square: " + this.width + "x" + this.height);
        }
        this.maxN = this.width;
        if (this.S == null) {
            this.initializeTables(this.maxN);
        }
        float[] fht = (float[])this.getPixels();
        this.rc2DFHT(fht, inverse, this.maxN);
        this.isFrequencyDomain = !inverse;
    }

    void initializeTables(int maxN) {
        this.makeSinCosTables(maxN);
        this.makeBitReverseTable(maxN);
        this.tempArr = new float[maxN];
    }

    void makeSinCosTables(int maxN) {
        int n = maxN / 4;
        this.C = new float[n];
        this.S = new float[n];
        double theta = 0.0;
        double dTheta = Math.PI * 2 / (double)maxN;
        int i = 0;
        while (i < n) {
            this.C[i] = (float)Math.cos(theta);
            this.S[i] = (float)Math.sin(theta);
            theta += dTheta;
            ++i;
        }
    }

    void makeBitReverseTable(int maxN) {
        this.bitrev = new int[maxN];
        int nLog2 = this.log2(maxN);
        int i = 0;
        while (i < maxN) {
            this.bitrev[i] = this.bitRevX(i, nLog2);
            ++i;
        }
    }

    public void rc2DFHT(float[] x, boolean inverse, int maxN) {
        if (this.S == null) {
            this.initializeTables(maxN);
        }
        int row = 0;
        while (row < maxN) {
            this.dfht3(x, row * maxN, inverse, maxN);
            ++row;
        }
        this.progress(0.4);
        this.transposeR(x, maxN);
        this.progress(0.5);
        row = 0;
        while (row < maxN) {
            this.dfht3(x, row * maxN, inverse, maxN);
            ++row;
        }
        this.progress(0.7);
        this.transposeR(x, maxN);
        this.progress(0.8);
        int row2 = 0;
        while (row2 <= maxN / 2) {
            int col = 0;
            while (col <= maxN / 2) {
                int mRow = (maxN - row2) % maxN;
                int mCol = (maxN - col) % maxN;
                float A = x[row2 * maxN + col];
                float B = x[mRow * maxN + col];
                float C = x[row2 * maxN + mCol];
                float D = x[mRow * maxN + mCol];
                float E = (A + D - (B + C)) / 2.0f;
                x[row2 * maxN + col] = A - E;
                x[mRow * maxN + col] = B + E;
                x[row2 * maxN + mCol] = C + E;
                x[mRow * maxN + mCol] = D - E;
                ++col;
            }
            ++row2;
        }
        this.progress(0.95);
    }

    void progress(double percent) {
        if (this.showProgress) {
            IJ.showProgress(percent);
        }
    }

    public void dfht3(float[] x, int base, boolean inverse, int maxN) {
        float rt2;
        float rt1;
        int Ad4;
        int Ad3;
        int Ad2;
        int Ad1;
        if (this.S == null) {
            this.initializeTables(maxN);
        }
        int Nlog2 = this.log2(maxN);
        this.BitRevRArr(x, base, Nlog2, maxN);
        int gpSize = 2;
        int numGps = maxN / 4;
        int gpNum = 0;
        while (gpNum < numGps) {
            Ad1 = gpNum * 4;
            Ad2 = Ad1 + 1;
            Ad3 = Ad1 + gpSize;
            Ad4 = Ad2 + gpSize;
            rt1 = x[base + Ad1] + x[base + Ad2];
            rt2 = x[base + Ad1] - x[base + Ad2];
            float rt3 = x[base + Ad3] + x[base + Ad4];
            float rt4 = x[base + Ad3] - x[base + Ad4];
            x[base + Ad1] = rt1 + rt3;
            x[base + Ad2] = rt2 + rt4;
            x[base + Ad3] = rt1 - rt3;
            x[base + Ad4] = rt2 - rt4;
            ++gpNum;
        }
        if (Nlog2 > 2) {
            gpSize = 4;
            int numBfs = 2;
            numGps /= 2;
            int stage = 2;
            while (stage < Nlog2) {
                gpNum = 0;
                while (gpNum < numGps) {
                    int Ad0;
                    Ad1 = Ad0 = gpNum * gpSize * 2;
                    Ad2 = Ad1 + gpSize;
                    Ad3 = Ad1 + gpSize / 2;
                    Ad4 = Ad3 + gpSize;
                    rt1 = x[base + Ad1];
                    x[base + Ad1] = x[base + Ad1] + x[base + Ad2];
                    x[base + Ad2] = rt1 - x[base + Ad2];
                    rt1 = x[base + Ad3];
                    x[base + Ad3] = x[base + Ad3] + x[base + Ad4];
                    x[base + Ad4] = rt1 - x[base + Ad4];
                    int bfNum = 1;
                    while (bfNum < numBfs) {
                        Ad1 = bfNum + Ad0;
                        Ad2 = Ad1 + gpSize;
                        Ad3 = gpSize - bfNum + Ad0;
                        Ad4 = Ad3 + gpSize;
                        int CSAd = bfNum * numGps;
                        rt1 = x[base + Ad2] * this.C[CSAd] + x[base + Ad4] * this.S[CSAd];
                        rt2 = x[base + Ad4] * this.C[CSAd] - x[base + Ad2] * this.S[CSAd];
                        x[base + Ad2] = x[base + Ad1] - rt1;
                        x[base + Ad1] = x[base + Ad1] + rt1;
                        x[base + Ad4] = x[base + Ad3] + rt2;
                        x[base + Ad3] = x[base + Ad3] - rt2;
                        ++bfNum;
                    }
                    ++gpNum;
                }
                gpSize *= 2;
                numBfs *= 2;
                numGps /= 2;
                ++stage;
            }
        }
        if (inverse) {
            int i = 0;
            while (i < maxN) {
                x[base + i] = x[base + i] / (float)maxN;
                ++i;
            }
        }
    }

    void transposeR(float[] x, int maxN) {
        int r = 0;
        while (r < maxN) {
            int c = r;
            while (c < maxN) {
                if (r != c) {
                    float rTemp = x[r * maxN + c];
                    x[r * maxN + c] = x[c * maxN + r];
                    x[c * maxN + r] = rTemp;
                }
                ++c;
            }
            ++r;
        }
    }

    int log2(int x) {
        int count = 15;
        if (x > 32768) {
            count = 31;
        }
        while (!this.btst(x, count)) {
            --count;
        }
        return count;
    }

    private boolean btst(int x, int bit) {
        return (x & 1 << bit) != 0;
    }

    void BitRevRArr(float[] x, int base, int bitlen, int maxN) {
        int i = 0;
        while (i < maxN) {
            this.tempArr[i] = x[base + this.bitrev[i]];
            ++i;
        }
        i = 0;
        while (i < maxN) {
            x[base + i] = this.tempArr[i];
            ++i;
        }
    }

    private int bitRevX(int x, int bitlen) {
        int temp = 0;
        int i = 0;
        while (i <= bitlen) {
            if ((x & 1 << i) != 0) {
                temp |= 1 << bitlen - i - 1;
            }
            ++i;
        }
        return temp & 0xFFFF;
    }

    private int bset(int x, int bit) {
        return x |= 1 << bit;
    }

    public ImageProcessor getPowerSpectrum() {
        ImagePlus imp2;
        float r;
        int col;
        int base;
        if (!this.isFrequencyDomain) {
            throw new IllegalArgumentException("Frequency domain image required");
        }
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        float[] fps = new float[this.maxN * this.maxN];
        byte[] ps = new byte[this.maxN * this.maxN];
        float[] fht = (float[])this.getPixels();
        int row = 0;
        while (row < this.maxN) {
            this.FHTps(row, this.maxN, fht, fps);
            base = row * this.maxN;
            col = 0;
            while (col < this.maxN) {
                r = fps[base + col];
                if (r < min) {
                    min = r;
                }
                if (r > max) {
                    max = r;
                }
                ++col;
            }
            ++row;
        }
        min = (double)min < 1.0 ? 0.0f : (float)Math.log(min);
        max = (float)Math.log(max);
        float scale = (float)(253.0 / (double)(max - min));
        row = 0;
        while (row < this.maxN) {
            base = row * this.maxN;
            col = 0;
            while (col < this.maxN) {
                r = fps[base + col];
                r = r < 1.0f ? 0.0f : (float)Math.log(r);
                ps[base + col] = (byte)((double)((r - min) * scale) + 0.5 + 1.0);
                ++col;
            }
            ++row;
        }
        ByteProcessor ip = new ByteProcessor(this.maxN, this.maxN, ps, null);
        this.swapQuadrants(ip);
        if (FFT.displayRawPS) {
            FloatProcessor ip2 = new FloatProcessor(this.maxN, this.maxN, fps, null);
            this.swapQuadrants(ip2);
            new ImagePlus("PS of " + FFT.fileName, ip2).show();
        }
        if (FFT.displayFHT) {
            FloatProcessor ip3 = new FloatProcessor(this.maxN, this.maxN, fht, null);
            imp2 = new ImagePlus("FHT of " + FFT.fileName, ((ImageProcessor)ip3).duplicate());
            new ContrastEnhancer().stretchHistogram(imp2, 0.1);
            imp2.show();
        }
        if (FFT.displayComplex) {
            ImageStack ct = this.getComplexTransform();
            imp2 = new ImagePlus("Complex of " + FFT.fileName, ct);
            new ContrastEnhancer().stretchHistogram(imp2, 0.1);
            imp2.setProperty("FFT width", "" + this.originalWidth);
            imp2.setProperty("FFT height", "" + this.originalHeight);
            imp2.show();
        }
        return ip;
    }

    void FHTps(int row, int maxN, float[] fht, float[] ps) {
        int base = row * maxN;
        int c = 0;
        while (c < maxN) {
            int l = (maxN - row) % maxN * maxN + (maxN - c) % maxN;
            ps[base + c] = (this.sqr(fht[base + c]) + this.sqr(fht[l])) / 2.0f;
            ++c;
        }
    }

    public ImageStack getComplexTransform() {
        if (!this.isFrequencyDomain) {
            throw new IllegalArgumentException("Frequency domain image required");
        }
        float[] fht = (float[])this.getPixels();
        float[] re = new float[this.maxN * this.maxN];
        float[] im = new float[this.maxN * this.maxN];
        int i = 0;
        while (i < this.maxN) {
            this.FHTreal(i, this.maxN, fht, re);
            this.FHTimag(i, this.maxN, fht, im);
            ++i;
        }
        this.swapQuadrants(new FloatProcessor(this.maxN, this.maxN, re, null));
        this.swapQuadrants(new FloatProcessor(this.maxN, this.maxN, im, null));
        ImageStack stack = new ImageStack(this.maxN, this.maxN);
        stack.addSlice("Real", re);
        stack.addSlice("Imaginary", im);
        return stack;
    }

    void FHTreal(int row, int maxN, float[] fht, float[] real) {
        int base = row * maxN;
        int offs = (maxN - row) % maxN * maxN;
        int c = 0;
        while (c < maxN) {
            real[base + c] = (fht[base + c] + fht[offs + (maxN - c) % maxN]) * 0.5f;
            ++c;
        }
    }

    void FHTimag(int row, int maxN, float[] fht, float[] imag) {
        int base = row * maxN;
        int offs = (maxN - row) % maxN * maxN;
        int c = 0;
        while (c < maxN) {
            imag[base + c] = (-fht[base + c] + fht[offs + (maxN - c) % maxN]) * 0.5f;
            ++c;
        }
    }

    ImageProcessor calculateAmplitude(float[] fht, int maxN) {
        float[] amp = new float[maxN * maxN];
        int row = 0;
        while (row < maxN) {
            this.amplitude(row, maxN, fht, amp);
            ++row;
        }
        FloatProcessor ip = new FloatProcessor(maxN, maxN, amp, null);
        this.swapQuadrants(ip);
        return ip;
    }

    void amplitude(int row, int maxN, float[] fht, float[] amplitude) {
        int base = row * maxN;
        int c = 0;
        while (c < maxN) {
            int l = (maxN - row) % maxN * maxN + (maxN - c) % maxN;
            amplitude[base + c] = (float)Math.sqrt(this.sqr(fht[base + c]) + this.sqr(fht[l]));
            ++c;
        }
    }

    float sqr(float x) {
        return x * x;
    }

    public void swapQuadrants(ImageProcessor ip) {
        int size = ip.getWidth() / 2;
        ip.setRoi(size, 0, size, size);
        ImageProcessor t1 = ip.crop();
        ip.setRoi(0, size, size, size);
        ImageProcessor t2 = ip.crop();
        ip.insert(t1, 0, size);
        ip.insert(t2, size, 0);
        ip.setRoi(0, 0, size, size);
        t1 = ip.crop();
        ip.setRoi(size, size, size, size);
        t2 = ip.crop();
        ip.insert(t1, size, size);
        ip.insert(t2, 0, 0);
        ip.resetRoi();
    }

    public void swapQuadrants() {
        this.swapQuadrants(this);
    }

    void changeValues(ImageProcessor ip, int v1, int v2, int v3) {
        byte[] pixels = (byte[])ip.getPixels();
        int i = 0;
        while (i < pixels.length) {
            int v = pixels[i] & 0xFF;
            if (v >= v1 && v <= v2) {
                pixels[i] = (byte)v3;
            }
            ++i;
        }
    }

    public FHT multiply(FHT fht) {
        return this.multiply(fht, false);
    }

    public FHT conjugateMultiply(FHT fht) {
        return this.multiply(fht, true);
    }

    FHT multiply(FHT fht, boolean conjugate) {
        float[] h1 = (float[])this.getPixels();
        float[] h2 = (float[])fht.getPixels();
        float[] tmp = new float[this.maxN * this.maxN];
        int r = 0;
        while (r < this.maxN) {
            int rowMod = (this.maxN - r) % this.maxN;
            int c = 0;
            while (c < this.maxN) {
                int colMod = (this.maxN - c) % this.maxN;
                double h2e = (h2[r * this.maxN + c] + h2[rowMod * this.maxN + colMod]) / 2.0f;
                double h2o = (h2[r * this.maxN + c] - h2[rowMod * this.maxN + colMod]) / 2.0f;
                tmp[r * this.maxN + c] = conjugate ? (float)((double)h1[r * this.maxN + c] * h2e - (double)h1[rowMod * this.maxN + colMod] * h2o) : (float)((double)h1[r * this.maxN + c] * h2e + (double)h1[rowMod * this.maxN + colMod] * h2o);
                ++c;
            }
            ++r;
        }
        FHT fht2 = new FHT(new FloatProcessor(this.maxN, this.maxN, tmp, null));
        fht2.isFrequencyDomain = true;
        return fht2;
    }

    public FHT divide(FHT fht) {
        float[] h1 = (float[])this.getPixels();
        float[] h2 = (float[])fht.getPixels();
        float[] out = new float[this.maxN * this.maxN];
        int r = 0;
        while (r < this.maxN) {
            int rowMod = (this.maxN - r) % this.maxN;
            int c = 0;
            while (c < this.maxN) {
                int colMod = (this.maxN - c) % this.maxN;
                double mag = h2[r * this.maxN + c] * h2[r * this.maxN + c] + h2[rowMod * this.maxN + colMod] * h2[rowMod * this.maxN + colMod];
                if (mag < 1.0E-20) {
                    mag = 1.0E-20;
                }
                double h2e = h2[r * this.maxN + c] + h2[rowMod * this.maxN + colMod];
                double h2o = h2[r * this.maxN + c] - h2[rowMod * this.maxN + colMod];
                double tmp = (double)h1[r * this.maxN + c] * h2e - (double)h1[rowMod * this.maxN + colMod] * h2o;
                out[r * this.maxN + c] = (float)(tmp / mag);
                ++c;
            }
            ++r;
        }
        FHT fht2 = new FHT(new FloatProcessor(this.maxN, this.maxN, out, null));
        fht2.isFrequencyDomain = true;
        return fht2;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public FHT getCopy() {
        ImageProcessor ip = super.duplicate();
        FHT fht = new FHT(ip);
        fht.isFrequencyDomain = this.isFrequencyDomain;
        fht.quadrantSwapNeeded = this.quadrantSwapNeeded;
        fht.rgb = this.rgb;
        fht.originalWidth = this.originalWidth;
        fht.originalHeight = this.originalHeight;
        fht.originalBitDepth = this.originalBitDepth;
        fht.originalColorModel = this.originalColorModel;
        return fht;
    }

    public String toString() {
        return "FHT, " + this.getWidth() + "x" + this.getHeight() + ", fd=" + this.isFrequencyDomain;
    }
}

