/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.VirtualStack;
import ij.io.FileInfo;
import ij.process.ImageProcessor;
import java.io.IOException;
import java.io.OutputStream;

public class ImageWriter {
    private FileInfo fi;
    private boolean showProgressBar = true;

    public ImageWriter(FileInfo fi) {
        this.fi = fi;
    }

    private void showProgress(double progress) {
        if (this.showProgressBar) {
            IJ.showProgress(progress);
        }
    }

    void write8BitImage(OutputStream out, byte[] pixels) throws IOException {
        int bytesWritten = 0;
        int size = this.fi.width * this.fi.height;
        int count = 8192;
        while (bytesWritten < size) {
            if (bytesWritten + count > size) {
                count = size - bytesWritten;
            }
            out.write(pixels, bytesWritten, count);
            this.showProgress((double)(bytesWritten += count) / (double)size);
        }
    }

    void write8BitStack(OutputStream out, Object[] stack) throws IOException {
        this.showProgressBar = false;
        int i = 0;
        while (i < this.fi.nImages) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.write8BitImage(out, (byte[])stack[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
            ++i;
        }
    }

    void write8BitVirtualStack(OutputStream out, VirtualStack virtualStack) throws IOException {
        this.showProgressBar = false;
        boolean flip = "FlipTheseImages".equals(this.fi.fileName);
        int i = 1;
        while (i <= this.fi.nImages) {
            IJ.showStatus("Writing: " + i + "/" + this.fi.nImages);
            ImageProcessor ip = virtualStack.getProcessor(i);
            if (flip) {
                ip.flipVertical();
            }
            byte[] pixels = (byte[])ip.getPixels();
            this.write8BitImage(out, pixels);
            IJ.showProgress((double)i / (double)this.fi.nImages);
            ++i;
        }
    }

    void write16BitImage(OutputStream out, short[] pixels) throws IOException {
        long bytesWritten = 0L;
        long size = 2L * (long)this.fi.width * (long)this.fi.height;
        int count = 8192;
        byte[] buffer = new byte[count];
        while (bytesWritten < size) {
            short value;
            int i;
            if (bytesWritten + (long)count > size) {
                count = (int)(size - bytesWritten);
            }
            int j = (int)(bytesWritten / 2L);
            if (this.fi.intelByteOrder) {
                i = 0;
                while (i < count) {
                    value = pixels[j];
                    buffer[i] = (byte)value;
                    buffer[i + 1] = (byte)(value >>> 8);
                    ++j;
                    i += 2;
                }
            } else {
                i = 0;
                while (i < count) {
                    value = pixels[j];
                    buffer[i] = (byte)(value >>> 8);
                    buffer[i + 1] = (byte)value;
                    ++j;
                    i += 2;
                }
            }
            out.write(buffer, 0, count);
            this.showProgress((double)(bytesWritten += (long)count) / (double)size);
        }
    }

    void write16BitStack(OutputStream out, Object[] stack) throws IOException {
        this.showProgressBar = false;
        int i = 0;
        while (i < this.fi.nImages) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.write16BitImage(out, (short[])stack[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
            ++i;
        }
    }

    void write16BitVirtualStack(OutputStream out, VirtualStack virtualStack) throws IOException {
        this.showProgressBar = false;
        boolean flip = "FlipTheseImages".equals(this.fi.fileName);
        int i = 1;
        while (i <= this.fi.nImages) {
            IJ.showStatus("Writing: " + i + "/" + this.fi.nImages);
            ImageProcessor ip = virtualStack.getProcessor(i);
            if (flip) {
                ip.flipVertical();
            }
            short[] pixels = (short[])ip.getPixels();
            this.write16BitImage(out, pixels);
            IJ.showProgress((double)i / (double)this.fi.nImages);
            ++i;
        }
    }

    void writeRGB48Image(OutputStream out, Object[] stack) throws IOException {
        short[] r = (short[])stack[0];
        short[] g = (short[])stack[1];
        short[] b = (short[])stack[2];
        int size = this.fi.width * this.fi.height;
        int count = this.fi.width * 6;
        byte[] buffer = new byte[count];
        int line = 0;
        while (line < this.fi.height) {
            short value;
            int i;
            int index2 = 0;
            int index1 = line * this.fi.width;
            if (this.fi.intelByteOrder) {
                i = 0;
                while (i < this.fi.width) {
                    value = r[index1];
                    buffer[index2++] = (byte)value;
                    buffer[index2++] = (byte)(value >>> 8);
                    value = g[index1];
                    buffer[index2++] = (byte)value;
                    buffer[index2++] = (byte)(value >>> 8);
                    value = b[index1];
                    buffer[index2++] = (byte)value;
                    buffer[index2++] = (byte)(value >>> 8);
                    ++index1;
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.fi.width) {
                    value = r[index1];
                    buffer[index2++] = (byte)(value >>> 8);
                    buffer[index2++] = (byte)value;
                    value = g[index1];
                    buffer[index2++] = (byte)(value >>> 8);
                    buffer[index2++] = (byte)value;
                    value = b[index1];
                    buffer[index2++] = (byte)(value >>> 8);
                    buffer[index2++] = (byte)value;
                    ++index1;
                    ++i;
                }
            }
            out.write(buffer, 0, count);
            ++line;
        }
    }

    void writeFloatImage(OutputStream out, float[] pixels) throws IOException {
        long bytesWritten = 0L;
        long size = 4L * (long)this.fi.width * (long)this.fi.height;
        int count = 8192;
        byte[] buffer = new byte[count];
        while (bytesWritten < size) {
            int tmp;
            int i;
            if (bytesWritten + (long)count > size) {
                count = (int)(size - bytesWritten);
            }
            int j = (int)(bytesWritten / 4L);
            if (this.fi.intelByteOrder) {
                i = 0;
                while (i < count) {
                    tmp = Float.floatToRawIntBits(pixels[j]);
                    buffer[i] = (byte)tmp;
                    buffer[i + 1] = (byte)(tmp >> 8);
                    buffer[i + 2] = (byte)(tmp >> 16);
                    buffer[i + 3] = (byte)(tmp >> 24);
                    ++j;
                    i += 4;
                }
            } else {
                i = 0;
                while (i < count) {
                    tmp = Float.floatToRawIntBits(pixels[j]);
                    buffer[i] = (byte)(tmp >> 24);
                    buffer[i + 1] = (byte)(tmp >> 16);
                    buffer[i + 2] = (byte)(tmp >> 8);
                    buffer[i + 3] = (byte)tmp;
                    ++j;
                    i += 4;
                }
            }
            out.write(buffer, 0, count);
            this.showProgress((double)(bytesWritten += (long)count) / (double)size);
        }
    }

    void writeFloatStack(OutputStream out, Object[] stack) throws IOException {
        this.showProgressBar = false;
        int i = 0;
        while (i < this.fi.nImages) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.writeFloatImage(out, (float[])stack[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
            ++i;
        }
    }

    void writeFloatVirtualStack(OutputStream out, VirtualStack virtualStack) throws IOException {
        this.showProgressBar = false;
        boolean flip = "FlipTheseImages".equals(this.fi.fileName);
        int i = 1;
        while (i <= this.fi.nImages) {
            IJ.showStatus("Writing: " + i + "/" + this.fi.nImages);
            ImageProcessor ip = virtualStack.getProcessor(i);
            if (flip) {
                ip.flipVertical();
            }
            float[] pixels = (float[])ip.getPixels();
            this.writeFloatImage(out, pixels);
            IJ.showProgress((double)i / (double)this.fi.nImages);
            ++i;
        }
    }

    void writeRGBImage(OutputStream out, int[] pixels) throws IOException {
        long bytesWritten = 0L;
        long size = 3L * (long)this.fi.width * (long)this.fi.height;
        int count = this.fi.width * 24;
        byte[] buffer = new byte[count];
        while (bytesWritten < size) {
            if (bytesWritten + (long)count > size) {
                count = (int)(size - bytesWritten);
            }
            int j = (int)(bytesWritten / 3L);
            int i = 0;
            while (i < count) {
                buffer[i] = (byte)(pixels[j] >> 16);
                buffer[i + 1] = (byte)(pixels[j] >> 8);
                buffer[i + 2] = (byte)pixels[j];
                ++j;
                i += 3;
            }
            out.write(buffer, 0, count);
            this.showProgress((double)(bytesWritten += (long)count) / (double)size);
        }
    }

    void writeRGBStack(OutputStream out, Object[] stack) throws IOException {
        this.showProgressBar = false;
        int i = 0;
        while (i < this.fi.nImages) {
            IJ.showStatus("Writing: " + (i + 1) + "/" + this.fi.nImages);
            this.writeRGBImage(out, (int[])stack[i]);
            IJ.showProgress((double)(i + 1) / (double)this.fi.nImages);
            ++i;
        }
    }

    void writeRGBVirtualStack(OutputStream out, VirtualStack virtualStack) throws IOException {
        this.showProgressBar = false;
        boolean flip = "FlipTheseImages".equals(this.fi.fileName);
        int i = 1;
        while (i <= this.fi.nImages) {
            IJ.showStatus("Writing: " + i + "/" + this.fi.nImages);
            ImageProcessor ip = virtualStack.getProcessor(i);
            if (flip) {
                ip.flipVertical();
            }
            int[] pixels = (int[])ip.getPixels();
            this.writeRGBImage(out, pixels);
            IJ.showProgress((double)i / (double)this.fi.nImages);
            ++i;
        }
    }

    public void write(OutputStream out) throws IOException {
        if (this.fi.pixels == null && this.fi.virtualStack == null) {
            throw new IOException("ImageWriter: fi.pixels==null");
        }
        if (this.fi.nImages > 1 && this.fi.virtualStack == null && !(this.fi.pixels instanceof Object[])) {
            throw new IOException("ImageWriter: fi.pixels not a stack");
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: {
                if (this.fi.nImages > 1 && this.fi.virtualStack != null) {
                    this.write8BitVirtualStack(out, this.fi.virtualStack);
                    break;
                }
                if (this.fi.nImages > 1) {
                    this.write8BitStack(out, (Object[])this.fi.pixels);
                    break;
                }
                this.write8BitImage(out, (byte[])this.fi.pixels);
                break;
            }
            case 1: 
            case 2: {
                if (this.fi.nImages > 1 && this.fi.virtualStack != null) {
                    this.write16BitVirtualStack(out, this.fi.virtualStack);
                    break;
                }
                if (this.fi.nImages > 1) {
                    this.write16BitStack(out, (Object[])this.fi.pixels);
                    break;
                }
                this.write16BitImage(out, (short[])this.fi.pixels);
                break;
            }
            case 12: {
                this.writeRGB48Image(out, (Object[])this.fi.pixels);
                break;
            }
            case 4: {
                if (this.fi.nImages > 1 && this.fi.virtualStack != null) {
                    this.writeFloatVirtualStack(out, this.fi.virtualStack);
                    break;
                }
                if (this.fi.nImages > 1) {
                    this.writeFloatStack(out, (Object[])this.fi.pixels);
                    break;
                }
                this.writeFloatImage(out, (float[])this.fi.pixels);
                break;
            }
            case 6: {
                if (this.fi.nImages > 1 && this.fi.virtualStack != null) {
                    this.writeRGBVirtualStack(out, this.fi.virtualStack);
                    break;
                }
                if (this.fi.nImages > 1) {
                    this.writeRGBStack(out, (Object[])this.fi.pixels);
                    break;
                }
                this.writeRGBImage(out, (int[])this.fi.pixels);
            }
        }
    }
}

