/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel.charts;

import com.fr.third.v2.org.apache.poi.ss.usermodel.Chart;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.ChartAxis;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.ChartDataSource;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.LineChartData;
import com.fr.third.v2.org.apache.poi.ss.usermodel.charts.LineChartSeries;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFChart;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.charts.AbstractXSSFChartSeries;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.charts.XSSFChartUtil;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTLineChart;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTLineSer;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import com.fr.third.v2.org.openxmlformats.schemas.drawingml.x2006.chart.STMarkerStyle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFLineChartData
implements LineChartData {
    private List<Series> series = new ArrayList<Series>();

    @Override
    public LineChartSeries addSeries(ChartDataSource<?> categoryAxisData, ChartDataSource<? extends Number> values) {
        if (!values.isNumeric()) {
            throw new IllegalArgumentException("Value data source must be numeric.");
        }
        int numOfSeries = this.series.size();
        Series newSeries = new Series(numOfSeries, numOfSeries, categoryAxisData, values);
        this.series.add(newSeries);
        return newSeries;
    }

    @Override
    public List<? extends LineChartSeries> getSeries() {
        return this.series;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        XSSFChart xssfChart = (XSSFChart)chart;
        CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
        CTLineChart lineChart = plotArea.addNewLineChart();
        lineChart.addNewVaryColors().setVal(false);
        for (Series s : this.series) {
            s.addToChart(lineChart);
        }
        for (ChartAxis ax : axis) {
            lineChart.addNewAxId().setVal(ax.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Series
    extends AbstractXSSFChartSeries
    implements LineChartSeries {
        private int id;
        private int order;
        private ChartDataSource<?> categories;
        private ChartDataSource<? extends Number> values;

        protected Series(int id, int order, ChartDataSource<?> categories, ChartDataSource<? extends Number> values) {
            this.id = id;
            this.order = order;
            this.categories = categories;
            this.values = values;
        }

        @Override
        public ChartDataSource<?> getCategoryAxisData() {
            return this.categories;
        }

        @Override
        public ChartDataSource<? extends Number> getValues() {
            return this.values;
        }

        protected void addToChart(CTLineChart ctLineChart) {
            CTLineSer ctLineSer = ctLineChart.addNewSer();
            ctLineSer.addNewIdx().setVal(this.id);
            ctLineSer.addNewOrder().setVal(this.order);
            ctLineSer.addNewMarker().addNewSymbol().setVal(STMarkerStyle.NONE);
            CTAxDataSource catDS = ctLineSer.addNewCat();
            XSSFChartUtil.buildAxDataSource(catDS, this.categories);
            CTNumDataSource valueDS = ctLineSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(valueDS, this.values);
            if (this.isTitleSet()) {
                ctLineSer.setTx(this.getCTSerTx());
            }
        }
    }
}

