/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.formula;

import com.fr.third.v2.org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationCache;
import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationCell;
import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationName;
import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationSheet;
import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationTracker;
import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationWorkbook;
import com.fr.third.v2.org.apache.poi.ss.formula.FormulaCellCacheEntry;
import com.fr.third.v2.org.apache.poi.ss.formula.IEvaluationListener;
import com.fr.third.v2.org.apache.poi.ss.formula.IStabilityClassifier;
import com.fr.third.v2.org.apache.poi.ss.formula.OperationEvaluationContext;
import com.fr.third.v2.org.apache.poi.ss.formula.OperationEvaluatorFactory;
import com.fr.third.v2.org.apache.poi.ss.formula.atp.AnalysisToolPak;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.BlankEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.BoolEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ErrorEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.EvaluationException;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ExternalNameEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.FunctionEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.FunctionNameEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.MissingArgEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.NotImplementedException;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.NumberEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.OperandResolver;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.StringEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ValueEval;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.Choose;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.Function;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.IfFunc;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.Area3DPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.Area3DPxg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.AreaErrPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.AreaPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.AttrPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.BoolPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.ControlPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.DeletedArea3DPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.DeletedRef3DPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.ErrPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.ExpPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.FuncVarPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.IntPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.MemAreaPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.MemErrPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.MemFuncPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.MissingArgPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.NamePtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.NameXPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.NameXPxg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.NumberPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.OperationPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.Ptg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.Ref3DPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.Ref3DPxg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.RefErrorPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.RefPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.StringPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.UnionPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.UnknownPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.udf.AggregatingUDFFinder;
import com.fr.third.v2.org.apache.poi.ss.formula.udf.UDFFinder;
import com.fr.third.v2.org.apache.poi.ss.util.CellReference;
import com.fr.third.v2.org.apache.poi.util.POILogFactory;
import com.fr.third.v2.org.apache.poi.util.POILogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkbookEvaluator {
    private static final POILogger LOG = POILogFactory.getLogger(WorkbookEvaluator.class);
    private final EvaluationWorkbook _workbook;
    private EvaluationCache _cache;
    private int _workbookIx;
    private final IEvaluationListener _evaluationListener;
    private final Map<EvaluationSheet, Integer> _sheetIndexesBySheet;
    private final Map<String, Integer> _sheetIndexesByName;
    private CollaboratingWorkbooksEnvironment _collaboratingWorkbookEnvironment;
    private final IStabilityClassifier _stabilityClassifier;
    private final AggregatingUDFFinder _udfFinder;
    private boolean _ignoreMissingWorkbooks = false;
    private boolean dbgEvaluationOutputForNextEval = false;
    private final POILogger EVAL_LOG = POILogFactory.getLogger("POI.FormulaEval");
    private int dbgEvaluationOutputIndent = -1;

    public WorkbookEvaluator(EvaluationWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        this(workbook, null, stabilityClassifier, udfFinder);
    }

    WorkbookEvaluator(EvaluationWorkbook workbook, IEvaluationListener evaluationListener, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        AggregatingUDFFinder defaultToolkit;
        this._workbook = workbook;
        this._evaluationListener = evaluationListener;
        this._cache = new EvaluationCache(evaluationListener);
        this._sheetIndexesBySheet = new IdentityHashMap<EvaluationSheet, Integer>();
        this._sheetIndexesByName = new IdentityHashMap<String, Integer>();
        this._collaboratingWorkbookEnvironment = CollaboratingWorkbooksEnvironment.EMPTY;
        this._workbookIx = 0;
        this._stabilityClassifier = stabilityClassifier;
        AggregatingUDFFinder aggregatingUDFFinder = defaultToolkit = workbook == null ? null : (AggregatingUDFFinder)workbook.getUDFFinder();
        if (defaultToolkit != null && udfFinder != null) {
            defaultToolkit.add(udfFinder);
        }
        this._udfFinder = defaultToolkit;
    }

    String getSheetName(int sheetIndex) {
        return this._workbook.getSheetName(sheetIndex);
    }

    EvaluationSheet getSheet(int sheetIndex) {
        return this._workbook.getSheet(sheetIndex);
    }

    EvaluationWorkbook getWorkbook() {
        return this._workbook;
    }

    EvaluationName getName(String name, int sheetIndex) {
        EvaluationName evalName = this._workbook.getName(name, sheetIndex);
        return evalName;
    }

    private static boolean isDebugLogEnabled() {
        return LOG.check(1);
    }

    private static boolean isInfoLogEnabled() {
        return LOG.check(3);
    }

    private static void logDebug(String s) {
        if (WorkbookEvaluator.isDebugLogEnabled()) {
            LOG.log(1, new Object[]{s});
        }
    }

    private static void logInfo(String s) {
        if (WorkbookEvaluator.isInfoLogEnabled()) {
            LOG.log(3, new Object[]{s});
        }
    }

    void attachToEnvironment(CollaboratingWorkbooksEnvironment collaboratingWorkbooksEnvironment, EvaluationCache cache, int workbookIx) {
        this._collaboratingWorkbookEnvironment = collaboratingWorkbooksEnvironment;
        this._cache = cache;
        this._workbookIx = workbookIx;
    }

    CollaboratingWorkbooksEnvironment getEnvironment() {
        return this._collaboratingWorkbookEnvironment;
    }

    void detachFromEnvironment() {
        this._collaboratingWorkbookEnvironment = CollaboratingWorkbooksEnvironment.EMPTY;
        this._cache = new EvaluationCache(this._evaluationListener);
        this._workbookIx = 0;
    }

    WorkbookEvaluator getOtherWorkbookEvaluator(String workbookName) throws CollaboratingWorkbooksEnvironment.WorkbookNotFoundException {
        return this._collaboratingWorkbookEnvironment.getWorkbookEvaluator(workbookName);
    }

    IEvaluationListener getEvaluationListener() {
        return this._evaluationListener;
    }

    public void clearAllCachedResultValues() {
        this._cache.clear();
        this._sheetIndexesBySheet.clear();
    }

    public void notifyUpdateCell(EvaluationCell cell) {
        int sheetIndex = this.getSheetIndex(cell.getSheet());
        this._cache.notifyUpdateCell(this._workbookIx, sheetIndex, cell);
    }

    public void notifyDeleteCell(EvaluationCell cell) {
        int sheetIndex = this.getSheetIndex(cell.getSheet());
        this._cache.notifyDeleteCell(this._workbookIx, sheetIndex, cell);
    }

    private int getSheetIndex(EvaluationSheet sheet) {
        Integer result = this._sheetIndexesBySheet.get(sheet);
        if (result == null) {
            int sheetIndex = this._workbook.getSheetIndex(sheet);
            if (sheetIndex < 0) {
                throw new RuntimeException("Specified sheet from a different book");
            }
            result = sheetIndex;
            this._sheetIndexesBySheet.put(sheet, result);
        }
        return result;
    }

    public ValueEval evaluate(EvaluationCell srcCell) {
        int sheetIndex = this.getSheetIndex(srcCell.getSheet());
        return this.evaluateAny(srcCell, sheetIndex, srcCell.getRowIndex(), srcCell.getColumnIndex(), new EvaluationTracker(this._cache));
    }

    int getSheetIndex(String sheetName) {
        Integer result = this._sheetIndexesByName.get(sheetName);
        if (result == null) {
            int sheetIndex = this._workbook.getSheetIndex(sheetName);
            if (sheetIndex < 0) {
                return -1;
            }
            result = sheetIndex;
            this._sheetIndexesByName.put(sheetName, result);
        }
        return result;
    }

    int getSheetIndexByExternIndex(int externSheetIndex) {
        return this._workbook.convertFromExternSheetIndex(externSheetIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueEval evaluateAny(EvaluationCell srcCell, int sheetIndex, int rowIndex, int columnIndex, EvaluationTracker tracker) {
        ValueEval result;
        boolean shouldCellDependencyBeRecorded;
        boolean bl = this._stabilityClassifier == null ? true : (shouldCellDependencyBeRecorded = !this._stabilityClassifier.isCellFinal(sheetIndex, rowIndex, columnIndex));
        if (srcCell == null || srcCell.getCellType() != 2) {
            ValueEval result2 = WorkbookEvaluator.getValueFromNonFormulaCell(srcCell);
            if (shouldCellDependencyBeRecorded) {
                tracker.acceptPlainValueDependency(this._workbookIx, sheetIndex, rowIndex, columnIndex, result2);
            }
            return result2;
        }
        FormulaCellCacheEntry cce = this._cache.getOrCreateFormulaCellEntry(srcCell);
        if (shouldCellDependencyBeRecorded || cce.isInputSensitive()) {
            tracker.acceptFormulaDependency(cce);
        }
        IEvaluationListener evalListener = this._evaluationListener;
        if (cce.getValue() == null) {
            if (!tracker.startEvaluate(cce)) {
                return ErrorEval.CIRCULAR_REF_ERROR;
            }
            OperationEvaluationContext ec = new OperationEvaluationContext(this, this._workbook, sheetIndex, rowIndex, columnIndex, tracker);
            try {
                Ptg[] ptgs = this._workbook.getFormulaTokens(srcCell);
                if (evalListener == null) {
                    result = this.evaluateFormula(ec, ptgs);
                } else {
                    evalListener.onStartEvaluate(srcCell, cce);
                    result = this.evaluateFormula(ec, ptgs);
                    evalListener.onEndEvaluate(cce, result);
                }
                tracker.updateCacheResult(result);
            }
            catch (NotImplementedException e) {
                throw this.addExceptionInfo(e, sheetIndex, rowIndex, columnIndex);
            }
            catch (RuntimeException re) {
                if (re.getCause() instanceof CollaboratingWorkbooksEnvironment.WorkbookNotFoundException && this._ignoreMissingWorkbooks) {
                    WorkbookEvaluator.logInfo(re.getCause().getMessage() + " - Continuing with cached value!");
                    switch (srcCell.getCachedFormulaResultType()) {
                        case 0: {
                            result = new NumberEval(srcCell.getNumericCellValue());
                        }
                        case 1: {
                            result = new StringEval(srcCell.getStringCellValue());
                        }
                        case 3: {
                            result = BlankEval.instance;
                        }
                        case 4: {
                            result = BoolEval.valueOf(srcCell.getBooleanCellValue());
                        }
                        case 5: {
                            result = ErrorEval.valueOf(srcCell.getErrorCellValue());
                        }
                        default: {
                            throw new RuntimeException("Unexpected cell type '" + srcCell.getCellType() + "' found!");
                        }
                    }
                }
                throw re;
            }
            finally {
                tracker.endEvaluate(cce);
            }
        } else {
            if (evalListener != null) {
                evalListener.onCacheHit(sheetIndex, rowIndex, columnIndex, cce.getValue());
            }
            return cce.getValue();
        }
        if (WorkbookEvaluator.isDebugLogEnabled()) {
            String sheetName = this.getSheetName(sheetIndex);
            CellReference cr = new CellReference(rowIndex, columnIndex);
            WorkbookEvaluator.logDebug("Evaluated " + sheetName + "!" + cr.formatAsString() + " to " + result.toString());
        }
        return result;
    }

    private NotImplementedException addExceptionInfo(NotImplementedException inner, int sheetIndex, int rowIndex, int columnIndex) {
        try {
            String sheetName = this._workbook.getSheetName(sheetIndex);
            CellReference cr = new CellReference(sheetName, rowIndex, columnIndex, false, false);
            String msg = "Error evaluating cell " + cr.formatAsString();
            return new NotImplementedException(msg, inner);
        }
        catch (Exception e) {
            LOG.log(7, new Object[]{"Can't add exception info", e});
            return inner;
        }
    }

    static ValueEval getValueFromNonFormulaCell(EvaluationCell cell) {
        if (cell == null) {
            return BlankEval.instance;
        }
        int cellType = cell.getCellType();
        switch (cellType) {
            case 0: {
                return new NumberEval(cell.getNumericCellValue());
            }
            case 1: {
                return new StringEval(cell.getStringCellValue());
            }
            case 4: {
                return BoolEval.valueOf(cell.getBooleanCellValue());
            }
            case 3: {
                return BlankEval.instance;
            }
            case 5: {
                return ErrorEval.valueOf(cell.getErrorCellValue());
            }
        }
        throw new RuntimeException("Unexpected cell type (" + cellType + ")");
    }

    ValueEval evaluateFormula(OperationEvaluationContext ec, Ptg[] ptgs) {
        String dbgIndentStr = "";
        if (this.dbgEvaluationOutputForNextEval) {
            this.dbgEvaluationOutputIndent = 1;
            this.dbgEvaluationOutputForNextEval = false;
        }
        if (this.dbgEvaluationOutputIndent > 0) {
            dbgIndentStr = "                                                                                                    ";
            dbgIndentStr = dbgIndentStr.substring(0, Math.min(dbgIndentStr.length(), this.dbgEvaluationOutputIndent * 2));
            this.EVAL_LOG.log(5, new Object[]{dbgIndentStr + "- evaluateFormula('" + ec.getRefEvaluatorForCurrentSheet().getSheetNameRange() + "'/" + new CellReference(ec.getRowIndex(), ec.getColumnIndex()).formatAsString() + "): " + Arrays.toString(ptgs).replaceAll("\\Qorg.apache.poi.ss.formula.ptg.\\E", "")});
            ++this.dbgEvaluationOutputIndent;
        }
        Stack<ValueEval> stack = new Stack<ValueEval>();
        int iSize = ptgs.length;
        for (int i = 0; i < iSize; ++i) {
            ValueEval opResult;
            Ptg ptg = ptgs[i];
            if (this.dbgEvaluationOutputIndent > 0) {
                this.EVAL_LOG.log(3, new Object[]{dbgIndentStr + "  * ptg " + i + ": " + ptg});
            }
            if (ptg instanceof AttrPtg) {
                AttrPtg attrPtg = (AttrPtg)ptg;
                if (attrPtg.isSum()) {
                    ptg = FuncVarPtg.SUM;
                }
                if (attrPtg.isOptimizedChoose()) {
                    int dist;
                    ValueEval arg0 = (ValueEval)stack.pop();
                    int[] jumpTable = attrPtg.getJumpTable();
                    int nChoices = jumpTable.length;
                    try {
                        int switchIndex = Choose.evaluateFirstArg(arg0, ec.getRowIndex(), ec.getColumnIndex());
                        if (switchIndex < 1 || switchIndex > nChoices) {
                            stack.push(ErrorEval.VALUE_INVALID);
                            dist = attrPtg.getChooseFuncOffset() + 4;
                        } else {
                            dist = jumpTable[switchIndex - 1];
                        }
                    }
                    catch (EvaluationException e) {
                        stack.push(e.getErrorEval());
                        dist = attrPtg.getChooseFuncOffset() + 4;
                    }
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist -= nChoices * 2 + 2);
                    continue;
                }
                if (attrPtg.isOptimizedIf()) {
                    boolean evaluatedPredicate;
                    ValueEval arg0 = (ValueEval)stack.pop();
                    try {
                        evaluatedPredicate = IfFunc.evaluateFirstArg(arg0, ec.getRowIndex(), ec.getColumnIndex());
                    }
                    catch (EvaluationException e) {
                        stack.push(e.getErrorEval());
                        int dist = attrPtg.getData();
                        i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist);
                        attrPtg = (AttrPtg)ptgs[i];
                        dist = attrPtg.getData() + 1;
                        i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist);
                        continue;
                    }
                    if (evaluatedPredicate) continue;
                    short dist = attrPtg.getData();
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist);
                    Ptg nextPtg = ptgs[i + 1];
                    if (!(ptgs[i] instanceof AttrPtg) || !(nextPtg instanceof FuncVarPtg) || ((FuncVarPtg)nextPtg).getFunctionIndex() != 1) continue;
                    ++i;
                    stack.push(BoolEval.FALSE);
                    continue;
                }
                if (attrPtg.isSkip()) {
                    int dist = attrPtg.getData() + 1;
                    i += WorkbookEvaluator.countTokensToBeSkipped(ptgs, i, dist);
                    if (stack.peek() != MissingArgEval.instance) continue;
                    stack.pop();
                    stack.push(BlankEval.instance);
                    continue;
                }
            }
            if (ptg instanceof ControlPtg || ptg instanceof MemFuncPtg || ptg instanceof MemAreaPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof OperationPtg) {
                OperationPtg optg = (OperationPtg)ptg;
                if (optg instanceof UnionPtg) continue;
                int numops = optg.getNumberOfOperands();
                ValueEval[] ops = new ValueEval[numops];
                for (int j = numops - 1; j >= 0; --j) {
                    ValueEval p;
                    ops[j] = p = (ValueEval)stack.pop();
                }
                opResult = OperationEvaluatorFactory.evaluate(optg, ops, ec);
            } else {
                opResult = this.getEvalForPtg(ptg, ec);
            }
            if (opResult == null) {
                throw new RuntimeException("Evaluation result must not be null");
            }
            stack.push(opResult);
            if (this.dbgEvaluationOutputIndent <= 0) continue;
            this.EVAL_LOG.log(3, new Object[]{dbgIndentStr + "    = " + opResult});
        }
        ValueEval value = (ValueEval)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("evaluation stack not empty");
        }
        ValueEval result = WorkbookEvaluator.dereferenceResult(value, ec.getRowIndex(), ec.getColumnIndex());
        if (this.dbgEvaluationOutputIndent > 0) {
            this.EVAL_LOG.log(3, new Object[]{dbgIndentStr + "finshed eval of " + new CellReference(ec.getRowIndex(), ec.getColumnIndex()).formatAsString() + ": " + result});
            --this.dbgEvaluationOutputIndent;
            if (this.dbgEvaluationOutputIndent == 1) {
                this.dbgEvaluationOutputIndent = -1;
            }
        }
        return result;
    }

    private static int countTokensToBeSkipped(Ptg[] ptgs, int startIndex, int distInBytes) {
        int remBytes = distInBytes;
        int index = startIndex;
        while (remBytes != 0) {
            if ((remBytes -= ptgs[++index].getSize()) < 0) {
                throw new RuntimeException("Bad skip distance (wrong token size calculation).");
            }
            if (index < ptgs.length) continue;
            throw new RuntimeException("Skip distance too far (ran out of formula tokens).");
        }
        return index - startIndex;
    }

    public static ValueEval dereferenceResult(ValueEval evaluationResult, int srcRowNum, int srcColNum) {
        ValueEval value;
        try {
            value = OperandResolver.getSingleValue(evaluationResult, srcRowNum, srcColNum);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        if (value == BlankEval.instance) {
            return NumberEval.ZERO;
        }
        return value;
    }

    private ValueEval getEvalForPtg(Ptg ptg, OperationEvaluationContext ec) {
        if (ptg instanceof NamePtg) {
            NamePtg namePtg = (NamePtg)ptg;
            EvaluationName nameRecord = this._workbook.getName(namePtg);
            return this.getEvalForNameRecord(nameRecord, ec);
        }
        if (ptg instanceof NameXPtg) {
            return this.processNameEval(ec.getNameXEval((NameXPtg)ptg), ec);
        }
        if (ptg instanceof NameXPxg) {
            return this.processNameEval(ec.getNameXEval((NameXPxg)ptg), ec);
        }
        if (ptg instanceof IntPtg) {
            return new NumberEval(((IntPtg)ptg).getValue());
        }
        if (ptg instanceof NumberPtg) {
            return new NumberEval(((NumberPtg)ptg).getValue());
        }
        if (ptg instanceof StringPtg) {
            return new StringEval(((StringPtg)ptg).getValue());
        }
        if (ptg instanceof BoolPtg) {
            return BoolEval.valueOf(((BoolPtg)ptg).getValue());
        }
        if (ptg instanceof ErrPtg) {
            return ErrorEval.valueOf(((ErrPtg)ptg).getErrorCode());
        }
        if (ptg instanceof MissingArgPtg) {
            return MissingArgEval.instance;
        }
        if (ptg instanceof AreaErrPtg || ptg instanceof RefErrorPtg || ptg instanceof DeletedArea3DPtg || ptg instanceof DeletedRef3DPtg) {
            return ErrorEval.REF_INVALID;
        }
        if (ptg instanceof Ref3DPtg) {
            return ec.getRef3DEval((Ref3DPtg)ptg);
        }
        if (ptg instanceof Ref3DPxg) {
            return ec.getRef3DEval((Ref3DPxg)ptg);
        }
        if (ptg instanceof Area3DPtg) {
            return ec.getArea3DEval((Area3DPtg)ptg);
        }
        if (ptg instanceof Area3DPxg) {
            return ec.getArea3DEval((Area3DPxg)ptg);
        }
        if (ptg instanceof RefPtg) {
            RefPtg rptg = (RefPtg)ptg;
            return ec.getRefEval(rptg.getRow(), rptg.getColumn());
        }
        if (ptg instanceof AreaPtg) {
            AreaPtg aptg = (AreaPtg)ptg;
            return ec.getAreaEval(aptg.getFirstRow(), aptg.getFirstColumn(), aptg.getLastRow(), aptg.getLastColumn());
        }
        if (ptg instanceof UnknownPtg) {
            throw new RuntimeException("UnknownPtg not allowed");
        }
        if (ptg instanceof ExpPtg) {
            throw new RuntimeException("ExpPtg currently not supported");
        }
        throw new RuntimeException("Unexpected ptg class (" + ptg.getClass().getName() + ")");
    }

    private ValueEval processNameEval(ValueEval eval, OperationEvaluationContext ec) {
        if (eval instanceof ExternalNameEval) {
            EvaluationName name = ((ExternalNameEval)eval).getName();
            return this.getEvalForNameRecord(name, ec);
        }
        return eval;
    }

    private ValueEval getEvalForNameRecord(EvaluationName nameRecord, OperationEvaluationContext ec) {
        if (nameRecord.isFunctionName()) {
            return new FunctionNameEval(nameRecord.getNameText());
        }
        if (nameRecord.hasFormula()) {
            return this.evaluateNameFormula(nameRecord.getNameDefinition(), ec);
        }
        throw new RuntimeException("Don't now how to evalate name '" + nameRecord.getNameText() + "'");
    }

    ValueEval evaluateNameFormula(Ptg[] ptgs, OperationEvaluationContext ec) {
        if (ptgs.length == 1) {
            return this.getEvalForPtg(ptgs[0], ec);
        }
        return this.evaluateFormula(ec, ptgs);
    }

    ValueEval evaluateReference(EvaluationSheet sheet, int sheetIndex, int rowIndex, int columnIndex, EvaluationTracker tracker) {
        EvaluationCell cell = sheet.getCell(rowIndex, columnIndex);
        return this.evaluateAny(cell, sheetIndex, rowIndex, columnIndex, tracker);
    }

    public FreeRefFunction findUserDefinedFunction(String functionName) {
        return this._udfFinder.findFunction(functionName);
    }

    public void setIgnoreMissingWorkbooks(boolean ignore) {
        this._ignoreMissingWorkbooks = ignore;
    }

    public static Collection<String> getSupportedFunctionNames() {
        TreeSet<String> lst = new TreeSet<String>();
        lst.addAll(FunctionEval.getSupportedFunctionNames());
        lst.addAll(AnalysisToolPak.getSupportedFunctionNames());
        return lst;
    }

    public static Collection<String> getNotSupportedFunctionNames() {
        TreeSet<String> lst = new TreeSet<String>();
        lst.addAll(FunctionEval.getNotSupportedFunctionNames());
        lst.addAll(AnalysisToolPak.getNotSupportedFunctionNames());
        return lst;
    }

    public static void registerFunction(String name, FreeRefFunction func) {
        AnalysisToolPak.registerFunction(name, func);
    }

    public static void registerFunction(String name, Function func) {
        FunctionEval.registerFunction(name, func);
    }

    public void setDebugEvaluationOutputForNextEval(boolean value) {
        this.dbgEvaluationOutputForNextEval = value;
    }
}

