/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.formula;

import com.fr.third.v2.org.apache.poi.ss.formula.SheetRangeEvaluator;
import com.fr.third.v2.org.apache.poi.ss.formula.SheetRefEvaluator;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.AreaEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.AreaEvalBase;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ValueEval;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.AreaI;
import com.fr.third.v2.org.apache.poi.ss.util.CellReference;

final class LazyAreaEval
extends AreaEvalBase {
    private final SheetRangeEvaluator _evaluator;

    LazyAreaEval(AreaI ptg, SheetRangeEvaluator evaluator) {
        super(ptg, evaluator);
        this._evaluator = evaluator;
    }

    public LazyAreaEval(int firstRowIndex, int firstColumnIndex, int lastRowIndex, int lastColumnIndex, SheetRangeEvaluator evaluator) {
        super(evaluator, firstRowIndex, firstColumnIndex, lastRowIndex, lastColumnIndex);
        this._evaluator = evaluator;
    }

    public ValueEval getRelativeValue(int relativeRowIndex, int relativeColumnIndex) {
        return this.getRelativeValue(this.getFirstSheetIndex(), relativeRowIndex, relativeColumnIndex);
    }

    public ValueEval getRelativeValue(int sheetIndex, int relativeRowIndex, int relativeColumnIndex) {
        int rowIx = relativeRowIndex + this.getFirstRow();
        int colIx = relativeColumnIndex + this.getFirstColumn();
        return this._evaluator.getEvalForCell(sheetIndex, rowIx, colIx);
    }

    public AreaEval offset(int relFirstRowIx, int relLastRowIx, int relFirstColIx, int relLastColIx) {
        AreaI.OffsetArea area = new AreaI.OffsetArea(this.getFirstRow(), this.getFirstColumn(), relFirstRowIx, relLastRowIx, relFirstColIx, relLastColIx);
        return new LazyAreaEval((AreaI)area, this._evaluator);
    }

    public LazyAreaEval getRow(int rowIndex) {
        if (rowIndex >= this.getHeight()) {
            throw new IllegalArgumentException("Invalid rowIndex " + rowIndex + ".  Allowable range is (0.." + this.getHeight() + ").");
        }
        int absRowIx = this.getFirstRow() + rowIndex;
        return new LazyAreaEval(absRowIx, this.getFirstColumn(), absRowIx, this.getLastColumn(), this._evaluator);
    }

    public LazyAreaEval getColumn(int columnIndex) {
        if (columnIndex >= this.getWidth()) {
            throw new IllegalArgumentException("Invalid columnIndex " + columnIndex + ".  Allowable range is (0.." + this.getWidth() + ").");
        }
        int absColIx = this.getFirstColumn() + columnIndex;
        return new LazyAreaEval(this.getFirstRow(), absColIx, this.getLastRow(), absColIx, this._evaluator);
    }

    public String toString() {
        CellReference crA = new CellReference(this.getFirstRow(), this.getFirstColumn());
        CellReference crB = new CellReference(this.getLastRow(), this.getLastColumn());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append(this._evaluator.getSheetNameRange());
        sb.append('!');
        sb.append(crA.formatAsString());
        sb.append(':');
        sb.append(crB.formatAsString());
        sb.append("]");
        return sb.toString();
    }

    public boolean isSubTotal(int rowIndex, int columnIndex) {
        SheetRefEvaluator _sre = this._evaluator.getSheetEvaluator(this._evaluator.getFirstSheetIndex());
        return _sre.isSubTotal(this.getFirstRow() + rowIndex, this.getFirstColumn() + columnIndex);
    }
}

