/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.sl.draw;

import com.fr.third.v2.org.apache.poi.sl.draw.ImageRenderer;
import com.fr.third.v2.org.apache.poi.util.POILogFactory;
import com.fr.third.v2.org.apache.poi.util.POILogger;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class BitmapImageRenderer
implements ImageRenderer {
    private static final POILogger LOG = POILogFactory.getLogger(ImageRenderer.class);
    protected BufferedImage img;

    public void loadImage(InputStream data, String contentType) throws IOException {
        this.img = BitmapImageRenderer.convertBufferedImage(ImageIO.read(data), contentType);
    }

    public void loadImage(byte[] data, String contentType) throws IOException {
        this.img = BitmapImageRenderer.convertBufferedImage(ImageIO.read(new ByteArrayInputStream(data)), contentType);
    }

    private static BufferedImage convertBufferedImage(BufferedImage img, String contentType) {
        if (img == null) {
            LOG.log(5, new Object[]{"Content-type: " + contentType + " is not support. Image ignored."});
            return null;
        }
        BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        Graphics g = bi.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public Dimension getDimension() {
        return this.img == null ? new Dimension(0, 0) : new Dimension(this.img.getWidth(), this.img.getHeight());
    }

    public void setAlpha(double alpha) {
        if (this.img == null) {
            return;
        }
        Dimension dim = this.getDimension();
        BufferedImage newImg = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), 2);
        Graphics2D g = newImg.createGraphics();
        RescaleOp op = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, (float)alpha}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        g.drawImage(this.img, op, 0, 0);
        g.dispose();
        this.img = newImg;
    }

    public boolean drawImage(Graphics2D graphics, Rectangle2D anchor) {
        return this.drawImage(graphics, anchor, null);
    }

    public boolean drawImage(Graphics2D graphics, Rectangle2D anchor, Insets clip) {
        if (this.img == null) {
            return false;
        }
        boolean isClipped = true;
        if (clip == null) {
            isClipped = false;
            clip = new Insets(0, 0, 0, 0);
        }
        int iw = this.img.getWidth();
        int ih = this.img.getHeight();
        double cw = (double)(100000 - clip.left - clip.right) / 100000.0;
        double ch = (double)(100000 - clip.top - clip.bottom) / 100000.0;
        double sx = anchor.getWidth() / ((double)iw * cw);
        double sy = anchor.getHeight() / ((double)ih * ch);
        double tx = anchor.getX() - (double)iw * sx * (double)clip.left / 100000.0;
        double ty = anchor.getY() - (double)ih * sy * (double)clip.top / 100000.0;
        AffineTransform at = new AffineTransform(sx, 0.0, 0.0, sy, tx, ty);
        Shape clipOld = graphics.getClip();
        if (isClipped) {
            graphics.clip(anchor.getBounds2D());
        }
        graphics.drawRenderedImage(this.img, at);
        graphics.setClip(clipOld);
        return true;
    }
}

