/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.openxml4j.opc.internal;

import com.fr.third.v2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import com.fr.third.v2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.OPCPackage;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackagePart;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackagePartName;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.internal.ContentType;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.internal.MemoryPackagePartOutputStream;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.internal.marshallers.ZipPartMarshaller;
import com.fr.third.v2.org.apache.poi.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class MemoryPackagePart
extends PackagePart {
    protected byte[] data;

    public MemoryPackagePart(OPCPackage pack, PackagePartName partName, String contentType) throws InvalidFormatException {
        super(pack, partName, contentType);
    }

    public MemoryPackagePart(OPCPackage pack, PackagePartName partName, String contentType, boolean loadRelationships) throws InvalidFormatException {
        super(pack, partName, new ContentType(contentType), loadRelationships);
    }

    protected InputStream getInputStreamImpl() {
        if (this.data == null) {
            this.data = new byte[0];
        }
        return new ByteArrayInputStream(this.data);
    }

    protected OutputStream getOutputStreamImpl() {
        return new MemoryPackagePartOutputStream(this);
    }

    public long getSize() {
        return this.data == null ? 0L : (long)this.data.length;
    }

    public void clear() {
        this.data = null;
    }

    public boolean save(OutputStream os) throws OpenXML4JException {
        return new ZipPartMarshaller().marshall(this, os);
    }

    public boolean load(InputStream ios) throws InvalidFormatException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy(ios, baos);
        }
        catch (IOException e) {
            throw new InvalidFormatException(e.getMessage());
        }
        this.data = baos.toByteArray();
        return true;
    }

    public void close() {
    }

    public void flush() {
    }
}

