/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.hssf.record.crypto;

import com.fr.third.v2.org.apache.poi.EncryptedDocumentException;
import com.fr.third.v2.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import com.fr.third.v2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import com.fr.third.v2.org.apache.poi.poifs.crypt.CryptoFunctions;
import com.fr.third.v2.org.apache.poi.poifs.crypt.HashAlgorithm;
import com.fr.third.v2.org.apache.poi.util.HexDump;
import com.fr.third.v2.org.apache.poi.util.LittleEndian;
import com.fr.third.v2.org.apache.poi.util.POILogFactory;
import com.fr.third.v2.org.apache.poi.util.POILogger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class Biff8RC4Key
extends Biff8EncryptionKey {
    public static final int KEY_DIGEST_LENGTH = 5;
    private static final int PASSWORD_HASH_NUMBER_OF_BYTES_USED = 5;
    private static POILogger log = POILogFactory.getLogger(Biff8RC4Key.class);

    Biff8RC4Key(byte[] keyDigest) {
        if (keyDigest.length != 5) {
            throw new IllegalArgumentException("Expected 5 byte key digest, but got " + HexDump.toHex(keyDigest));
        }
        CipherAlgorithm ca = CipherAlgorithm.rc4;
        this._secretKey = new SecretKeySpec(keyDigest, ca.jceId);
    }

    public static Biff8RC4Key create(String password, byte[] salt) {
        return new Biff8RC4Key(Biff8RC4Key.createKeyDigest(password, salt));
    }

    public boolean validate(byte[] verifier, byte[] verifierHash) {
        Biff8RC4Key.check16Bytes(verifier, "verifier");
        Biff8RC4Key.check16Bytes(verifierHash, "verifierHash");
        Cipher rc4 = this.getCipher();
        this.initCipherForBlock(rc4, 0);
        byte[] verifierPrime = (byte[])verifier.clone();
        byte[] verifierHashPrime = (byte[])verifierHash.clone();
        try {
            rc4.update(verifierPrime, 0, verifierPrime.length, verifierPrime);
            rc4.update(verifierHashPrime, 0, verifierHashPrime.length, verifierHashPrime);
        }
        catch (ShortBufferException e) {
            throw new EncryptedDocumentException("buffer too short", e);
        }
        MessageDigest md5 = CryptoFunctions.getMessageDigest(HashAlgorithm.md5);
        md5.update(verifierPrime);
        byte[] finalVerifierResult = md5.digest();
        if (log.check(1)) {
            byte[] verifierHashThatWouldWork = Biff8RC4Key.xor(verifierHash, Biff8RC4Key.xor(verifierHashPrime, finalVerifierResult));
            log.log(1, "valid verifierHash value", HexDump.toHex(verifierHashThatWouldWork));
        }
        return Arrays.equals(verifierHashPrime, finalVerifierResult);
    }

    Cipher getCipher() {
        CipherAlgorithm ca = CipherAlgorithm.rc4;
        Cipher rc4 = CryptoFunctions.getCipher(this._secretKey, ca, null, null, 1);
        return rc4;
    }

    static byte[] createKeyDigest(String password, byte[] docIdData) {
        Biff8RC4Key.check16Bytes(docIdData, "docId");
        int nChars = Math.min(password.length(), 16);
        byte[] passwordData = new byte[nChars * 2];
        for (int i = 0; i < nChars; ++i) {
            char ch = password.charAt(i);
            passwordData[i * 2 + 0] = (byte)(ch << 0 & 0xFF);
            passwordData[i * 2 + 1] = (byte)(ch << 8 & 0xFF);
        }
        MessageDigest md5 = CryptoFunctions.getMessageDigest(HashAlgorithm.md5);
        md5.update(passwordData);
        byte[] passwordHash = md5.digest();
        md5.reset();
        for (int i = 0; i < 16; ++i) {
            md5.update(passwordHash, 0, 5);
            md5.update(docIdData, 0, docIdData.length);
        }
        byte[] result = CryptoFunctions.getBlock0(md5.digest(), 5);
        return result;
    }

    void initCipherForBlock(Cipher rc4, int keyBlockNo) {
        byte[] buf = new byte[4];
        LittleEndian.putInt(buf, 0, keyBlockNo);
        MessageDigest md5 = CryptoFunctions.getMessageDigest(HashAlgorithm.md5);
        md5.update(this._secretKey.getEncoded());
        md5.update(buf);
        SecretKeySpec skeySpec = new SecretKeySpec(md5.digest(), this._secretKey.getAlgorithm());
        try {
            rc4.init(1, skeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new EncryptedDocumentException("Can't rekey for next block", e);
        }
    }

    private static byte[] xor(byte[] a, byte[] b) {
        byte[] c = new byte[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (byte)(a[i] ^ b[i]);
        }
        return c;
    }

    private static void check16Bytes(byte[] data, String argName) {
        if (data.length != 16) {
            throw new IllegalArgumentException("Expected 16 byte " + argName + ", but got " + HexDump.toHex(data));
        }
    }
}

