/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.persist;

import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.NumberSequence;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.lib.FileAccess;
import com.fr.third.org.hsqldb.lib.HashMap;
import com.fr.third.org.hsqldb.lib.Iterator;
import com.fr.third.org.hsqldb.lib.ZipUnzipFile;
import com.fr.third.org.hsqldb.persist.DataFileCache;
import com.fr.third.org.hsqldb.persist.HsqlDatabaseProperties;
import com.fr.third.org.hsqldb.persist.RAShadowFile;
import com.fr.third.org.hsqldb.persist.ScriptRunner;
import com.fr.third.org.hsqldb.persist.TextCache;
import com.fr.third.org.hsqldb.scriptio.ScriptReaderBase;
import com.fr.third.org.hsqldb.scriptio.ScriptWriterBase;
import java.io.File;
import java.io.IOException;

public class Log {
    private HsqlDatabaseProperties properties;
    private String fileName;
    private Database database;
    private FileAccess fa;
    private ScriptWriterBase dbLogWriter;
    private String scriptFileName;
    private String logFileName;
    private boolean filesReadOnly;
    private long maxLogSize;
    private int writeDelay;
    private int scriptFormat;
    private DataFileCache cache;
    private boolean incBackup;
    private HashMap textCacheList = new HashMap();

    Log(Database db) throws HsqlException {
        this.database = db;
        this.fa = db.getFileAccess();
        this.fileName = db.getPath();
        this.properties = db.getProperties();
    }

    void initParams() {
        int logMegas = this.properties.getIntegerProperty("hsqldb.log_size", 0);
        this.maxLogSize = (long)logMegas * 1024L * 1024L;
        this.scriptFormat = this.properties.getIntegerProperty("hsqldb.script_format", 0);
        this.incBackup = this.properties.isPropertyTrue("hsqldb.incremental_backup");
        this.writeDelay = this.properties.getDefaultWriteDelay();
        this.filesReadOnly = this.database.isFilesReadOnly();
        this.scriptFileName = this.fileName + ".script";
        this.logFileName = this.fileName + ".log";
    }

    void open() throws HsqlException {
        this.initParams();
        int state = this.properties.getDBModified();
        switch (state) {
            case 1: {
                this.deleteNewAndOldFiles();
                this.restoreBackup();
                this.processScript();
                this.processDataFile();
                this.processLog();
                this.close(false);
                if (this.cache != null) {
                    this.cache.open(this.filesReadOnly);
                }
                this.reopenAllTextCaches();
                break;
            }
            case 2: {
                try {
                    this.deleteBackup();
                    this.backupData();
                    this.renameNewBackup();
                    this.renameNewScript();
                    this.deleteLog();
                    this.properties.setDBModified(0);
                }
                catch (IOException e) {
                    this.database.logger.appLog.logContext(e, null);
                }
            }
            case 0: {
                this.processScript();
                if (!this.isAnyCacheModified()) break;
                this.properties.setDBModified(1);
                this.close(false);
                if (this.cache != null) {
                    this.cache.open(this.filesReadOnly);
                }
                this.reopenAllTextCaches();
            }
        }
        this.openLog();
        if (!this.filesReadOnly) {
            this.properties.setDBModified(1);
        }
    }

    void close(boolean script) throws HsqlException {
        this.closeLog();
        this.deleteNewAndOldFiles();
        this.writeScript(script);
        this.closeAllTextCaches(script);
        if (this.cache != null) {
            this.cache.close(true);
        }
        this.properties.setProperty("version", "1.8.1");
        this.properties.setProperty("hsqldb.compatible_version", "1.8.0");
        this.properties.setDBModified(2);
        this.deleteLog();
        if (script) {
            this.deleteBackup();
            this.deleteData();
        } else {
            try {
                this.backupData();
                this.renameNewBackup();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.renameNewScript();
        this.properties.setProperty("hsqldb.cache_version", "1.7.0");
        this.properties.setDBModified(0);
    }

    void shutdown() throws HsqlException {
        this.synchLog();
        if (this.cache != null) {
            this.cache.close(false);
        }
        this.closeAllTextCaches(false);
        this.closeLog();
    }

    void deleteNewAndOldFiles() {
        this.fa.removeElement(this.fileName + ".data" + ".old");
        this.fa.removeElement(this.fileName + ".data" + ".new");
        this.fa.removeElement(this.fileName + ".backup" + ".new");
        this.fa.removeElement(this.scriptFileName + ".new");
    }

    void deleteBackup() {
        this.fa.removeElement(this.fileName + ".backup");
    }

    void deleteData() {
        this.fa.removeElement(this.fileName + ".data");
    }

    void backupData() throws IOException {
        if (this.incBackup) {
            this.fa.removeElement(this.fileName + ".backup");
            return;
        }
        if (this.fa.isStreamElement(this.fileName + ".data")) {
            ZipUnzipFile.compressFile(this.fileName + ".data", this.fileName + ".backup.new", this.database.getFileAccess());
        }
    }

    void renameNewBackup() {
        if (this.fa.isStreamElement(this.fileName + ".backup.new")) {
            this.fa.renameElement(this.fileName + ".backup.new", this.fileName + ".backup");
        }
    }

    void renameNewScript() {
        if (this.fa.isStreamElement(this.scriptFileName + ".new")) {
            this.fa.renameElement(this.scriptFileName + ".new", this.scriptFileName);
        }
    }

    void deleteNewScript() {
        this.fa.removeElement(this.scriptFileName + ".new");
    }

    void deleteNewBackup() {
        this.fa.removeElement(this.scriptFileName + ".backup.new");
    }

    void deleteLog() {
        this.fa.removeElement(this.logFileName);
    }

    boolean isAnyCacheModified() {
        if (this.cache != null && this.cache.isFileModified()) {
            return true;
        }
        return this.isAnyTextCacheModified();
    }

    void checkpoint(boolean defrag) throws HsqlException {
        if (this.filesReadOnly) {
            return;
        }
        this.database.logger.appLog.logContext(2, "start");
        this.deleteNewAndOldFiles();
        if (this.cache != null) {
            if (this.forceDefrag()) {
                defrag = true;
            }
            if (defrag) {
                try {
                    this.cache.defrag();
                }
                catch (Exception e) {}
            } else {
                this.cache.close(true);
                try {
                    this.cache.backupFile();
                }
                catch (IOException e1) {
                    this.deleteNewBackup();
                    this.cache.open(false);
                    return;
                }
                this.cache.open(false);
            }
        }
        this.writeScript(false);
        this.properties.setDBModified(2);
        this.closeLog();
        this.deleteLog();
        this.renameNewScript();
        this.renameNewBackup();
        this.properties.setDBModified(1);
        if (this.dbLogWriter == null) {
            return;
        }
        this.openLog();
        Session[] sessions = this.database.sessionManager.getAllSessions();
        try {
            for (int i = 0; i < sessions.length; ++i) {
                Session session = sessions[i];
                if (session.isAutoCommit()) continue;
                this.dbLogWriter.writeLogStatement(session, session.getAutoCommitStatement());
            }
        }
        catch (IOException e) {
            throw Trace.error(29, this.logFileName);
        }
        this.database.logger.appLog.logContext(2, "end");
    }

    boolean forceDefrag() {
        long megas = this.properties.getIntegerProperty("hsqldb.defrag_limit", 200);
        long defraglimit = megas * 1024L * 1024L;
        long lostSize = this.cache.freeBlocks.getLostBlocksSize();
        return lostSize > defraglimit;
    }

    boolean hasCache() {
        return this.cache != null;
    }

    DataFileCache getCache() throws HsqlException {
        if (this.cache == null) {
            this.cache = new DataFileCache(this.database, this.fileName);
            this.cache.open(this.filesReadOnly);
        }
        return this.cache;
    }

    int getLogSize() {
        return (int)(this.maxLogSize / 0x100000L);
    }

    void setLogSize(int megas) {
        this.properties.setProperty("hsqldb.log_size", String.valueOf(megas));
        this.maxLogSize = (long)megas * 1024L * 1024L;
    }

    int getScriptType() {
        return this.scriptFormat;
    }

    void setScriptType(int type) throws HsqlException {
        if (this.database.isStoredFileAccess()) {
            return;
        }
        boolean needsCheckpoint = this.scriptFormat != type;
        this.scriptFormat = type;
        this.properties.setProperty("hsqldb.script_format", String.valueOf(this.scriptFormat));
        if (needsCheckpoint) {
            this.database.logger.needsCheckpoint = true;
        }
    }

    int getWriteDelay() {
        return this.writeDelay;
    }

    void setWriteDelay(int delay) {
        if (delay > 0 && delay < 10) {
            delay = 10;
        }
        this.writeDelay = delay;
        if (this.dbLogWriter != null) {
            this.dbLogWriter.forceSync();
            this.dbLogWriter.stop();
            this.dbLogWriter.setWriteDelay(delay);
            this.dbLogWriter.start();
        }
    }

    public void setIncrementalBackup(boolean val) throws HsqlException {
        if (this.incBackup == val) {
            return;
        }
        this.incBackup = val;
        this.database.getProperties().setProperty("hsqldb.incremental_backup", String.valueOf(val));
        this.database.getProperties().save();
        if (this.cache != null) {
            this.cache.incBackup = true;
            this.cache.fileModified = true;
        }
        this.database.logger.needsCheckpoint = true;
    }

    void writeStatement(Session session, String s) throws HsqlException {
        if (s == null || s.length() == 0) {
            return;
        }
        try {
            this.dbLogWriter.writeLogStatement(session, s);
        }
        catch (IOException e) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.needsCheckpoint = true;
        }
    }

    void writeInsertStatement(Session session, Table t, Object[] row) throws HsqlException {
        try {
            this.dbLogWriter.writeInsertStatement(session, t, row);
        }
        catch (IOException e) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.needsCheckpoint = true;
        }
    }

    void writeDeleteStatement(Session session, Table t, Object[] row) throws HsqlException {
        try {
            this.dbLogWriter.writeDeleteStatement(session, t, row);
        }
        catch (IOException e) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.needsCheckpoint = true;
        }
    }

    void writeSequenceStatement(Session session, NumberSequence s) throws HsqlException {
        try {
            this.dbLogWriter.writeSequenceStatement(session, s);
        }
        catch (IOException e) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.needsCheckpoint = true;
        }
    }

    void writeCommitStatement(Session session) throws HsqlException {
        try {
            this.dbLogWriter.writeCommitStatement(session);
        }
        catch (IOException e) {
            throw Trace.error(29, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.needsCheckpoint = true;
        }
    }

    void synchLog() {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.sync();
        }
    }

    private void openLog() throws HsqlException {
        if (this.filesReadOnly) {
            return;
        }
        try {
            this.dbLogWriter = ScriptWriterBase.newScriptWriter(this.database, this.logFileName, false, false, 0);
            this.dbLogWriter.setWriteDelay(this.writeDelay);
            this.dbLogWriter.start();
        }
        catch (Exception e) {
            throw Trace.error(29, this.logFileName);
        }
    }

    private synchronized void closeLog() throws HsqlException {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.close();
        }
    }

    private void writeScript(boolean full) throws HsqlException {
        this.deleteNewScript();
        ScriptWriterBase scw = ScriptWriterBase.newScriptWriter(this.database, this.scriptFileName + ".new", full, true, this.scriptFormat);
        scw.writeAll();
        scw.close();
    }

    private void processScript() throws HsqlException {
        ScriptReaderBase scr = null;
        try {
            if (this.database.isFilesInJar() || this.fa.isStreamElement(this.scriptFileName)) {
                scr = ScriptReaderBase.newScriptReader(this.database, this.scriptFileName, this.scriptFormat);
                scr.readAll(this.database.sessionManager.getSysSession(null, true));
                scr.close();
            }
        }
        catch (Throwable e) {
            if (scr != null) {
                scr.close();
                if (this.cache != null) {
                    this.cache.close(false);
                }
                this.closeAllTextCaches(false);
            }
            this.database.logger.appLog.logContext(e, null);
            if (e instanceof HsqlException) {
                throw (HsqlException)e;
            }
            if (e instanceof IOException) {
                throw Trace.error(29, e.toString());
            }
            if (e instanceof OutOfMemoryError) {
                throw Trace.error(72);
            }
            e.printStackTrace();
            throw Trace.error(40, e.toString());
        }
    }

    private void processDataFile() throws HsqlException {
        long dataLength;
        if (this.database.isStoredFileAccess()) {
            return;
        }
        if (this.cache == null || this.filesReadOnly || !this.fa.isStreamElement(this.logFileName)) {
            return;
        }
        File file = new File(this.logFileName);
        long logLength = file.length();
        if (logLength + (dataLength = this.cache.getFileFreePos()) > this.cache.maxDataFileSize) {
            this.database.logger.needsCheckpoint = true;
        }
    }

    private void processLog() throws HsqlException {
        if (!this.database.isFilesInJar() && this.fa.isStreamElement(this.logFileName)) {
            ScriptRunner.runScript(this.database, this.logFileName, 0);
        }
    }

    private void restoreBackup() throws HsqlException {
        if (this.incBackup) {
            this.restoreBackupIncremental();
            return;
        }
        DataFileCache.deleteOrResetFreePos(this.database, this.fileName + ".data");
        try {
            ZipUnzipFile.decompressFile(this.fileName + ".backup", this.fileName + ".data", this.database.getFileAccess());
        }
        catch (Exception e) {
            throw Trace.error(29, 115, new Object[]{this.fileName + ".backup", e.toString()});
        }
    }

    private void restoreBackupIncremental() throws HsqlException {
        try {
            if (this.fa.isStreamElement(this.fileName + ".backup")) {
                RAShadowFile.restoreFile(this.fileName + ".backup", this.fileName + ".data");
            }
            this.deleteBackup();
        }
        catch (IOException e) {
            throw Trace.error(29, this.fileName + ".backup");
        }
    }

    DataFileCache openTextCache(Table table, String source, boolean readOnlyData, boolean reversed) throws HsqlException {
        this.closeTextCache(table);
        if (this.database.getType() != "res:" && !this.properties.isPropertyTrue("textdb.allow_full_path")) {
            if (source.indexOf("..") != -1) {
                throw Trace.error(33, source);
            }
            String path = new File(new File(this.database.getPath() + ".properties").getAbsolutePath()).getParent();
            if (path != null) {
                source = path + File.separator + source;
            }
        }
        TextCache c = reversed ? new TextCache(table, source) : new TextCache(table, source);
        c.open(readOnlyData || this.filesReadOnly);
        this.textCacheList.put(table.getName(), c);
        return c;
    }

    void closeTextCache(Table table) throws HsqlException {
        TextCache c = (TextCache)this.textCacheList.remove(table.getName());
        if (c != null) {
            c.close(true);
        }
    }

    private void closeAllTextCaches(boolean compact) throws HsqlException {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            if (compact) {
                ((TextCache)it.next()).purge();
                continue;
            }
            ((TextCache)it.next()).close(true);
        }
    }

    private void reopenAllTextCaches() throws HsqlException {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            ((TextCache)it.next()).reopen();
        }
    }

    private boolean isAnyTextCacheModified() {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            if (!((TextCache)it.next()).isFileModified()) continue;
            return true;
        }
        return false;
    }
}

