/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.lib;

import com.fr.third.org.hsqldb.lib.HashMap;

public class HashMappedList
extends HashMap {
    public HashMappedList() {
        this(16, 0.75f);
    }

    public HashMappedList(int initialCapacity) throws IllegalArgumentException {
        this(initialCapacity, 0.75f);
    }

    public HashMappedList(int initialCapacity, float loadFactor) throws IllegalArgumentException {
        super(initialCapacity, loadFactor);
    }

    public Object get(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.objectValueTable[index];
    }

    public Object remove(Object key) {
        int lookup = this.getLookup(key, key.hashCode());
        if (lookup < 0) {
            return null;
        }
        Object returnValue = super.remove(key);
        this.removeRow(lookup);
        return returnValue;
    }

    public Object remove(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.remove(this.objectKeyTable[index]);
    }

    public boolean add(Object key, Object value) {
        if (this.keySet().contains(key)) {
            return false;
        }
        super.put(key, value);
        return true;
    }

    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    public Object set(int index, Object value) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object returnValue = this.objectKeyTable[index];
        this.objectKeyTable[index] = value;
        return returnValue;
    }

    public boolean insert(int index, Object key, Object value) throws IndexOutOfBoundsException {
        int i;
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.keySet().contains(key)) {
            return false;
        }
        if (index == this.size()) {
            return this.add(key, value);
        }
        HashMappedList hm = new HashMappedList(this.size());
        for (i = index; i < this.size(); ++i) {
            hm.add(this.getKey(i), this.get(i));
        }
        for (i = this.size() - 1; i >= index; --i) {
            this.remove(i);
        }
        for (i = 0; i < hm.size(); ++i) {
            this.add(hm.getKey(i), hm.get(i));
        }
        return true;
    }

    public boolean set(int index, Object key, Object value) throws IndexOutOfBoundsException {
        this.checkRange(index);
        if (this.keySet().contains(key) && this.getIndex(key) != index) {
            return false;
        }
        super.remove(this.objectKeyTable[index]);
        super.put(key, value);
        return true;
    }

    public boolean setKey(int index, Object key) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object value = this.objectValueTable[index];
        return this.set(index, key, value);
    }

    public Object getKey(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.objectKeyTable[index];
    }

    public int getIndex(Object key) {
        return this.getLookup(key, key.hashCode());
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

