/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.renderer;

import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.layout.element.Paragraph;
import com.fr.third.fr.pdf.layout.layout.LayoutArea;
import com.fr.third.fr.pdf.layout.layout.LayoutContext;
import com.fr.third.fr.pdf.layout.layout.LayoutResult;
import com.fr.third.fr.pdf.layout.layout.LineLayoutResult;
import com.fr.third.fr.pdf.layout.property.Leading;
import com.fr.third.fr.pdf.layout.property.TextAlignment;
import com.fr.third.fr.pdf.layout.property.VerticalAlignment;
import com.fr.third.fr.pdf.layout.renderer.BlockRenderer;
import com.fr.third.fr.pdf.layout.renderer.CellRenderer;
import com.fr.third.fr.pdf.layout.renderer.DrawContext;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.LineRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParagraphRenderer
extends BlockRenderer {
    protected float previousDescent = 0.0f;
    protected List<LineRenderer> lines = null;
    private static Float DefaultLayoutPosition = Float.valueOf(0.0f);

    public ParagraphRenderer(Paragraph modelElement) {
        super(modelElement);
    }

    @Override
    public void drawBackground(DrawContext drawContext) {
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        int pageNumber = layoutContext.getArea().getPageNumber();
        Rectangle parentBBox = layoutContext.getArea().getBBox().clone();
        this.applyMargins(parentBBox, false);
        float blockWidth = this.retrieveWidth(parentBBox.getWidth());
        if (blockWidth != 0.0f && (blockWidth < parentBBox.getWidth() || this.isPositioned())) {
            parentBBox.setWidth(blockWidth);
        }
        List<Rectangle> areas = this.isPositioned() ? Collections.singletonList(parentBBox) : this.initElementAreas(new LayoutArea(pageNumber, parentBBox));
        this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), 0.0f));
        int currentAreaPos = 0;
        Rectangle layoutBox = areas.get(0).clone();
        boolean anythingPlaced = false;
        boolean firstLineInBox = true;
        this.lines = new ArrayList<LineRenderer>();
        LineRenderer currentRenderer = (LineRenderer)new LineRenderer().setParent(this);
        for (IRenderer child : this.childRenderers) {
            currentRenderer.addChild(child);
        }
        float lastYLine = layoutBox.getY() + layoutBox.getHeight();
        Leading leading = (Leading)this.getProperty(33);
        float leadingValue = 0.0f;
        float lastLineHeight = 0.0f;
        while (currentRenderer != null) {
            float lineIndent = 0.0f;
            float availableWidth = layoutBox.getWidth() - lineIndent;
            Rectangle childLayoutBox = new Rectangle(layoutBox.getX() + lineIndent, layoutBox.getY(), availableWidth, layoutBox.getHeight());
            LineLayoutResult result = currentRenderer.layout(new LayoutContext(new LayoutArea(pageNumber, childLayoutBox)));
            LineRenderer processedRenderer = null;
            if (result.getStatus() == 1) {
                processedRenderer = currentRenderer;
            } else if (result.getStatus() == 2) {
                processedRenderer = (LineRenderer)result.getSplitRenderer();
            }
            TextAlignment textAlignment = this.getTextAlignment();
            if (result.getStatus() == 2 && textAlignment == TextAlignment.JUSTIFIED && !result.isSplitForcedByNewline() || textAlignment == TextAlignment.JUSTIFIED_ALL) {
                if (processedRenderer != null) {
                    processedRenderer.justify(layoutBox.getWidth() - lineIndent);
                }
            } else if (textAlignment != null && textAlignment != TextAlignment.LEFT && processedRenderer != null) {
                float deltaX = availableWidth - processedRenderer.getOccupiedArea().getBBox().getWidth();
                switch (textAlignment) {
                    case RIGHT: {
                        processedRenderer.move(deltaX, 0.0f);
                        break;
                    }
                    case CENTER: {
                        processedRenderer.move(deltaX / 2.0f, 0.0f);
                    }
                }
            }
            float f = leadingValue = processedRenderer != null && leading != null ? processedRenderer.getLeadingValue(leading) : 0.0f;
            if (processedRenderer != null && processedRenderer.containsImage()) {
                leadingValue -= this.previousDescent;
            }
            boolean doesNotFit = result.getStatus() == 3;
            float deltaY = 0.0f;
            if (!doesNotFit) {
                lastLineHeight = processedRenderer.getOccupiedArea().getBBox().getHeight();
                deltaY = lastYLine - leadingValue - processedRenderer.getYLine();
                if (firstLineInBox) {
                    deltaY = -(leadingValue - lastLineHeight) / 2.0f;
                }
                doesNotFit = false;
            }
            if (doesNotFit) {
                if (currentAreaPos + 1 < areas.size()) {
                    layoutBox = areas.get(++currentAreaPos).clone();
                    lastYLine = layoutBox.getY() + layoutBox.getHeight();
                    firstLineInBox = true;
                    continue;
                }
                Boolean keepTogether = (Boolean)this.getProperty(32);
                if (keepTogether != null && keepTogether.booleanValue()) {
                    return new LayoutResult(3, this.occupiedArea, null, this);
                }
                this.applyMargins(this.occupiedArea.getBBox(), true);
                ParagraphRenderer[] split = this.split();
                split[0].lines = this.lines;
                for (LineRenderer line : this.lines) {
                    split[0].childRenderers.addAll(line.getChildRenderers());
                }
                if (processedRenderer != null) {
                    split[1].childRenderers.addAll(processedRenderer.getChildRenderers());
                }
                if (result.getOverflowRenderer() != null) {
                    split[1].childRenderers.addAll(result.getOverflowRenderer().getChildRenderers());
                }
                if (anythingPlaced) {
                    return new LayoutResult(2, this.occupiedArea, split[0], split[1]);
                }
                if (this.getPropertyAsBoolean(26).booleanValue()) {
                    this.parent.setProperty(25, true);
                    this.lines.add(currentRenderer);
                    return new LayoutResult(1, this.occupiedArea, null, this);
                }
                return new LayoutResult(3, this.occupiedArea, null, this);
            }
            if (leading != null) {
                processedRenderer.move(0.0f, deltaY);
                lastYLine = processedRenderer.getYLine();
            }
            this.occupiedArea.setBBox(Rectangle.getCommonRectangle(this.occupiedArea.getBBox(), processedRenderer.getOccupiedArea().getBBox()));
            layoutBox.setHeight(processedRenderer.getOccupiedArea().getBBox().getY() - layoutBox.getY());
            this.lines.add(processedRenderer);
            anythingPlaced = true;
            firstLineInBox = false;
            currentRenderer = (LineRenderer)result.getOverflowRenderer();
            this.previousDescent = processedRenderer.getMaxDescent();
        }
        if (!this.isPositioned()) {
            float moveDown = Math.min((leadingValue - lastLineHeight) / 2.0f, this.occupiedArea.getBBox().getY() - layoutBox.getY());
            this.occupiedArea.getBBox().moveDown(moveDown);
            this.occupiedArea.getBBox().setHeight(this.occupiedArea.getBBox().getHeight() + moveDown);
        }
        float blockHeight = this.getPropertyAsFloat(27);
        this.applyPaddings(this.occupiedArea.getBBox(), true);
        if (blockHeight != 0.0f && blockHeight > this.occupiedArea.getBBox().getHeight()) {
            this.occupiedArea.getBBox().moveDown(blockHeight - this.occupiedArea.getBBox().getHeight()).setHeight(blockHeight);
            this.applyVerticalAlignment();
        }
        this.applyMargins(this.occupiedArea.getBBox(), true);
        return new LayoutResult(1, this.occupiedArea, null, null);
    }

    private float getInnerHeight() {
        float height = 0.0f;
        for (int i = 0; i < this.lines.size(); ++i) {
            IRenderer child = this.lines.get(i);
            height += child.getOccupiedArea().getBBox().getHeight();
        }
        return height;
    }

    @Override
    public Rectangle getInnerAreaBBox() {
        return this.getOccupiedAreaBBox();
    }

    @Override
    protected Rectangle applyPaddings(Rectangle rect, boolean reverse) {
        return rect;
    }

    @Override
    protected void applyVerticalAlignment() {
        LayoutArea la;
        VerticalAlignment verticalAlignment = this.getVerticalAlignment();
        if (verticalAlignment != null && verticalAlignment != VerticalAlignment.TOP && this.childRenderers.size() > 0 && (la = ((IRenderer)this.childRenderers.get(this.childRenderers.size() - 1)).getOccupiedArea()) != null) {
            switch (verticalAlignment) {
                case BOTTOM: {
                    float blockHeight;
                    float deltaY = blockHeight = this.getFloatProperty(27);
                    deltaY -= this.getInnerHeight();
                    for (IRenderer iRenderer : this.lines) {
                        iRenderer.move(0.0f, -deltaY);
                    }
                    break;
                }
                case MIDDLE: {
                    float blockHeight;
                    float deltaY = blockHeight = this.getFloatProperty(27);
                    deltaY -= this.getInnerHeight();
                    for (IRenderer iRenderer : this.lines) {
                        iRenderer.move(0.0f, -deltaY / 2.0f);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ParagraphRenderer((Paragraph)this.modelElement);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        if ((property == 46 || property == 43) && this.parent instanceof CellRenderer) {
            return (T1)DefaultLayoutPosition;
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public float getDefaultFloatProperty(int property) {
        if ((property == 46 || property == 43) && this.parent instanceof CellRenderer) {
            return 0.0f;
        }
        return super.getDefaultFloatProperty(property);
    }

    protected ParagraphRenderer createOverflowRenderer() {
        ParagraphRenderer overflowRenderer = (ParagraphRenderer)this.getNextRenderer();
        float firstLineIndent = this.getPropertyAsFloat(18);
        if (firstLineIndent != 0.0f) {
            overflowRenderer.setProperty(18, 0);
        }
        return overflowRenderer;
    }

    protected ParagraphRenderer createSplitRenderer() {
        return (ParagraphRenderer)this.getNextRenderer();
    }

    protected ParagraphRenderer[] split() {
        ParagraphRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.parent = this.parent;
        splitRenderer.isLastRendererForModelElement = false;
        ParagraphRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.parent = this.parent;
        return new ParagraphRenderer[]{splitRenderer, overflowRenderer};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.lines != null && this.lines.size() > 0) {
            for (LineRenderer lineRenderer : this.lines) {
                sb.append(lineRenderer.toString()).append("\n");
            }
        } else {
            for (IRenderer renderer : this.childRenderers) {
                sb.append(renderer.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        if (this.lines != null) {
            for (LineRenderer line : this.lines) {
                line.draw(drawContext);
            }
        }
    }

    @Override
    public void drawBorder(DrawContext drawContext) {
    }

    @Override
    public void move(float dxRight, float dyUp) {
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        for (LineRenderer line : this.lines) {
            line.move(dxRight, dyUp);
        }
    }

    @Override
    protected float getFirstYLineRecursively() {
        if (this.lines == null || this.lines.size() == 0) {
            return 0.0f;
        }
        return this.lines.get(0).getFirstYLineRecursively();
    }
}

