/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.element;

import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.fr.third.fr.pdf.layout.border.Border;
import com.fr.third.fr.pdf.layout.border.SolidBorder;
import com.fr.third.fr.pdf.layout.element.BlockElement;
import com.fr.third.fr.pdf.layout.element.IElement;
import com.fr.third.fr.pdf.layout.element.Image;
import com.fr.third.fr.pdf.layout.element.Paragraph;
import com.fr.third.fr.pdf.layout.element.Table;
import com.fr.third.fr.pdf.layout.renderer.CellRenderer;
import com.fr.third.fr.pdf.layout.renderer.IRenderer;
import com.fr.third.fr.pdf.layout.renderer.PropertiesMap;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.text.MessageFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
extends BlockElement<Cell> {
    private static final Border DEFAULT_BORDER = new SolidBorder(0.5f);
    private int row;
    private int col;
    private int rowspan;
    private int colspan;
    protected PdfName role = PdfName.TD;
    protected AccessibilityProperties tagProperties;
    private static Float DefaultValue = Float.valueOf(2.0f);

    public Cell(int rowspan, int colspan) {
        this.rowspan = Math.max(rowspan, 1);
        this.colspan = Math.max(colspan, 1);
    }

    public Cell() {
        this(1, 1);
    }

    @Override
    public IRenderer getRenderer() {
        IRenderer cellRenderer = null;
        if (this.nextRenderer != null) {
            if (this.nextRenderer instanceof CellRenderer) {
                IRenderer renderer = this.nextRenderer;
                this.nextRenderer = this.nextRenderer.getNextRenderer();
                cellRenderer = (CellRenderer)renderer;
            } else {
                Logger logger = LoggerFactory.getLogger(Table.class);
                logger.error("Invalid renderer for Table: must be inherited from TableRenderer");
            }
        }
        return cellRenderer == null ? this.makeNewRenderer() : cellRenderer;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public int getColspan() {
        return this.colspan;
    }

    public <T extends IElement> Cell add(BlockElement<T> element) {
        this.childElements.add(element);
        return this;
    }

    public Cell add(Image element) {
        this.childElements.add(element);
        return this;
    }

    public Cell add(Table element) {
        this.childElements.add(element);
        return this;
    }

    public Cell add(String content) {
        return this.add(new Paragraph(content));
    }

    public Cell clone(boolean includeContent) {
        Cell newCell = new Cell(this.rowspan, this.colspan);
        newCell.row = this.row;
        newCell.col = this.col;
        newCell.properties = new PropertiesMap();
        newCell.properties.putAll(this.properties);
        if (includeContent) {
            newCell.childElements = new ArrayList(this.childElements);
        }
        return newCell;
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return (T1)DefaultValue;
            }
        }
        return super.getDefaultProperty(property);
    }

    @Override
    public Border getDefaultBorder() {
        return DEFAULT_BORDER;
    }

    @Override
    public float getDefaultFloatProperty(int property) {
        switch (property) {
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return 2.0f;
            }
        }
        return super.getDefaultFloatProperty(property);
    }

    public String toString() {
        return MessageFormat.format("Cell :row={0}, col={1}, rowspan={2}, colspan={3}", this.row, this.col, this.rowspan, this.colspan);
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
        if (PdfName.Artifact.equals(role)) {
            this.propagateArtifactRoleToChildElements();
        }
    }

    @Override
    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new AccessibilityProperties();
        }
        return this.tagProperties;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new CellRenderer(this);
    }

    protected Cell updateCellIndexes(int row, int col, int numberOfColumns) {
        this.row = row;
        this.col = col;
        this.colspan = Math.min(this.colspan, numberOfColumns - this.col);
        return this;
    }
}

