/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.color;

import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.pdf.colorspace.PdfDeviceCs;

public class DeviceRgb
extends Color {
    public DeviceRgb(int r, int g, int b) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public DeviceRgb(float r, float g, float b) {
        super(new PdfDeviceCs.Rgb(), new float[]{r, g, b});
    }

    public DeviceRgb() {
        this(0.0f, 0.0f, 0.0f);
    }

    public static DeviceRgb makeLighter(DeviceRgb rgbColor) {
        float b;
        float g;
        float r = rgbColor.getColorValue()[0];
        float v = Math.max(r, Math.max(g = rgbColor.getColorValue()[1], b = rgbColor.getColorValue()[2]));
        if (v == 0.0f) {
            return new DeviceRgb(84, 84, 84);
        }
        float multiplier = Math.min(1.0f, v + 0.33f) / v;
        r = multiplier * r;
        g = multiplier * g;
        b = multiplier * b;
        return new DeviceRgb(r, g, b);
    }

    public static DeviceRgb makeDarker(DeviceRgb rgbColor) {
        float r = rgbColor.getColorValue()[0];
        float g = rgbColor.getColorValue()[1];
        float b = rgbColor.getColorValue()[2];
        float v = Math.max(r, Math.max(g, b));
        float multiplier = Math.max(0.0f, (v - 0.33f) / v);
        r = multiplier * r;
        g = multiplier * g;
        b = multiplier * b;
        return new DeviceRgb(r, g, b);
    }
}

