/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font;

import com.fr.third.fr.pdf.io.IOException;
import com.fr.third.fr.pdf.io.font.FontProgram;
import com.fr.third.fr.pdf.io.font.FontProgramFactory;
import com.fr.third.fr.pdf.io.source.RandomAccessFileOrArray;
import com.fr.third.fr.pdf.io.source.RandomAccessSourceFactory;
import com.fr.third.fr.pdf.io.util.FileUtil;

public class TrueTypeCollection {
    protected RandomAccessFileOrArray raf;
    String encoding;
    int TTCSize = 0;
    String ttcPath;
    byte[] ttc;
    boolean cached = false;

    public TrueTypeCollection(byte[] ttc, String encoding) throws java.io.IOException {
        this.raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(ttc));
        this.ttc = ttc;
        this.encoding = encoding;
        this.initFontSize();
    }

    public TrueTypeCollection(String ttcPath, String encoding) throws Exception {
        if (!FileUtil.fileExists(ttcPath)) {
            throw new IOException("font.file {0} not.found").setMessageParams(ttcPath);
        }
        this.raf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createBestSource(ttcPath));
        this.ttcPath = ttcPath;
        this.encoding = encoding;
        this.initFontSize();
    }

    public FontProgram getFontByTccIndex(int ttcIndex) throws Exception {
        if (ttcIndex > this.TTCSize - 1) {
            throw new IOException("ttc.index.doesn't.exist.in.ttc.file");
        }
        if (this.ttcPath != null) {
            return FontProgramFactory.createFont(this.ttcPath, ttcIndex, this.cached);
        }
        return FontProgramFactory.createFont(this.ttc, ttcIndex, this.cached);
    }

    public int getTTCSize() {
        return this.TTCSize;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    private void initFontSize() throws java.io.IOException {
        String mainTag = this.raf.readString(4, "Cp1252");
        if (!mainTag.equals("ttcf")) {
            throw new IOException("{0} is.not.a.valid.ttc.file");
        }
        this.raf.skipBytes(4);
        this.TTCSize = this.raf.readInt();
    }
}

