/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font;

import com.fr.third.fr.pdf.io.font.FontCache;
import com.fr.third.fr.pdf.io.font.cmap.CMapCidByte;
import com.fr.third.fr.pdf.io.font.cmap.CMapCidUni;
import com.fr.third.fr.pdf.io.util.IntHashtable;

public class CMapEncoding {
    private String cmap;
    private String uniMap;
    private boolean isDirect;
    private CMapCidUni cid2Uni;
    private CMapCidByte cid2Code;
    private IntHashtable code2Cid;

    public CMapEncoding(String cmap) {
        this.cmap = cmap;
        if (cmap.equals("Identity-H") || cmap.equals("Identity-V")) {
            this.isDirect = true;
        }
    }

    public CMapEncoding(String cmap, String uniMap) {
        this.cmap = cmap;
        this.uniMap = uniMap;
        if (cmap.equals("Identity-H") || cmap.equals("Identity-V")) {
            this.cid2Uni = FontCache.getCid2UniCmap(uniMap);
            this.isDirect = true;
        } else {
            this.cid2Code = FontCache.getCid2Byte(cmap);
            this.code2Cid = this.cid2Code.getReversMap();
        }
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public boolean hasUniMap() {
        return this.uniMap != null && this.uniMap.length() > 0;
    }

    public String getRegistry() {
        if (this.isDirect()) {
            return "Adobe";
        }
        return this.cid2Code.getRegistry();
    }

    public String getOrdering() {
        if (this.isDirect()) {
            return "Identity";
        }
        return this.cid2Code.getOrdering();
    }

    public int getSupplement() {
        if (this.isDirect()) {
            return 0;
        }
        return this.cid2Code.getSupplement();
    }

    public String getUniMapName() {
        return this.uniMap;
    }

    public String getCmapName() {
        return this.cmap;
    }

    public int getCmapCode(int cid) {
        if (this.isDirect) {
            return cid;
        }
        return CMapEncoding.toInteger(this.cid2Code.lookup(cid));
    }

    public int getCidCode(int cmapCode) {
        if (this.isDirect) {
            return cmapCode;
        }
        return this.code2Cid.get(cmapCode);
    }

    private static int toInteger(byte[] bytes) {
        int result = 0;
        for (byte b : bytes) {
            result <<= 8;
            result += b & 0xFF;
        }
        return result;
    }
}

