/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.barcodes;

import com.fr.third.fr.pdf.barcodes.Barcode2D;
import com.fr.third.fr.pdf.barcodes.dmcode.DmParams;
import com.fr.third.fr.pdf.barcodes.dmcode.Placement;
import com.fr.third.fr.pdf.barcodes.dmcode.ReedSolomon;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.canvas.PdfCanvas;
import com.fr.third.fr.pdf.kernel.pdf.xobject.PdfFormXObject;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class BarcodeDataMatrix
extends Barcode2D {
    public static final int DM_NO_ERROR = 0;
    public static final int DM_ERROR_TEXT_TOO_BIG = 1;
    public static final int DM_ERROR_INVALID_SQUARE = 3;
    public static final int DM_ERROR_EXTENSION = 5;
    public static final int DM_AUTO = 0;
    public static final int DM_ASCII = 1;
    public static final int DM_C40 = 2;
    public static final int DM_TEXT = 3;
    public static final int DM_B256 = 4;
    public static final int DM_X21 = 5;
    public static final int DM_EDIFACT = 6;
    public static final int DM_RAW = 7;
    public static final int DM_EXTENSION = 32;
    public static final int DM_TEST = 64;
    public static final String DEFAULT_DATA_MATRIX_ENCODING = "iso-8859-1";
    private String encoding;
    private static final DmParams[] dmSizes = new DmParams[]{new DmParams(10, 10, 10, 10, 3, 3, 5), new DmParams(12, 12, 12, 12, 5, 5, 7), new DmParams(8, 18, 8, 18, 5, 5, 7), new DmParams(14, 14, 14, 14, 8, 8, 10), new DmParams(8, 32, 8, 16, 10, 10, 11), new DmParams(16, 16, 16, 16, 12, 12, 12), new DmParams(12, 26, 12, 26, 16, 16, 14), new DmParams(18, 18, 18, 18, 18, 18, 14), new DmParams(20, 20, 20, 20, 22, 22, 18), new DmParams(12, 36, 12, 18, 22, 22, 18), new DmParams(22, 22, 22, 22, 30, 30, 20), new DmParams(16, 36, 16, 18, 32, 32, 24), new DmParams(24, 24, 24, 24, 36, 36, 24), new DmParams(26, 26, 26, 26, 44, 44, 28), new DmParams(16, 48, 16, 24, 49, 49, 28), new DmParams(32, 32, 16, 16, 62, 62, 36), new DmParams(36, 36, 18, 18, 86, 86, 42), new DmParams(40, 40, 20, 20, 114, 114, 48), new DmParams(44, 44, 22, 22, 144, 144, 56), new DmParams(48, 48, 24, 24, 174, 174, 68), new DmParams(52, 52, 26, 26, 204, 102, 42), new DmParams(64, 64, 16, 16, 280, 140, 56), new DmParams(72, 72, 18, 18, 368, 92, 36), new DmParams(80, 80, 20, 20, 456, 114, 48), new DmParams(88, 88, 22, 22, 576, 144, 56), new DmParams(96, 96, 24, 24, 696, 174, 68), new DmParams(104, 104, 26, 26, 816, 136, 56), new DmParams(120, 120, 20, 20, 1050, 175, 68), new DmParams(132, 132, 22, 22, 1304, 163, 62), new DmParams(144, 144, 24, 24, 1558, 156, 62)};
    private static final String X12 = "\r*> 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int extOut;
    private short[] place;
    private byte[] image;
    private int height;
    private int width;
    private int ws;
    private int options;

    public BarcodeDataMatrix() {
        this.encoding = DEFAULT_DATA_MATRIX_ENCODING;
    }

    public BarcodeDataMatrix(String code) {
        this.encoding = DEFAULT_DATA_MATRIX_ENCODING;
        this.setCode(code);
    }

    public BarcodeDataMatrix(String code, String encoding) {
        this.encoding = encoding;
        this.setCode(code);
    }

    public Rectangle getBarcodeSize() {
        return new Rectangle(0.0f, 0.0f, this.width + 2 * this.ws, this.height + 2 * this.ws);
    }

    public Rectangle placeBarcode(PdfCanvas canvas, com.fr.third.fr.pdf.kernel.color.Color foreground) {
        return this.placeBarcode(canvas, foreground, 1.0f);
    }

    public PdfFormXObject createFormXObject(com.fr.third.fr.pdf.kernel.color.Color foreground, PdfDocument document) {
        return this.createFormXObject(foreground, 1.0f, document);
    }

    public PdfFormXObject createFormXObject(com.fr.third.fr.pdf.kernel.color.Color foreground, float moduleSide, PdfDocument document) {
        PdfFormXObject xObject = new PdfFormXObject((Rectangle)null);
        Rectangle rect = this.placeBarcode(new PdfCanvas(xObject, document), foreground, moduleSide);
        xObject.setBBox(new PdfArray(rect));
        return xObject;
    }

    public Rectangle placeBarcode(PdfCanvas canvas, com.fr.third.fr.pdf.kernel.color.Color foreground, float moduleSide) {
        if (this.image == null) {
            return null;
        }
        if (foreground != null) {
            canvas.setFillColor(foreground);
        }
        int w = this.width + 2 * this.ws;
        int h = this.height + 2 * this.ws;
        int stride = (w + 7) / 8;
        for (int k = 0; k < h; ++k) {
            int p = k * stride;
            for (int j = 0; j < w; ++j) {
                int b = this.image[p + j / 8] & 0xFF;
                if (((b <<= j % 8) & 0x80) == 0) continue;
                canvas.rectangle((float)j * moduleSide, (float)(h - k - 1) * moduleSide, moduleSide, moduleSide);
            }
        }
        canvas.fill();
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color foreground, Color background) {
        if (this.image == null) {
            return null;
        }
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        int w = this.width + 2 * this.ws;
        int h = this.height + 2 * this.ws;
        int[] pix = new int[w * h];
        int stride = (w + 7) / 8;
        int ptr = 0;
        for (int k = 0; k < h; ++k) {
            int p = k * stride;
            for (int j = 0; j < w; ++j) {
                int b = this.image[p + j / 8] & 0xFF;
                pix[ptr++] = ((b <<= j % 8) & 0x80) == 0 ? g : f;
            }
        }
        Image img = canvas.createImage(new MemoryImageSource(w, h, pix, 0, w));
        return img;
    }

    public Rectangle getBarcodeSize(float moduleHeight, float moduleWidth) {
        return new Rectangle(0.0f, 0.0f, (float)(this.width + 2 * this.ws) * moduleHeight, (float)(this.height + 2 * this.ws) * moduleWidth);
    }

    public int setCode(String text) {
        byte[] t;
        try {
            t = text.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException exc) {
            throw new IllegalArgumentException("text has to be encoded in iso-8859-1");
        }
        return this.setCode(t, 0, t.length);
    }

    public int setCode(byte[] text, int textOffset, int textSize) {
        DmParams dm;
        byte[] data = new byte[2500];
        this.extOut = 0;
        int extCount = this.processExtensions(text, textOffset, textSize, data);
        if (extCount < 0) {
            return 5;
        }
        int e = -1;
        if (this.height == 0 || this.width == 0) {
            int k;
            DmParams last = dmSizes[dmSizes.length - 1];
            e = BarcodeDataMatrix.getEncodation(text, textOffset + this.extOut, textSize - this.extOut, data, extCount, last.dataSize - extCount, this.options, false);
            if (e < 0) {
                return 1;
            }
            e += extCount;
            for (k = 0; k < dmSizes.length && BarcodeDataMatrix.dmSizes[k].dataSize < e; ++k) {
            }
            dm = dmSizes[k];
            this.height = dm.height;
            this.width = dm.width;
        } else {
            int k;
            for (k = 0; k < dmSizes.length && (this.height != BarcodeDataMatrix.dmSizes[k].height || this.width != BarcodeDataMatrix.dmSizes[k].width); ++k) {
            }
            if (k == dmSizes.length) {
                return 3;
            }
            dm = dmSizes[k];
            e = BarcodeDataMatrix.getEncodation(text, textOffset + this.extOut, textSize - this.extOut, data, extCount, dm.dataSize - extCount, this.options, true);
            if (e < 0) {
                return 1;
            }
            e += extCount;
        }
        if ((this.options & 0x40) != 0) {
            return 0;
        }
        this.image = new byte[(dm.width + 2 * this.ws + 7) / 8 * (dm.height + 2 * this.ws)];
        BarcodeDataMatrix.makePadding(data, e, dm.dataSize - e);
        this.place = Placement.doPlacement(dm.height - dm.height / dm.heightSection * 2, dm.width - dm.width / dm.widthSection * 2);
        int full = dm.dataSize + (dm.dataSize + 2) / dm.dataBlock * dm.errorBlock;
        ReedSolomon.generateECC(data, dm.dataSize, dm.dataBlock, dm.errorBlock);
        this.draw(data, full, dm);
        return 0;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWs() {
        return this.ws;
    }

    public void setWs(int ws) {
        this.ws = ws;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private static void makePadding(byte[] data, int position, int count) {
        if (count <= 0) {
            return;
        }
        data[position++] = -127;
        while (--count > 0) {
            int t = 129 + (position + 1) * 149 % 253 + 1;
            if (t > 254) {
                t -= 254;
            }
            data[position++] = (byte)t;
        }
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static int asciiEncodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength) {
        int ptrIn = textOffset;
        int ptrOut = dataOffset;
        textLength += textOffset;
        dataLength += dataOffset;
        while (ptrIn < textLength) {
            int c;
            if (ptrOut >= dataLength) {
                return -1;
            }
            if (BarcodeDataMatrix.isDigit(c = text[ptrIn++] & 0xFF) && ptrIn < textLength && BarcodeDataMatrix.isDigit(text[ptrIn] & 0xFF)) {
                data[ptrOut++] = (byte)((c - 48) * 10 + (text[ptrIn++] & 0xFF) - 48 + 130);
                continue;
            }
            if (c > 127) {
                if (ptrOut + 1 >= dataLength) {
                    return -1;
                }
                data[ptrOut++] = -21;
                data[ptrOut++] = (byte)(c - 128 + 1);
                continue;
            }
            data[ptrOut++] = (byte)(c + 1);
        }
        return ptrOut - dataOffset;
    }

    private static int b256Encodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength) {
        int k;
        if (textLength == 0) {
            return 0;
        }
        if (textLength < 250 && textLength + 2 > dataLength) {
            return -1;
        }
        if (textLength >= 250 && textLength + 3 > dataLength) {
            return -1;
        }
        data[dataOffset] = -25;
        if (textLength < 250) {
            data[dataOffset + 1] = (byte)textLength;
            k = 2;
        } else {
            data[dataOffset + 1] = (byte)(textLength / 250 + 249);
            data[dataOffset + 2] = (byte)(textLength % 250);
            k = 3;
        }
        System.arraycopy(text, textOffset, data, k + dataOffset, textLength);
        k += textLength + dataOffset;
        for (int j = dataOffset + 1; j < k; ++j) {
            int c = data[j] & 0xFF;
            int prn = 149 * (j + 1) % 255 + 1;
            int tv = c + prn;
            if (tv > 255) {
                tv -= 256;
            }
            data[j] = (byte)tv;
        }
        return k - dataOffset;
    }

    private static int X12Encodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength) {
        int k;
        int ptrIn;
        if (textLength == 0) {
            return 0;
        }
        int ptrOut = 0;
        byte[] x = new byte[textLength];
        int count = 0;
        for (ptrIn = 0; ptrIn < textLength; ++ptrIn) {
            int i = X12.indexOf((char)text[ptrIn + textOffset]);
            if (i >= 0) {
                x[ptrIn] = (byte)i;
                ++count;
                continue;
            }
            x[ptrIn] = 100;
            if (count >= 6) {
                count -= count / 3 * 3;
            }
            for (k = 0; k < count; ++k) {
                x[ptrIn - k - 1] = 100;
            }
            count = 0;
        }
        if (count >= 6) {
            count -= count / 3 * 3;
        }
        for (k = 0; k < count; ++k) {
            x[ptrIn - k - 1] = 100;
        }
        int c = 0;
        for (ptrIn = 0; ptrIn < textLength; ++ptrIn) {
            int ci;
            c = x[ptrIn];
            if (ptrOut >= dataLength) break;
            if (c < 40) {
                if (ptrIn == 0 || ptrIn > 0 && x[ptrIn - 1] > 40) {
                    data[dataOffset + ptrOut++] = -18;
                }
                if (ptrOut + 2 > dataLength) break;
                int n = 1600 * x[ptrIn] + 40 * x[ptrIn + 1] + x[ptrIn + 2] + 1;
                data[dataOffset + ptrOut++] = (byte)(n / 256);
                data[dataOffset + ptrOut++] = (byte)n;
                ptrIn += 2;
                continue;
            }
            if (ptrIn > 0 && x[ptrIn - 1] < 40) {
                data[dataOffset + ptrOut++] = -2;
            }
            if ((ci = text[ptrIn + textOffset] & 0xFF) > 127) {
                data[dataOffset + ptrOut++] = -21;
                ci -= 128;
            }
            if (ptrOut >= dataLength) break;
            data[dataOffset + ptrOut++] = (byte)(ci + 1);
        }
        c = 100;
        if (textLength > 0) {
            c = x[textLength - 1];
        }
        if (ptrIn != textLength || c < 40 && ptrOut >= dataLength) {
            return -1;
        }
        if (c < 40) {
            data[dataOffset + ptrOut++] = -2;
        }
        return ptrOut;
    }

    private static int EdifactEncodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength) {
        int ptrIn;
        if (textLength == 0) {
            return 0;
        }
        int ptrOut = 0;
        int edi = 0;
        int pedi = 18;
        boolean ascii = true;
        for (ptrIn = 0; ptrIn < textLength; ++ptrIn) {
            int c = text[ptrIn + textOffset] & 0xFF;
            if (((c & 0xE0) == 64 || (c & 0xE0) == 32) && c != 95) {
                if (ascii) {
                    if (ptrOut + 1 > dataLength) break;
                    data[dataOffset + ptrOut++] = -16;
                    ascii = false;
                }
                edi |= (c &= 0x3F) << pedi;
                if (pedi == 0) {
                    if (ptrOut + 3 > dataLength) break;
                    data[dataOffset + ptrOut++] = (byte)(edi >> 16);
                    data[dataOffset + ptrOut++] = (byte)(edi >> 8);
                    data[dataOffset + ptrOut++] = (byte)edi;
                    edi = 0;
                    pedi = 18;
                    continue;
                }
                pedi -= 6;
                continue;
            }
            if (!ascii) {
                edi |= 31 << pedi;
                if (ptrOut + 3 - pedi / 8 > dataLength) break;
                data[dataOffset + ptrOut++] = (byte)(edi >> 16);
                if (pedi <= 12) {
                    data[dataOffset + ptrOut++] = (byte)(edi >> 8);
                }
                if (pedi <= 6) {
                    data[dataOffset + ptrOut++] = (byte)edi;
                }
                ascii = true;
                pedi = 18;
                edi = 0;
            }
            if (c > 127) {
                if (ptrOut >= dataLength) break;
                data[dataOffset + ptrOut++] = -21;
                c -= 128;
            }
            if (ptrOut >= dataLength) break;
            data[dataOffset + ptrOut++] = (byte)(c + 1);
        }
        if (ptrIn != textLength) {
            return -1;
        }
        int dataSize = Integer.MAX_VALUE;
        for (int i = 0; i < dmSizes.length; ++i) {
            if (BarcodeDataMatrix.dmSizes[i].dataSize < dataOffset + ptrOut + (3 - pedi / 6)) continue;
            dataSize = BarcodeDataMatrix.dmSizes[i].dataSize;
            break;
        }
        if (dataSize - dataOffset - ptrOut <= 2 && pedi >= 6) {
            byte val;
            if (pedi <= 12) {
                val = (byte)(edi >> 18 & 0x3F);
                if ((val & 0x20) == 0) {
                    val = (byte)(val | 0x40);
                }
                data[dataOffset + ptrOut++] = (byte)(val + 1);
            }
            if (pedi <= 6) {
                val = (byte)(edi >> 12 & 0x3F);
                if ((val & 0x20) == 0) {
                    val = (byte)(val | 0x40);
                }
                data[dataOffset + ptrOut++] = (byte)(val + 1);
            }
        } else if (!ascii) {
            edi |= 31 << pedi;
            if (ptrOut + 3 - pedi / 8 > dataLength) {
                return -1;
            }
            data[dataOffset + ptrOut++] = (byte)(edi >> 16);
            if (pedi <= 12) {
                data[dataOffset + ptrOut++] = (byte)(edi >> 8);
            }
            if (pedi <= 6) {
                data[dataOffset + ptrOut++] = (byte)edi;
            }
        }
        return ptrOut;
    }

    private static int C40OrTextEncodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength, boolean c40) {
        int i;
        String shift3;
        String basic;
        if (textLength == 0) {
            return 0;
        }
        int ptrIn = 0;
        int ptrOut = 0;
        data[dataOffset + ptrOut++] = c40 ? -26 : -17;
        String shift2 = "!\"#$%&'()*+,-./:;<=>?@[\\]^_";
        if (c40) {
            basic = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            shift3 = "`abcdefghijklmnopqrstuvwxyz{|}~\u007f";
        } else {
            basic = " 0123456789abcdefghijklmnopqrstuvwxyz";
            shift3 = "`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~\u007f";
        }
        int[] enc = new int[textLength * 4 + 10];
        int encPtr = 0;
        int last0 = 0;
        int last1 = 0;
        while (ptrIn < textLength) {
            int idx;
            int c;
            if (encPtr % 3 == 0) {
                last0 = ptrIn;
                last1 = encPtr;
            }
            if ((c = text[textOffset + ptrIn++] & 0xFF) > 127) {
                c -= 128;
                enc[encPtr++] = 1;
                enc[encPtr++] = 30;
            }
            if ((idx = basic.indexOf((char)c)) >= 0) {
                enc[encPtr++] = idx + 3;
                continue;
            }
            if (c < 32) {
                enc[encPtr++] = 0;
                enc[encPtr++] = c;
                continue;
            }
            idx = shift2.indexOf((char)c);
            if (idx >= 0) {
                enc[encPtr++] = 1;
                enc[encPtr++] = idx;
                continue;
            }
            idx = shift3.indexOf((char)c);
            if (idx < 0) continue;
            enc[encPtr++] = 2;
            enc[encPtr++] = idx;
        }
        if (encPtr % 3 != 0) {
            ptrIn = last0;
            encPtr = last1;
        }
        if (encPtr / 3 * 2 > dataLength - 2) {
            return -1;
        }
        for (i = 0; i < encPtr; i += 3) {
            int a = 1600 * enc[i] + 40 * enc[i + 1] + enc[i + 2] + 1;
            data[dataOffset + ptrOut++] = (byte)(a / 256);
            data[dataOffset + ptrOut++] = (byte)a;
        }
        data[ptrOut++] = -2;
        i = BarcodeDataMatrix.asciiEncodation(text, ptrIn, textLength - ptrIn, data, ptrOut, dataLength - ptrOut);
        if (i < 0) {
            return i;
        }
        return ptrOut + i;
    }

    private void setBit(int x, int y, int xByte) {
        int n = y * xByte + x / 8;
        this.image[n] = (byte)(this.image[n] | (byte)(128 >> (x & 7)));
    }

    private void draw(byte[] data, int dataSize, DmParams dm) {
        int j;
        int i;
        int xByte = (dm.width + this.ws * 2 + 7) / 8;
        Arrays.fill(this.image, (byte)0);
        for (i = this.ws; i < dm.height + this.ws; i += dm.heightSection) {
            for (j = this.ws; j < dm.width + this.ws; j += 2) {
                this.setBit(j, i, xByte);
            }
        }
        for (i = dm.heightSection - 1 + this.ws; i < dm.height + this.ws; i += dm.heightSection) {
            for (j = this.ws; j < dm.width + this.ws; ++j) {
                this.setBit(j, i, xByte);
            }
        }
        for (i = this.ws; i < dm.width + this.ws; i += dm.widthSection) {
            for (j = this.ws; j < dm.height + this.ws; ++j) {
                this.setBit(i, j, xByte);
            }
        }
        for (i = dm.widthSection - 1 + this.ws; i < dm.width + this.ws; i += dm.widthSection) {
            for (j = 1 + this.ws; j < dm.height + this.ws; j += 2) {
                this.setBit(i, j, xByte);
            }
        }
        int p = 0;
        for (int ys = 0; ys < dm.height; ys += dm.heightSection) {
            for (int y = 1; y < dm.heightSection - 1; ++y) {
                for (int xs = 0; xs < dm.width; xs += dm.widthSection) {
                    for (int x = 1; x < dm.widthSection - 1; ++x) {
                        short z;
                        if ((z = this.place[p++]) != 1 && (z <= 1 || (data[z / 8 - 1] & 0xFF & 128 >> z % 8) == 0)) continue;
                        this.setBit(x + xs + this.ws, y + ys + this.ws, xByte);
                    }
                }
            }
        }
    }

    private static int getEncodation(byte[] text, int textOffset, int textSize, byte[] data, int dataOffset, int dataSize, int options, boolean firstMatch) {
        int[] e1 = new int[6];
        if (dataSize < 0) {
            return -1;
        }
        int e = -1;
        if ((options &= 7) == 0) {
            e1[0] = BarcodeDataMatrix.asciiEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            if (firstMatch && e1[0] >= 0) {
                return e1[0];
            }
            e1[1] = BarcodeDataMatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, false);
            if (firstMatch && e1[1] >= 0) {
                return e1[1];
            }
            e1[2] = BarcodeDataMatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, true);
            if (firstMatch && e1[2] >= 0) {
                return e1[2];
            }
            e1[3] = BarcodeDataMatrix.b256Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            if (firstMatch && e1[3] >= 0) {
                return e1[3];
            }
            e1[4] = BarcodeDataMatrix.X12Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            if (firstMatch && e1[4] >= 0) {
                return e1[4];
            }
            e1[5] = BarcodeDataMatrix.EdifactEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            if (firstMatch && e1[5] >= 0) {
                return e1[5];
            }
            if (e1[0] < 0 && e1[1] < 0 && e1[2] < 0 && e1[3] < 0 && e1[4] < 0 && e1[5] < 0) {
                return -1;
            }
            int j = 0;
            e = 99999;
            for (int k = 0; k < 6; ++k) {
                if (e1[k] < 0 || e1[k] >= e) continue;
                e = e1[k];
                j = k;
            }
            if (j == 0) {
                e = BarcodeDataMatrix.asciiEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            } else if (j == 1) {
                e = BarcodeDataMatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, false);
            } else if (j == 2) {
                e = BarcodeDataMatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, true);
            } else if (j == 3) {
                e = BarcodeDataMatrix.b256Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            } else if (j == 4) {
                e = BarcodeDataMatrix.X12Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            return e;
        }
        switch (options) {
            case 1: {
                return BarcodeDataMatrix.asciiEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            case 2: {
                return BarcodeDataMatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, true);
            }
            case 3: {
                return BarcodeDataMatrix.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, false);
            }
            case 4: {
                return BarcodeDataMatrix.b256Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            case 5: {
                return BarcodeDataMatrix.X12Encodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            case 6: {
                return BarcodeDataMatrix.EdifactEncodation(text, textOffset, textSize, data, dataOffset, dataSize);
            }
            case 7: {
                if (textSize > dataSize) {
                    return -1;
                }
                System.arraycopy(text, textOffset, data, dataOffset, textSize);
                return textSize;
            }
        }
        return -1;
    }

    private static int getNumber(byte[] text, int ptrIn, int n) {
        int v = 0;
        for (int j = 0; j < n; ++j) {
            int c;
            if ((c = text[ptrIn++] & 0xFF) < 48 || c > 57) {
                return -1;
            }
            v = v * 10 + c - 48;
        }
        return v;
    }

    private int processExtensions(byte[] text, int textOffset, int textSize, byte[] data) {
        if ((this.options & 0x20) == 0) {
            return 0;
        }
        int order = 0;
        int ptrIn = 0;
        int ptrOut = 0;
        while (ptrIn < textSize) {
            if (order > 20) {
                return -1;
            }
            int c = text[textOffset + ptrIn++] & 0xFF;
            ++order;
            switch (c) {
                case 46: {
                    this.extOut = ptrIn;
                    return ptrOut;
                }
                case 101: {
                    if (ptrIn + 6 > textSize) {
                        return -1;
                    }
                    int eci = BarcodeDataMatrix.getNumber(text, textOffset + ptrIn, 6);
                    if (eci < 0) {
                        return -1;
                    }
                    ptrIn += 6;
                    data[ptrOut++] = -15;
                    if (eci < 127) {
                        data[ptrOut++] = (byte)(eci + 1);
                        break;
                    }
                    if (eci < 16383) {
                        data[ptrOut++] = (byte)((eci - 127) / 254 + 128);
                        data[ptrOut++] = (byte)((eci - 127) % 254 + 1);
                        break;
                    }
                    data[ptrOut++] = (byte)((eci - 16383) / 64516 + 192);
                    data[ptrOut++] = (byte)((eci - 16383) / 254 % 254 + 1);
                    data[ptrOut++] = (byte)((eci - 16383) % 254 + 1);
                    break;
                }
                case 115: {
                    if (order != 1) {
                        return -1;
                    }
                    if (ptrIn + 9 > textSize) {
                        return -1;
                    }
                    int fn = BarcodeDataMatrix.getNumber(text, textOffset + ptrIn, 2);
                    if (fn <= 0 || fn > 16) {
                        return -1;
                    }
                    int ft = BarcodeDataMatrix.getNumber(text, textOffset + (ptrIn += 2), 2);
                    if (ft <= 1 || ft > 16) {
                        return -1;
                    }
                    int fi = BarcodeDataMatrix.getNumber(text, textOffset + (ptrIn += 2), 5);
                    if (fi < 0 || fn >= 64516) {
                        return -1;
                    }
                    ptrIn += 5;
                    data[ptrOut++] = -23;
                    data[ptrOut++] = (byte)(fn - 1 << 4 | 17 - ft);
                    data[ptrOut++] = (byte)(fi / 254 + 1);
                    data[ptrOut++] = (byte)(fi % 254 + 1);
                    break;
                }
                case 112: {
                    if (order != 1) {
                        return -1;
                    }
                    data[ptrOut++] = -22;
                    break;
                }
                case 109: {
                    if (order != 1) {
                        return -1;
                    }
                    if (ptrIn + 1 > textSize) {
                        return -1;
                    }
                    if ((c = text[textOffset + ptrIn++] & 0xFF) != 53 && c != 53) {
                        return -1;
                    }
                    data[ptrOut++] = -22;
                    data[ptrOut++] = (byte)(c == 53 ? 236 : 237);
                    break;
                }
                case 102: {
                    if (order != 1 && (order != 2 || text[textOffset] != 115 && text[textOffset] != 109)) {
                        return -1;
                    }
                    data[ptrOut++] = -24;
                }
            }
        }
        return -1;
    }
}

