/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.ctrl.impl;

import java.util.ArrayList;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.openwebflow.ctrl.RuntimeActivityDefinitionManager;
import org.openwebflow.ctrl.TaskFlowControlService;
import org.openwebflow.ctrl.command.CreateAndTakeTransitionCmd;
import org.openwebflow.ctrl.command.DeleteRunningTaskCmd;
import org.openwebflow.ctrl.command.StartActivityCmd;
import org.openwebflow.ctrl.creator.ChainedActivitiesCreator;
import org.openwebflow.ctrl.creator.MultiInstanceActivityCreator;
import org.openwebflow.ctrl.creator.RuntimeActivityDefinitionEntityIntepreter;
import org.openwebflow.mgr.common.SimpleRuntimeActivityDefinitionEntity;
import org.openwebflow.util.ProcessDefinitionUtils;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskFlowControlService
implements TaskFlowControlService {
    RuntimeActivityDefinitionManager _activitiesCreationStore;
    ProcessDefinitionEntity _processDefinition;
    ProcessEngine _processEngine;
    private String _processInstanceId;

    public DefaultTaskFlowControlService(RuntimeActivityDefinitionManager activitiesCreationStore, ProcessEngine processEngine, String processId) {
        this._activitiesCreationStore = activitiesCreationStore;
        this._processEngine = processEngine;
        this._processInstanceId = processId;
        String processDefId = ((ProcessInstance)this._processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(this._processInstanceId).singleResult()).getProcessDefinitionId();
        this._processDefinition = ProcessDefinitionUtils.getProcessDefinition(this._processEngine, processDefId);
    }

    private ActivityImpl[] cloneAndMakeChain(String prototypeActivityId, String nextActivityId, String ... assignees) throws Exception {
        SimpleRuntimeActivityDefinitionEntity info = new SimpleRuntimeActivityDefinitionEntity();
        info.setProcessDefinitionId(this._processDefinition.getId());
        info.setProcessInstanceId(this._processInstanceId);
        RuntimeActivityDefinitionEntityIntepreter radei = new RuntimeActivityDefinitionEntityIntepreter(info);
        radei.setPrototypeActivityId(prototypeActivityId);
        radei.setAssignees(CollectionUtils.arrayToList((Object)assignees));
        radei.setNextActivityId(nextActivityId);
        ActivityImpl[] activities = new ChainedActivitiesCreator().createActivities(this._processEngine, this._processDefinition, info);
        this.moveTo(activities[0].getId());
        this.recordActivitiesCreation(info);
        return activities;
    }

    private void executeCommand(Command<Void> command) {
        ((RuntimeServiceImpl)this._processEngine.getRuntimeService()).getCommandExecutor().execute(command);
    }

    private TaskEntity getCurrentTask() {
        return (TaskEntity)this._processEngine.getTaskService().createTaskQuery().processInstanceId(this._processInstanceId).active().singleResult();
    }

    private TaskEntity getTaskById(String taskId) {
        return (TaskEntity)this._processEngine.getTaskService().createTaskQuery().taskId(taskId).singleResult();
    }

    @Override
    public ActivityImpl[] insertTasksAfter(String targetTaskDefinitionKey, String ... assignees) throws Exception {
        ArrayList<String> assigneeList = new ArrayList<String>();
        assigneeList.add(Authentication.getAuthenticatedUserId());
        assigneeList.addAll(CollectionUtils.arrayToList((Object)assignees));
        String[] newAssignees = assigneeList.toArray(new String[0]);
        ActivityImpl prototypeActivity = ProcessDefinitionUtils.getActivity(this._processEngine, this._processDefinition.getId(), targetTaskDefinitionKey);
        return this.cloneAndMakeChain(targetTaskDefinitionKey, ((PvmTransition)prototypeActivity.getOutgoingTransitions().get(0)).getDestination().getId(), newAssignees);
    }

    @Override
    public ActivityImpl[] insertTasksBefore(String targetTaskDefinitionKey, String ... assignees) throws Exception {
        return this.cloneAndMakeChain(targetTaskDefinitionKey, targetTaskDefinitionKey, assignees);
    }

    @Override
    public void moveBack() throws Exception {
        this.moveBack(this.getCurrentTask());
    }

    @Override
    public void moveBack(TaskEntity currentTaskEntity) throws Exception {
        ActivityImpl activity = (ActivityImpl)((PvmTransition)ProcessDefinitionUtils.getActivity(this._processEngine, currentTaskEntity.getProcessDefinitionId(), currentTaskEntity.getTaskDefinitionKey()).getIncomingTransitions().get(0)).getSource();
        this.moveTo(currentTaskEntity, activity);
    }

    @Override
    public void moveForward() throws Exception {
        this.moveForward(this.getCurrentTask());
    }

    @Override
    public void moveForward(TaskEntity currentTaskEntity) throws Exception {
        ActivityImpl activity = (ActivityImpl)((PvmTransition)ProcessDefinitionUtils.getActivity(this._processEngine, currentTaskEntity.getProcessDefinitionId(), currentTaskEntity.getTaskDefinitionKey()).getOutgoingTransitions().get(0)).getDestination();
        this.moveTo(currentTaskEntity, activity);
    }

    @Override
    public void moveTo(String targetTaskDefinitionKey) throws Exception {
        this.moveTo(this.getCurrentTask(), targetTaskDefinitionKey);
    }

    @Override
    public void moveTo(String currentTaskId, String targetTaskDefinitionKey) throws Exception {
        this.moveTo(this.getTaskById(currentTaskId), targetTaskDefinitionKey);
    }

    private void moveTo(TaskEntity currentTaskEntity, ActivityImpl activity) {
        this.executeCommand(new StartActivityCmd(currentTaskEntity.getExecutionId(), activity));
        this.executeCommand(new DeleteRunningTaskCmd(currentTaskEntity));
    }

    @Override
    public void moveTo(TaskEntity currentTaskEntity, String targetTaskDefinitionKey) throws Exception {
        ActivityImpl activity = ProcessDefinitionUtils.getActivity(this._processEngine, currentTaskEntity.getProcessDefinitionId(), targetTaskDefinitionKey);
        this.moveTo(currentTaskEntity, activity);
    }

    private void recordActivitiesCreation(SimpleRuntimeActivityDefinitionEntity info) throws Exception {
        info.serializeProperties();
        this._activitiesCreationStore.save(info);
    }

    @Override
    public ActivityImpl split(String targetTaskDefinitionKey, boolean isSequential, String ... assignees) throws Exception {
        SimpleRuntimeActivityDefinitionEntity info = new SimpleRuntimeActivityDefinitionEntity();
        info.setProcessDefinitionId(this._processDefinition.getId());
        info.setProcessInstanceId(this._processInstanceId);
        RuntimeActivityDefinitionEntityIntepreter radei = new RuntimeActivityDefinitionEntityIntepreter(info);
        radei.setPrototypeActivityId(targetTaskDefinitionKey);
        radei.setAssignees(CollectionUtils.arrayToList((Object)assignees));
        radei.setSequential(isSequential);
        ActivityImpl clone = new MultiInstanceActivityCreator().createActivities(this._processEngine, this._processDefinition, info)[0];
        TaskEntity currentTaskEntity = this.getCurrentTask();
        this.executeCommand(new CreateAndTakeTransitionCmd(currentTaskEntity.getExecutionId(), clone));
        this.executeCommand(new DeleteRunningTaskCmd(currentTaskEntity));
        this.recordActivitiesCreation(info);
        return clone;
    }

    @Override
    public ActivityImpl split(String targetTaskDefinitionKey, String ... assignee) throws Exception {
        return this.split(targetTaskDefinitionKey, true, assignee);
    }
}

