/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartEquationType;
import com.fr.chart.chartglyph.Equation;
import com.fr.chart.chartglyph.ExpEquation;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.chart.chartglyph.LinearEquation;
import com.fr.chart.chartglyph.LogEquation;
import com.fr.chart.chartglyph.MoveAverageEquation;
import com.fr.chart.chartglyph.PolynomialEquation;
import com.fr.chart.chartglyph.PowerEquation;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.geom.Rectangle2D;

public class TrendLineGlyph
extends FoldLine {
    private static final long serialVersionUID = 6388397140455844687L;
    private Equation equation = null;

    public Equation getEquation() {
        return this.equation;
    }

    public TrendLineGlyph(ChartEquationType chartEquationType, int n, int n2) {
        this.equation = this.generateEquation(chartEquationType);
        this.equation.setSquare(n);
        this.equation.setAverage(n2);
    }

    private Equation generateEquation(ChartEquationType chartEquationType) {
        switch (chartEquationType) {
            case LINEAR: {
                return new LinearEquation();
            }
            case POLYNOMIAL: {
                return new PolynomialEquation();
            }
            case LOG: {
                return new LogEquation();
            }
            case EXPONENT: {
                return new ExpEquation();
            }
            case POWER: {
                return new PowerEquation();
            }
            case MA: {
                return new MoveAverageEquation();
            }
        }
        return new PolynomialEquation();
    }

    public void drawShape(Rectangle2D rectangle2D) {
        if (this.equation == null) {
            return;
        }
        this.setGeneralPath(this.equation.getShapePath(rectangle2D));
    }

    public void fitting(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length || this.equation == null) {
            return;
        }
        this.equation.setSquare(Math.min(dArray.length - 1, this.equation.getSquare()));
        this.equation.fitting(dArray, dArray2);
    }

    public String toString() {
        return this.equation == null ? "" : this.equation.toString();
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("equation", this.equation.getEquationType().ordinal());
        jSONObject.put("square", this.equation.getSquare());
        jSONObject.put("average", this.equation.getAverage());
        return jSONObject;
    }
}

