/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Pie;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Pie3D;
import com.fr.chart.chartglyph.PiePlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Pie3DPlotGlyph
extends PiePlotGlyph {
    private static final long serialVersionUID = -8454922131125531977L;
    private static final double BIG_ELLIPSE_WIDTH = 1.2;
    private static final double BIG_ELLIPSE_HEIGHT = 0.93;
    private static final double THICKNESS = 5.0;
    private static final double ROUND = 360.0;
    private int depth = 20;
    private Projection projection = new Projection();
    private Pie3D pie3d = new Pie3D();

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public boolean equals(Object object) {
        return object instanceof Pie3DPlotGlyph && super.equals(object) && ((Pie3DPlotGlyph)object).depth == this.depth && ComparatorUtils.equals((Object)((Pie3DPlotGlyph)object).projection, (Object)this.projection);
    }

    public void draw(Graphics graphics, int n) {
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.pie3d.drawWithoutSide(graphics2D, n);
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            this.getSeries(i).drawLabel(graphics, n);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public String getPlotGlyphType() {
        return "Pie3DPlotGlyph";
    }

    public Object clone() throws CloneNotSupportedException {
        Pie3DPlotGlyph pie3DPlotGlyph = (Pie3DPlotGlyph)super.clone();
        if (this.projection != null) {
            pie3DPlotGlyph.projection = (Projection)this.projection.clone();
        }
        return pie3DPlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("depth", this.depth);
        jSONObject.put("projection", (Object)this.projection.toJSONObject());
        return jSONObject;
    }

    protected boolean isSmallerThan(PiePlotGlyph.PointAndAngle pointAndAngle, PiePlotGlyph.PointAndAngle pointAndAngle2) {
        Pie3D pie3D = (Pie3D)pointAndAngle.dataPoint4Pie.getDrawImpl();
        Pie3D pie3D2 = (Pie3D)pointAndAngle2.dataPoint4Pie.getDrawImpl();
        return pie3D.getCylinder(0).getExtent() < pie3D2.getCylinder(0).getExtent();
    }

    public void layoutDataSeriesGlyph(int n) {
        this.pie3d.clearCylinder();
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            this.deal4EachCategory(i, n);
        }
        this.dealLabelBoundsInOrder();
    }

    protected void deal4EachCategory(int n, int n2) {
        double d = this.getBounds().getWidth() / (double)this.getCategoryCount();
        this.initLabelData(n, n2);
        GeneralPath generalPath = new GeneralPath();
        this.pie3d.setProjection(this.projection);
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n);
            if (dataPoint4Pie.isValueIsNull()) continue;
            Pie3D pie3D = new Pie3D();
            pie3D.setProjection(this.projection);
            double d2 = this.getSeriesStartAngle(n, i);
            double d3 = (double)n * d + d / 2.0;
            Point2D.Double double_ = new Point2D.Double(d3, this.getBounds().getHeight() / 2.0);
            double d4 = this.radius / 5.0;
            Cylinder cylinder = new Cylinder(0.0, d4, this.radius);
            cylinder.setX(((Point2D)double_).getX());
            cylinder.setY(((Point2D)double_).getY());
            cylinder.setStart(d2);
            cylinder.setExtent(this.getPercent(i, n) * 360.0);
            cylinder.setProjection(this.projection);
            this.getConditionCollection().changeStyleConditionWithInfo(cylinder.getColorInfo(), dataPoint4Pie, this.createColors4Series());
            pie3D.addCylinder(cylinder);
            this.pie3d.addCylinder(cylinder);
            dataPoint4Pie.setDrawImpl(pie3D);
        }
        this.dealWithCategoryLabels(n, n2);
    }

    protected boolean adjustLabelBoundsY(GeneralPath generalPath, PiePlotGlyph.PointAndAngle pointAndAngle, int n, double d, double d2, boolean bl) {
        Rectangle2D rectangle2D = pointAndAngle.dataPoint4Pie.getDataLabel().getBounds();
        double d3 = pointAndAngle.centerAngle;
        while (generalPath.intersects(rectangle2D)) {
            d3 = bl ? (d3 += 1.0) : (d3 -= 1.0);
            this.calculateLabelBoundsWithAngle(d3, pointAndAngle, n, rectangle2D);
        }
        pointAndAngle.dataPoint4Pie.getDataLabel().setBounds(rectangle2D);
        generalPath.append(rectangle2D, false);
        if (d3 < d || d3 > d2) {
            return false;
        }
        if (!this.isGuideLineShow(pointAndAngle.dataPoint4Pie) || !pointAndAngle.dataPoint4Pie.isShowLabel()) {
            return true;
        }
        this.dealWidth3DLine(null, pointAndAngle, d3);
        return true;
    }

    protected void dealWidthLine(Point2D point2D, PiePlotGlyph.PointAndAngle pointAndAngle) {
        this.dealWidth3DLine(point2D, pointAndAngle, pointAndAngle.centerAngle);
    }

    private void dealWidth3DLine(Point2D point2D, PiePlotGlyph.PointAndAngle pointAndAngle, double d) {
        GeneralPath generalPath = new GeneralPath();
        Pie3D pie3D = (Pie3D)pointAndAngle.dataPoint4Pie.getDrawImpl();
        Cylinder cylinder = pie3D.getCylinder(0);
        Point2D point2D2 = Cylinder.getArcPoint(cylinder.bottom(), pointAndAngle.centerAngle);
        if (pointAndAngle.centerAngle >= 0.0 && pointAndAngle.centerAngle <= 180.0) {
            point2D2 = Cylinder.getArcPoint(cylinder.top(), pointAndAngle.centerAngle);
        }
        double d2 = point2D2.getX();
        double d3 = point2D2.getY();
        generalPath.moveTo(d2, d3);
        Arc2D arc2D = cylinder.top();
        double d4 = arc2D.getWidth() / 2.0;
        Arc2D.Double double_ = new Arc2D.Double(new Rectangle((int)(arc2D.getCenterX() - d4 * 1.2), (int)(arc2D.getCenterY() - 0.93 * d4), (int)(arc2D.getWidth() * 1.2), (int)(arc2D.getWidth() * 0.93)), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
        point2D2 = Cylinder.getArcPoint(double_, d);
        d2 = point2D2.getX();
        d3 = point2D2.getY();
        generalPath.lineTo(d2, d3);
        d2 = pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0 ? (d2 -= this.radius * 0.1) : (d2 += this.radius * 0.1);
        generalPath.lineTo(d2, d3);
        pointAndAngle.dataPoint4Pie.setLeadLine(generalPath);
    }

    protected Point2D calculateLabelBoundsWithAngle(double d, PiePlotGlyph.PointAndAngle pointAndAngle, int n, Rectangle2D rectangle2D) {
        int n2 = pointAndAngle.dataPoint4Pie.getSeriesIndex();
        int n3 = pointAndAngle.dataPoint4Pie.getCategoryIndex();
        Point2D point2D = this.getCenterPoint(n2, n3);
        Dimension2D dimension2D = this.getLabelDim(pointAndAngle.dataPoint4Pie, n);
        double d2 = dimension2D.getHeight();
        double d3 = dimension2D.getWidth();
        Pie3D pie3D = (Pie3D)pointAndAngle.dataPoint4Pie.getDrawImpl();
        Cylinder cylinder = pie3D.getCylinder(0);
        Arc2D arc2D = cylinder.top();
        double d4 = arc2D.getWidth() / 2.0;
        Arc2D.Double double_ = new Arc2D.Double(new Rectangle((int)(arc2D.getCenterX() - d4 * 1.2), (int)(arc2D.getCenterY() - 0.93 * d4), (int)(arc2D.getWidth() * 1.2), (int)(arc2D.getWidth() * 0.93)), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
        Point2D point2D2 = Cylinder.getArcPoint(double_, d);
        double d5 = point2D2.getX();
        double d6 = point2D2.getY();
        double d7 = this.radius * 0.1 + 2.0;
        if (pointAndAngle.centerAngle >= 90.0 && pointAndAngle.centerAngle <= 270.0) {
            rectangle2D.setRect(d5 - d7 - d3, d6 - d2 / 2.0, d3, d2);
        } else {
            rectangle2D.setRect(d5 + d7, d6 - d2 / 2.0, d3, d2);
        }
        return point2D;
    }

    public void dealLeadLineSeries() {
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            for (int j = 0; j < this.getSeriesSize(); ++j) {
                DataSeries dataSeries = this.getSeries(j);
                DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(i);
                if (dataPoint4Pie.isValueIsNull()) continue;
                Pie3D pie3D = (Pie3D)dataPoint4Pie.getDrawImpl();
                Cylinder cylinder = pie3D.getCylinder(0);
                double d = this.getHalfAngle(this.getSeriesStartAngle(i, j), j, i);
                this.dealLeadLine(cylinder.top(), dataPoint4Pie, d % 360.0);
            }
        }
    }

    protected void dealInsideLabelBounds(DataPoint dataPoint, int n) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        Point2D point2D = this.getTopArcCenterPoint(dataPoint);
        if (point2D != null) {
            double d = this.getLabelDim(dataPoint, n).getHeight();
            double d2 = this.getLabelDim(dataPoint, n).getWidth();
            double d3 = point2D.getX() - d2 / 2.0;
            double d4 = point2D.getY() - d / 2.0;
            textGlyph.setBounds(new Rectangle2D.Double(d3, d4, d2, d));
        } else {
            textGlyph.setBounds(null);
        }
    }

    private Point2D getTopArcCenterPoint(DataPoint dataPoint) {
        if (dataPoint.getDrawImpl() != null) {
            Pie3D pie3D = (Pie3D)dataPoint.getDrawImpl();
            return pie3D.topCenterPoint(new Point2D.Double(this.getBounds().getWidth() / 2.0, this.getBounds().getHeight() / 2.0));
        }
        return null;
    }

    public boolean is3DPlotGlyph() {
        return true;
    }

    public String getChartType() {
        return "Pie3D";
    }

    public String getSmallIconType() {
        return "Pie";
    }

    protected boolean isNotNeedMoveChangeLabelRadius(Shape shape, Rectangle2D rectangle2D) {
        return true;
    }

    public void drawShape4Series(Graphics graphics, int n) {
        this.pie3d.drawWithoutSide(graphics, n);
    }

    protected double getPercent(int n, int n2) {
        double d = this.getTotalValue(n2);
        if (d <= 0.0) {
            return 0.0;
        }
        DataSeries dataSeries = this.getSeries(n);
        DataPoint4Pie dataPoint4Pie = (DataPoint4Pie)dataSeries.getDataPoint(n2);
        return Math.abs(dataPoint4Pie.getValue()) / d;
    }
}

