/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.BaseXMLUtils;
import com.fr.chart.chartglyph.AllEqualMarker;
import com.fr.chart.chartglyph.AntiClockLineMarker;
import com.fr.chart.chartglyph.CircleFilledMarker;
import com.fr.chart.chartglyph.CircleMarker;
import com.fr.chart.chartglyph.ClockLineMarker;
import com.fr.chart.chartglyph.CrossMarker;
import com.fr.chart.chartglyph.DiamondFilledMarker;
import com.fr.chart.chartglyph.DiamondMarker;
import com.fr.chart.chartglyph.DowJonesMarker;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MinusSignMarker;
import com.fr.chart.chartglyph.NullMarker;
import com.fr.chart.chartglyph.PlusSignMarker;
import com.fr.chart.chartglyph.PointMarker;
import com.fr.chart.chartglyph.RoundFilledMarker;
import com.fr.chart.chartglyph.RoundMarker;
import com.fr.chart.chartglyph.SquareFilledMarker;
import com.fr.chart.chartglyph.SquareMarker;
import com.fr.chart.chartglyph.StarMarker;
import com.fr.chart.chartglyph.TriangleFilledMarker;
import com.fr.chart.chartglyph.TriangleMarker;
import com.fr.chart.chartglyph.XMarker;
import com.fr.general.Background;
import com.fr.stable.ListMap;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class MarkerFactory {
    private static ListMap MARKERS = null;

    private static ListMap getMarkers() {
        if (MARKERS != null) {
            return MARKERS;
        }
        MARKERS = new ListMap();
        MARKERS.put((Object)"RoundMarker", (Object)new RoundMarker());
        MARKERS.put((Object)"RoundFilledMarker", (Object)new RoundFilledMarker());
        MARKERS.put((Object)"SquareFilledMarker", (Object)new SquareFilledMarker());
        MARKERS.put((Object)"TriangleFilledMarker", (Object)new TriangleFilledMarker());
        MARKERS.put((Object)"DiamondFilledMarker", (Object)new DiamondFilledMarker());
        MARKERS.put((Object)"DiamondMarker", (Object)new DiamondMarker());
        MARKERS.put((Object)"SquareMarker", (Object)new SquareMarker());
        MARKERS.put((Object)"TriangleMarker", (Object)new TriangleMarker());
        MARKERS.put((Object)"NullMarker", (Object)new NullMarker());
        return MARKERS;
    }

    public static Marker[] getMarkerArray() {
        Object[] objectArray = MarkerFactory.getMarkers().values().toArray();
        Marker[] markerArray = new Marker[objectArray.length];
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                markerArray[i] = (Marker)((Marker)objectArray[i]).clone();
                if (!(markerArray[i] instanceof NullMarker) || i <= 0) continue;
                Marker marker = markerArray[0];
                markerArray[0] = markerArray[i];
                markerArray[i] = marker;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new Marker[0];
        }
        return markerArray;
    }

    public static Marker createMarker(String string) {
        Object object = MarkerFactory.getMarkers().get((Object)string);
        if (!(object instanceof Marker)) {
            return new DiamondFilledMarker();
        }
        try {
            return (Marker)((Marker)object).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new DiamondFilledMarker();
        }
    }

    public static String markerIndex2String(int n) {
        Object object = MarkerFactory.getMarkers().getByIndex(n % (MarkerFactory.getMarkers().size() - 1));
        if (!(object instanceof Marker)) {
            return "DiamondFilledMarker";
        }
        return ((Marker)object).getMarkerType();
    }

    public static Marker readMarker(XMLableReader xMLableReader) {
        Marker marker = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.equals("null")) {
                return null;
            }
            marker = string.endsWith(".AllEqualMarker") ? new AllEqualMarker() : (string.endsWith(".AntiClockLineMarker") ? new AntiClockLineMarker() : (string.endsWith(".CircleMarker") ? new CircleMarker() : (string.endsWith(".CircleFilledMarker") ? new CircleFilledMarker() : (string.endsWith(".ClockLineMarker") ? new ClockLineMarker() : (string.endsWith(".CrossMarker") ? new CrossMarker() : (string.endsWith(".DiamondFilledMarker") ? new DiamondFilledMarker() : (string.endsWith(".DiamondMarker") ? new DiamondMarker() : (string.endsWith(".DowJonesMarker") ? new DowJonesMarker() : (string.endsWith(".MinusSignMarker") ? new MinusSignMarker() : MarkerFactory.readSomeMarker(string))))))))));
        }
        if (marker != null) {
            marker.setSize(xMLableReader.getAttrAsDouble("size", 5.0));
            String string2 = xMLableReader.getTagName();
            if (string2.equals("Background")) {
                marker.setBackground(BaseXMLUtils.readBackground((XMLableReader)xMLableReader));
            }
        }
        return marker;
    }

    private static Marker readSomeMarker(String string) {
        Marker marker = null;
        if (string.endsWith(".NullMarker")) {
            marker = new NullMarker();
        } else if (string.endsWith(".PlusSignMarker")) {
            marker = new PlusSignMarker();
        } else if (string.endsWith(".PointMarker")) {
            marker = new PointMarker();
        } else if (string.endsWith(".RoundFilledMarker")) {
            marker = new RoundFilledMarker();
        } else if (string.endsWith(".RoundMarker")) {
            marker = new RoundMarker();
        } else if (string.endsWith(".SquareFilledMarker")) {
            marker = new SquareFilledMarker();
        } else if (string.endsWith(".SquareMarker")) {
            marker = new SquareMarker();
        } else if (string.endsWith(".StarMarker")) {
            marker = new StarMarker();
        } else if (string.endsWith(".TriangleFilledMarker")) {
            marker = new TriangleFilledMarker();
        } else if (string.endsWith(".TriangleMarker")) {
            marker = new TriangleMarker();
        } else if (string.endsWith(".XMarker")) {
            marker = new XMarker();
        }
        return marker;
    }

    public static void writeMarker(XMLPrintWriter xMLPrintWriter, Marker marker) {
        xMLPrintWriter.startTAG("Marker");
        if (marker == null) {
            xMLPrintWriter.attr("class", "null");
        } else {
            xMLPrintWriter.attr("class", marker.getClass().getName());
            xMLPrintWriter.attr("size", marker.getSize());
            BaseXMLUtils.writeBackground((XMLPrintWriter)xMLPrintWriter, (Background)marker.getBackground());
        }
        xMLPrintWriter.end();
    }
}

