/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Base64;
import com.fr.base.Utils;
import com.fr.chart.base.ColorSelect4Shape;
import com.fr.chart.chartglyph.MapShapeValue;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Image;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;

public class MapAttr
implements XMLable {
    private static final long serialVersionUID = -1326391314659071038L;
    public static final String XML_TAG = "MapAttr";
    private Image mapImage;
    private HashMap shapeValues = new HashMap();
    private HashMap layersTo = new HashMap();
    private int versionID = 1;

    public String getLayerTo(String string) {
        if (this.layersTo.containsKey(string)) {
            return Utils.objectToString(this.layersTo.get(string));
        }
        return "";
    }

    public boolean containsLayerName(String string) {
        return this.layersTo.containsKey(string);
    }

    public void putLayerTo(Object object, Object object2) {
        this.layersTo.put(object, object2);
    }

    public void setMapImage(Image image) {
        this.mapImage = image;
    }

    public Image getMapImage() {
        return this.mapImage;
    }

    public void clearShapeValues() {
        this.shapeValues.clear();
    }

    public int shapeValueSize() {
        return this.shapeValues.size();
    }

    public void addMapShapeValue(String string, MapShapeValue mapShapeValue) {
        this.shapeValues.put(string, mapShapeValue);
    }

    public MapShapeValue getShapeValue(String string) {
        if (this.shapeValues.containsKey(string)) {
            return (MapShapeValue)this.shapeValues.get(string);
        }
        return null;
    }

    public int getVersionID() {
        return this.versionID;
    }

    public void setVersionID(int n) {
        this.versionID = n;
    }

    public void addVersionID() {
        ++this.versionID;
    }

    public void removeMapShapeValue(MapShapeValue mapShapeValue) {
        this.shapeValues.remove(mapShapeValue);
    }

    public Iterator shapeValuesIterator() {
        return this.shapeValues.keySet().iterator();
    }

    private void putNameValue(String string, String string2) {
        if (this.shapeValues.containsKey(string)) {
            MapShapeValue mapShapeValue = (MapShapeValue)this.shapeValues.get(string);
            mapShapeValue.setNameTo(string2);
        } else {
            MapShapeValue mapShapeValue = new MapShapeValue();
            this.shapeValues.put(string, mapShapeValue);
            mapShapeValue.setNameTo(string2);
        }
    }

    public Iterator nameToKeyIterator() {
        return this.shapeValues.keySet().iterator();
    }

    public Object getNameToValue(String string) {
        if (this.shapeValues.containsKey(string)) {
            MapShapeValue mapShapeValue = (MapShapeValue)this.shapeValues.get(string);
            return mapShapeValue != null ? mapShapeValue.getNameTo() : "";
        }
        return string;
    }

    public MapShapeValue getOneShapeValueInPoint(Point[] pointArray) {
        for (Object k : this.shapeValues.keySet()) {
            MapShapeValue mapShapeValue = (MapShapeValue)this.shapeValues.get(k);
            Object[] objectArray = mapShapeValue.getShape();
            if (!ComparatorUtils.equals((Object[])objectArray, (Object[])pointArray)) continue;
            return mapShapeValue;
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals((String)"MapImage", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals((String)"IM", (String)xMLableReader.getTagName())) {
                            MapAttr.this.setMapImage(GeneralXMLTools.readImage((XMLableReader)xMLableReader));
                        }
                    }
                });
            } else if (ComparatorUtils.equals((String)"ShapeNameValueMapOne", (String)string)) {
                final String string2 = xMLableReader.getAttrAsString("name", "");
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals((String)"MapShapeValue", (String)xMLableReader.getTagName())) {
                            MapShapeValue mapShapeValue = MapAttr.this.getShapeValue(string2);
                            if (mapShapeValue == null) {
                                mapShapeValue = new MapShapeValue();
                                mapShapeValue.setNameTo(string2);
                            }
                            String string = mapShapeValue.getNameTo();
                            xMLableReader.readXMLObject((XMLReadable)mapShapeValue);
                            if (StringUtils.isEmpty((String)mapShapeValue.getNameTo())) {
                                mapShapeValue.setNameTo(string);
                            }
                            MapAttr.this.addMapShapeValue(string2, mapShapeValue);
                        }
                    }
                });
            } else if (ComparatorUtils.equals((String)"NameToValue", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals((String)"NewNameToValue", (String)xMLableReader.getTagName())) {
                            String string = xMLableReader.getAttrAsString("name", "");
                            String string2 = xMLableReader.getAttrAsString("value", "");
                            MapAttr.this.putNameValue(string, string2);
                        }
                    }
                });
            } else if (ComparatorUtils.equals((String)"LayerToValue", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals((String)"NewLayerToValue", (String)xMLableReader.getTagName())) {
                            String string = xMLableReader.getAttrAsString("name", "");
                            String string2 = xMLableReader.getAttrAsString("value", "");
                            MapAttr.this.putLayerTo(string, string2);
                        }
                    }
                });
            } else if (ComparatorUtils.equals((String)"verison", (String)string)) {
                this.versionID = xMLableReader.getAttrAsInt("value", this.versionID);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        MapShapeValue mapShapeValue;
        Object k;
        Iterator iterator;
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("verison").attr("value", this.versionID).end();
        if (this.getMapImage() != null) {
            xMLPrintWriter.startTAG("MapImage");
            GeneralXMLTools.writeImage((XMLPrintWriter)xMLPrintWriter, (Image)this.getMapImage());
            xMLPrintWriter.end();
        }
        if (this.shapeValues != null && !this.shapeValues.isEmpty()) {
            iterator = this.shapeValues.keySet().iterator();
            while (iterator.hasNext()) {
                xMLPrintWriter.startTAG("ShapeNameValueMapOne");
                k = iterator.next();
                xMLPrintWriter.attr("name", Utils.objectToString(k));
                mapShapeValue = (MapShapeValue)this.shapeValues.get(k);
                mapShapeValue.writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
        if (this.layersTo != null && !this.layersTo.isEmpty()) {
            xMLPrintWriter.startTAG("LayerToValue");
            iterator = this.layersTo.keySet().iterator();
            while (iterator.hasNext()) {
                xMLPrintWriter.startTAG("NewLayerToValue");
                k = iterator.next();
                mapShapeValue = this.layersTo.get(k);
                xMLPrintWriter.attr("name", Utils.objectToString(k));
                xMLPrintWriter.attr("value", Utils.objectToString((Object)mapShapeValue));
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        MapAttr mapAttr = (MapAttr)super.clone();
        if (this.shapeValues != null) {
            mapAttr.shapeValues = (HashMap)this.shapeValues.clone();
        }
        if (this.layersTo != null) {
            mapAttr.layersTo = (HashMap)this.layersTo.clone();
        }
        return mapAttr;
    }

    public JSONObject toJSONObject(String string) throws JSONException {
        MapShapeValue mapShapeValue;
        Object object;
        JSONObject jSONObject = new JSONObject();
        Image image = this.getMapImage();
        int n = image.getWidth(new JPanel());
        int n2 = image.getHeight(new JPanel());
        ColorSelect4Shape colorSelect4Shape = this.getCacheColorSelect(string, image);
        Iterator iterator = this.shapeValuesIterator();
        JSONObject jSONObject2 = new JSONObject();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            mapShapeValue = this.getShapeValue((String)object);
            jSONObject2.put((String)object, (Object)mapShapeValue.toJSONObject(colorSelect4Shape, string));
        }
        object = this.layersTo.keySet().iterator();
        mapShapeValue = new JSONObject();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            String string3 = (String)this.layersTo.get(string2);
            mapShapeValue.put(string2, string3);
        }
        jSONObject.put("layersTo", (Object)mapShapeValue);
        jSONObject.put("shapeValues", (Object)jSONObject2);
        jSONObject.put("mapImage", (Object)Base64.encode((Image)image, (String)"png"));
        jSONObject.put("mapWidth", n);
        jSONObject.put("mapHeight", n2);
        return jSONObject;
    }

    private ColorSelect4Shape getCacheColorSelect(String string, Image image) {
        ColorSelect4Shape colorSelect4Shape = new ColorSelect4Shape();
        if (!colorSelect4Shape.hasLoadedImage(image)) {
            colorSelect4Shape.makesureImage(image);
        }
        return colorSelect4Shape;
    }
}

