/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.AttrContents;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DonutPlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.chart.chartglyph.Ring3D;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Donut3DPlotGlyph
extends DonutPlotGlyph {
    private int depth = 20;
    private static final double DEFAULT_DEPTH = 0.16;
    private Projection projection = new Projection();
    private ArrayList<Ring3D> ring4cate = new ArrayList();

    public void layoutDataSeriesGlyph(int n) {
        this.initArcValues();
        this.labelBounds.clear();
        int n2 = this.getCategoryCount();
        for (int i = 0; i < n2; ++i) {
            Ring3D ring3D = new Ring3D();
            this.dealWithDataSeries(i, ring3D, n);
            this.ring4cate.add(ring3D);
        }
    }

    private void dealWithDataSeries(int n, Ring3D ring3D, int n2) {
        int n3 = this.getSeriesSize();
        for (int i = 0; i < n3; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint dataPoint = dataSeries.getDataPoint(n);
            if (dataPoint.isValueIsNull()) continue;
            this.calculateShapeGlyph4DifferentSub(dataPoint, ring3D, n, i);
            this.dealLabelBounds(dataPoint, n2);
        }
        this.dealLabelBoundsInOrder();
    }

    private void calculateShapeGlyph4DifferentSub(DataPoint dataPoint, Ring3D ring3D, int n, int n2) {
        double d = this.getArcInnerRadius(n);
        double d2 = this.getActOuterRadius(n);
        double d3 = this.getSeriesStartAngle(n, n2) % 360.0;
        double d4 = this.getPercent(n2, n) * 360.0 * (1.0 - this.getSeriesGap());
        double d5 = this.radius * 0.16;
        Cylinder cylinder = new Cylinder(0.0, d5, d2);
        Cylinder cylinder2 = new Cylinder(0.0, d5, d);
        cylinder.setAttrbute(this.centerPoint.getX(), this.centerPoint.getY(), d3, d4, this.projection);
        cylinder2.setAttrbute(this.centerPoint.getX(), this.centerPoint.getY(), d3, d4, this.projection);
        this.getConditionCollection().changeStyleConditionWithInfo(cylinder.getColorInfo(), dataPoint, this.createColors4Series());
        this.getConditionCollection().changeStyleConditionWithInfo(cylinder2.getColorInfo(), dataPoint, this.createColors4Series());
        Ring3D ring3D2 = new Ring3D();
        ring3D2.addCylinder(cylinder, cylinder2);
        ring3D.addCylinder(cylinder, cylinder2);
        dataPoint.setDrawImpl(ring3D2);
    }

    protected void dealLabelBounds(DataPoint dataPoint, int n) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        String string = textGlyph.getText();
        if (string != null && string.length() > 0) {
            Point2D point2D = this.getTopArcCenterPoint(dataPoint);
            if (point2D != null) {
                double d = this.getLabelDim(dataPoint, n).getHeight();
                double d2 = this.getLabelDim(dataPoint, n).getWidth();
                double d3 = point2D.getX() - d2 / 2.0;
                double d4 = point2D.getY() - d / 2.0;
                textGlyph.setBounds(new Rectangle2D.Double(d3, d4, d2, d));
            } else {
                textGlyph.setBounds(null);
            }
        }
    }

    private Point2D getTopArcCenterPoint(DataPoint dataPoint) {
        if (dataPoint.getDrawImpl() != null) {
            Ring3D ring3D = (Ring3D)dataPoint.getDrawImpl();
            return ring3D.getTopCenterPoint();
        }
        return null;
    }

    protected Dimension2D getLabelDim(DataPoint dataPoint, int n) {
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        return GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint.getDataLabel().getText(), textAttr, n);
    }

    protected double getSeriesStartAngle(int n, int n2) {
        double d = 135.0;
        double d2 = this.seriesGap * 360.0;
        double d3 = d2 / (double)this.getSeriesSize();
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d4 += this.getPercent(i, n) * (360.0 - d2);
        }
        return d += d4 + d3 * (double)n2 + d3 / 2.0;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public void draw(Graphics graphics, int n) {
        int n2;
        this.drawInfo(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        for (n2 = this.ring4cate.size() - 1; n2 >= 0; --n2) {
            this.drawBackHalf(n2, graphics2D);
        }
        for (n2 = 0; n2 < this.ring4cate.size(); ++n2) {
            this.drawFrontHalf(n2, graphics2D);
        }
        this.drawLabel4Series(graphics, n);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawBackHalf(int n, Graphics2D graphics2D) {
        Ring3D ring3D = this.ring4cate.get(n).calculateBackHalf();
        ring3D.drawSide(graphics2D);
        ring3D.drawBack(graphics2D);
        ring3D.drawPositive(graphics2D);
        ring3D.drawTop(graphics2D);
    }

    private void drawFrontHalf(int n, Graphics2D graphics2D) {
        Ring3D ring3D = this.ring4cate.get(n).calculateFrontHalf();
        ring3D.drawSide(graphics2D);
        ring3D.drawBack(graphics2D);
        ring3D.drawPositive(graphics2D);
        ring3D.drawTop(graphics2D);
    }

    public boolean is3DPlotGlyph() {
        return true;
    }

    public String getPlotGlyphType() {
        return "Donut3DPlotGlyph";
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("innerRadiusPercent", this.innerRadiusPercent);
        jSONObject.put("seriesGap", this.seriesGap);
        jSONObject.put("categoryGap", this.categoryGap);
        jSONObject.put("depth", this.depth);
        jSONObject.put("projection", (Object)this.projection.toJSONObject());
        return jSONObject;
    }

    public String getChartType() {
        return "Donut3D";
    }

    public String getSmallIconType() {
        return "Donut";
    }
}

