/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.ParameterMapNameSpace;
import com.fr.chart.base.AttrContents;
import com.fr.chart.chartdata.StockLabel;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.Repository;
import java.awt.Graphics;

public class DataPoint4Stock
extends DataPoint {
    private static final long serialVersionUID = -6765925723054172826L;
    private static final int CLOSE = 4;
    private double[] values = new double[5];
    private StockLabel stockLabel;
    private FoldLine highLowLine;
    private ShapeGlyph volumeGlyph;

    public void setHighLowLine(FoldLine foldLine) {
        this.highLowLine = foldLine;
    }

    public FoldLine getHighLowLine() {
        return this.highLowLine;
    }

    public void setVolumeGlyph(ShapeGlyph shapeGlyph) {
        this.volumeGlyph = shapeGlyph;
    }

    public ShapeGlyph getVolumeGlyph() {
        return this.volumeGlyph;
    }

    public void initValues(double d, double d2, double d3, double d4, double d5) {
        this.values[0] = d;
        this.values[1] = d2;
        this.values[2] = d3;
        this.values[3] = d4;
        this.values[4] = d5;
    }

    public void initLabels(StockLabel stockLabel) {
        this.stockLabel = stockLabel;
    }

    public double[] getStockValues() {
        return this.values;
    }

    public void draw(Graphics graphics, int n) {
        if (this.highLowLine != null) {
            this.highLowLine.draw(graphics, n);
        }
        if (this.volumeGlyph != null) {
            this.volumeGlyph.draw(graphics, n);
        }
        super.draw(graphics, n);
    }

    public String createHotTooltip(AttrContents attrContents) {
        String string = this.getCategoryName() + AttrContents.RelineSeparation;
        String string2 = "_Blank_";
        string = string + string2 + Inter.getLocText((String)"ChartF_Stock_Open") + " : " + this.getValueParaString(this.values[1], null) + AttrContents.RelineSeparation;
        string = string + string2 + Inter.getLocText((String)"ChartF_Stock_High") + " : " + this.getValueParaString(this.values[2], null) + AttrContents.RelineSeparation;
        string = string + string2 + Inter.getLocText((String)"ChartF_Stock_Low") + " : " + this.getValueParaString(this.values[3], null) + AttrContents.RelineSeparation;
        string = string + string2 + Inter.getLocText((String)"ChartF_Stock_Close") + " : " + this.getValueParaString(this.values[4], null) + AttrContents.RelineSeparation;
        if (this.volumeGlyph != null) {
            string = string + Inter.getLocText((String)"ChartF_Stock_Volume") + " : " + this.getValueParaString(this.values[0], null) + AttrContents.RelineSeparation;
        }
        string = string.replaceAll(string2, this.volumeGlyph != null ? "  " : "");
        return string;
    }

    public NameSpace getParas4Hyperlink() {
        return ParameterMapNameSpace.create((ParameterProvider[])new ParameterProvider[0]);
    }

    public String getType() {
        return "DataPoint4Stock";
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < this.values.length; ++i) {
            if (!Double.isNaN(this.values[i])) {
                jSONArray.put(this.values[i]);
                continue;
            }
            jSONArray.put((Object)"null");
        }
        jSONObject.put("values", (Object)jSONArray);
        JSONArray jSONArray2 = new JSONArray();
        if (this.stockLabel == null) {
            this.stockLabel = new StockLabel();
        }
        jSONArray2.put((Object)this.stockLabel.getVolumeLabel());
        jSONArray2.put((Object)this.stockLabel.getOpenLabel());
        jSONArray2.put((Object)this.stockLabel.getHighLabel());
        jSONArray2.put((Object)this.stockLabel.getLowLabel());
        jSONArray2.put((Object)this.stockLabel.getCloseLabel());
        jSONObject.put("stockLabels", (Object)jSONArray2);
        return jSONObject;
    }
}

