/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.AttrColor;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.Bubble;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Bubble;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class BubblePlotGlyph
extends RectanglePlotGlyph {
    private static final long serialVersionUID = 1884959072935648888L;
    private double maxBubblePixel = 30.0;
    private int seriesEqualsBubbleInWidthOrArea = 8;
    private boolean isShowNegativeBubble = true;
    private double customizedMaxValue = -1.0;

    public void setMaxBubblePixel(double d) {
        this.maxBubblePixel = d;
    }

    public double getMaxBubblePixel() {
        return this.maxBubblePixel;
    }

    public void setShowNegativeBubble(boolean bl) {
        this.isShowNegativeBubble = bl;
    }

    public boolean isShowNegativeBubble() {
        return this.isShowNegativeBubble;
    }

    public void setCustomizedMaxValue(double d) {
        this.customizedMaxValue = d;
    }

    public void setSeriesEqualsBubbleType(int n) {
        this.seriesEqualsBubbleInWidthOrArea = n;
    }

    public int getSeriesEqualsBubbleInWidthOrArea() {
        return this.seriesEqualsBubbleInWidthOrArea;
    }

    public void layoutDataSeriesGlyph(int n) {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                DataPoint4Bubble dataPoint4Bubble = (DataPoint4Bubble)dataSeries.getDataPoint(j);
                if (dataPoint4Bubble.isValueIsNull() || dataPoint4Bubble.getSizeValue() < 0.0 && !this.isShowNegativeBubble) continue;
                this.dealWithEveryDataPoint(dataPoint4Bubble, n);
            }
        }
        this.dealLabelBoundsInOrder();
    }

    private void dealWithEveryDataPoint(DataPoint4Bubble dataPoint4Bubble, int n) {
        double d = dataPoint4Bubble.getSizeValue();
        double d2 = this.getxAxisGlyph().getPoint2D(dataPoint4Bubble.getX()).getX();
        double d3 = this.getStartY(dataPoint4Bubble);
        double d4 = this.getRadius(d, this.getMaxSize());
        Bubble bubble = new Bubble(d2, d3, d4 / 2.0);
        dataPoint4Bubble.setDrawImpl(bubble);
        this.getConditionCollection().changeStyleConditionWithInfo(bubble.getColorInfo(), dataPoint4Bubble, this.createColors4Series());
        if (this.isShowNegativeBubble && d < 0.0) {
            bubble.getColorInfo().setSeriesAttrColor(new AttrColor(Color.GRAY));
        }
        this.dealDataPointLabel(dataPoint4Bubble, n);
    }

    protected double getStartY(DataPoint dataPoint) {
        AxisGlyph axisGlyph = this.getyAxisGlyph();
        if (axisGlyph == null) {
            return 0.0;
        }
        if (axisGlyph.getBounds() == null) {
            return axisGlyph.getPoint2D(dataPoint.getValue()).getY();
        }
        return axisGlyph.getBounds().getY() + axisGlyph.getPoint2D(dataPoint.getValue()).getY();
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n) {
        double d = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - dimension2D.getWidth() / 2.0;
        double d2 = 3.0;
        double d3 = n == 6 ? rectangle2D.getY() - dimension2D.getHeight() - d2 : rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - dimension2D.getHeight() / 2.0;
        return new Rectangle2D.Double(d, d3, dimension2D.getWidth(), dimension2D.getHeight());
    }

    private double getMaxSize() {
        if (this.customizedMaxValue > 0.0) {
            return this.customizedMaxValue;
        }
        double d = 0.0;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            for (int j = 0; dataSeries != null && j < dataSeries.getDataPointCount(); ++j) {
                DataPoint4Bubble dataPoint4Bubble = (DataPoint4Bubble)dataSeries.getDataPoint(j);
                double d2 = dataPoint4Bubble.getSizeValue();
                d = this.isShowNegativeBubble ? Math.max(d, Math.abs(d2)) : Math.max(d, d2);
            }
        }
        return d;
    }

    public double getRadius(double d, double d2) {
        if (d2 <= 0.0) {
            return 0.0;
        }
        double d3 = 0.0;
        d3 = this.seriesEqualsBubbleInWidthOrArea == 8 ? this.maxBubblePixel * Math.abs(d) / d2 : Math.sqrt(this.maxBubblePixel * this.maxBubblePixel * Math.abs(d) / d2);
        return d3;
    }

    public boolean equals(Object object) {
        return object instanceof BubblePlotGlyph && super.equals(object) && ((BubblePlotGlyph)object).maxBubblePixel == this.maxBubblePixel && ((BubblePlotGlyph)object).isShowNegativeBubble == this.isShowNegativeBubble && ((BubblePlotGlyph)object).seriesEqualsBubbleInWidthOrArea == this.seriesEqualsBubbleInWidthOrArea;
    }

    public Object clone() throws CloneNotSupportedException {
        BubblePlotGlyph bubblePlotGlyph = (BubblePlotGlyph)super.clone();
        return bubblePlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("maxBubblePixel", this.maxBubblePixel);
        jSONObject.put("compareRule", this.seriesEqualsBubbleInWidthOrArea);
        jSONObject.put("isShowNegativeBubble", this.isShowNegativeBubble);
        jSONObject.put("customizedMaxValue", this.customizedMaxValue);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "BubblePlotGlyph";
    }

    public String getChartType() {
        return "Bubble";
    }
}

