/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.BarHighLightStyle;
import com.fr.chart.chartglyph.BarHorizontal3DStyle;
import com.fr.chart.chartglyph.BarPlotGlyph;
import com.fr.chart.chartglyph.BarTopDownShadeStyle;
import com.fr.chart.chartglyph.BarTransparentChartStyle;
import com.fr.chart.chartglyph.BarVertical3DStyle;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.StackedBar3DStyle;
import com.fr.chart.chartglyph.StackedBarHighLightStyle;
import com.fr.chart.chartglyph.StackedBarTopDownShadeStyle;
import com.fr.chart.chartglyph.StackedBarTransparentChartStyle;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class Bar2DPlotGlyph
extends BarPlotGlyph {
    private static final long serialVersionUID = -5822126857464796926L;

    protected void resetClip(Graphics2D graphics2D) {
        if (this.getBounds() != null) {
            graphics2D.setClip(this.getBounds());
        }
    }

    public void layoutDataSeriesGlyph(int n) {
        int n2;
        int n3 = this.getSeriesSize();
        for (n2 = 0; n2 < n3; ++n2) {
            this.dealShape4Bar(this.getSeries(n2), this, new BarDataWithAxisGlyph(this.getxAxisGlyph(), this.getSeriesAxisGlyph(n2), this.getSeriesSize(), n2), n);
        }
        this.dealLabelBoundsInOrder();
        if (this.plotStyle == 2) {
            n3 = this.getSeriesSize();
            for (n2 = 0; n2 < n3; ++n2) {
                DataSeries dataSeries = this.getSeries(n2);
                int n4 = dataSeries.getDataPointCount();
                for (int i = 0; i < n4; ++i) {
                    DataPoint dataPoint = dataSeries.getDataPoint(i);
                    if (dataPoint.getDataPointStyle() == null) continue;
                    dataPoint.getDataPointStyle().setTotalRect(this.getTotalRectWhenStacked(dataPoint.getCategoryIndex()));
                }
            }
        }
    }

    public void dealShape4Bar(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, int n) {
        int n2 = 0;
        int n3 = dataSeries.getDataPointCount();
        for (int i = 0; i < n3; ++i) {
            if (dataSeries.getDataPoint(i).isValueIsNull()) continue;
            ++n2;
        }
        this.dealShape4DataSeries(dataSeries, categoryPlotGlyph, barDataWithAxisGlyph, n2, n);
    }

    private boolean _isOutPlotBounds(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        double d = rectangle2D.getX();
        double d2 = d + rectangle2D.getWidth();
        double d3 = rectangle2D.getY();
        double d4 = d3 + rectangle2D.getHeight();
        if (d < 0.0 || d2 > rectangle2D2.getWidth() + 1.0) {
            return true;
        }
        return d3 < 0.0 || d4 > rectangle2D2.getHeight() + 1.0;
    }

    public void setTotalRectForStackedBar(DataSeries[] dataSeriesArray) {
        int n = dataSeriesArray.length;
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = dataSeriesArray[i];
            int n2 = dataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                if (dataPoint.getDataPointStyle() == null) continue;
                dataPoint.getDataPointStyle().setTotalRect(this.getTotalRectWhenStacked(dataPoint.getCategoryIndex(), dataSeriesArray));
            }
        }
    }

    private Rectangle2D getTotalRectWhenStacked(int n, DataSeries[] dataSeriesArray) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = dataSeriesArray.length;
        for (int i = 0; i < n2; ++i) {
            DataPoint dataPoint = dataSeriesArray[i].getDataPoint(n);
            Rectangle2D.Double double_ = (Rectangle2D.Double)dataPoint.getShape();
            if (double_ == null) continue;
            d = Math.min(d, double_.getX());
            d2 = Math.min(d2, double_.getY());
            if (this.isHorizontal) {
                d3 += double_.getWidth();
                d4 = double_.getHeight();
                continue;
            }
            d3 = double_.getWidth();
            d4 += double_.getHeight();
        }
        if (d3 == 0.0 || d4 == 0.0) {
            return null;
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private void dealShape4DataSeries(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, int n, int n2) {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n3 = 0;
        int n4 = dataSeries.getDataPointCount();
        for (int i = 0; i < n4; ++i) {
            DataPoint dataPoint = dataSeries.getDataPoint(i);
            if (dataPoint.isValueIsNull()) continue;
            ShapeGlyph shapeGlyph = new ShapeGlyph();
            dataPoint.setDrawImpl(shapeGlyph);
            Rectangle2D rectangle2D = this.getBarShape(dataSeries, categoryPlotGlyph, i, barDataWithAxisGlyph);
            if (this._isOutPlotBounds(rectangle2D)) {
                shapeGlyph.setShape(null);
                continue;
            }
            shapeGlyph.setShape(rectangle2D);
            if (this.getSeriesSize() == 1) {
                shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
                shapeGlyph.dealConditionWithSeriesColor(this.getConditionCollection(), dataPoint, this.createColors4Cate());
            } else {
                shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint, this.createColors4Series());
            }
            double d = this.getDataPointPercentValue(dataSeries.getSeriesIndex(), i);
            this.calculateFittingData(d, dArray, dArray2, n3, rectangle2D);
            ++n3;
            this.addChartStyle4DataPoint(this.plotStyle, dataPoint, shapeGlyph, rectangle2D);
            this.dealDataPointLabel(dataPoint, n2);
        }
        if (!this.isStacked() && !this.isHorizontal) {
            this.trendLineFitting(dArray, dArray2, dataSeries);
        }
    }

    private void calculateFittingData(double d, double[] dArray, double[] dArray2, int n, Shape shape) {
        boolean bl;
        Rectangle2D rectangle2D = (Rectangle2D)shape;
        boolean bl2 = bl = d > 0.0 != this.getyAxisGlyph().hasAxisReversed();
        if (bl) {
            dArray[n] = rectangle2D.getCenterX();
            dArray2[n] = rectangle2D.getY();
        } else {
            dArray[n] = rectangle2D.getCenterX();
            dArray2[n] = rectangle2D.getY() + rectangle2D.getHeight();
        }
    }

    private void addChartStyle4DataPoint(int n, DataPoint dataPoint, ShapeGlyph shapeGlyph, Rectangle2D rectangle2D) {
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            ChartStyle chartStyle = null;
            boolean bl = this.getyAxisGlyph().hasAxisReversed();
            if (n == 1) {
                chartStyle = this.isStacked() ? new StackedBar3DStyle(color, rectangle2D, this.isHorizontal, true, bl) : (this.isHorizontal ? new BarHorizontal3DStyle(color, rectangle2D, true, bl) : new BarVertical3DStyle(color, rectangle2D, true, bl));
            } else if (n == 2) {
                if (this.isStacked()) {
                    chartStyle = new StackedBarHighLightStyle(color, rectangle2D, this.isHorizontal, true, bl);
                    if (dataPoint.getSeriesIndex() == this.getSeriesSize() - 1) {
                        ((StackedBarHighLightStyle)chartStyle).setIsTop(true);
                    } else if (dataPoint.getSeriesIndex() == 0) {
                        ((StackedBarHighLightStyle)chartStyle).setFirstDraw(true);
                    }
                } else {
                    chartStyle = this.isHorizontal ? new BarHighLightStyle(color, rectangle2D, true, bl, true) : new BarHighLightStyle(color, rectangle2D, true, bl);
                }
            } else if (n == 4) {
                if (this.isStacked()) {
                    chartStyle = new StackedBarTopDownShadeStyle(color, rectangle2D, this.isHorizontal, false, bl);
                    if (dataPoint.getSeriesIndex() == this.getSeriesSize() - 1) {
                        chartStyle.setTotalRect(this.getTotalRectWhenStacked(dataPoint.getCategoryIndex()));
                    }
                } else {
                    chartStyle = new BarTopDownShadeStyle(color, rectangle2D, this.isHorizontal, true, bl);
                }
            } else if (n == 5) {
                if (this.isStacked()) {
                    chartStyle = new StackedBarTransparentChartStyle(color, rectangle2D, this.isHorizontal, true, bl);
                    if (dataPoint.getSeriesIndex() == this.getSeriesSize() - 1) {
                        chartStyle.setTotalRect(this.getTotalRectWhenStacked(dataPoint.getCategoryIndex()));
                    }
                } else {
                    chartStyle = new BarTransparentChartStyle(color, rectangle2D, this.isHorizontal, true, bl);
                }
            }
            if (chartStyle != null && this.isExistAttrByResult(dataPoint, AttrAlpha.class)) {
                chartStyle.setAlpha(shapeGlyph.getAlpha());
            }
            if (chartStyle != null && this.isExistAttrByResult(dataPoint, AttrBorder.class)) {
                chartStyle.setBorderWidth(shapeGlyph.getBorderStyle());
                chartStyle.setBorderColor(shapeGlyph.getBorderColor() == null ? Color.black : shapeGlyph.getBorderColor());
            }
            if (chartStyle != null) {
                dataPoint.setDataPointStyle(chartStyle);
            }
        }
    }

    private Rectangle2D getTotalRectWhenStacked(int n) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataPoint dataPoint = this.getSeries(i).getDataPoint(n);
            Rectangle2D.Double double_ = (Rectangle2D.Double)dataPoint.getShape();
            if (double_ == null) continue;
            d = Math.min(d, double_.getX());
            d2 = Math.min(d2, double_.getY());
            if (this.isHorizontal) {
                d3 += double_.getWidth();
                d4 = double_.getHeight();
                continue;
            }
            d3 = double_.getWidth();
            d4 += double_.getHeight();
        }
        if (d3 == 0.0 || d4 == 0.0) {
            return null;
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public boolean equals(Object object) {
        return object instanceof Bar2DPlotGlyph && super.equals(object);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        return jSONObject;
    }

    public String getPlotDetailType() {
        String string = "";
        string = this.isHorizontal() ? string + "Bar2DPlotGlyph" : string + "Column2DPlotGlyph";
        if (this.isStacked()) {
            string = string + "-Stack";
        }
        if (this.getyAxisGlyph().isPercentage()) {
            string = string + "-Percent";
        }
        return string;
    }

    public String getPlotGlyphType() {
        return "Bar2DPlotGlyph";
    }

    public String getChartType() {
        return "Bar";
    }
}

