/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.present.Present;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.data.util.function.SumFunction;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.Inter;
import com.fr.script.Calculator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class TopChartData
implements ChartData {
    public static final String XML_TAG = "TopChartData";
    protected static final int HUGE_DATA = 1000;
    protected List categoryPresentList = new ArrayList();
    protected List seriesPresentList = new ArrayList();

    public void clearSeries() {
        this.seriesPresentList.clear();
    }

    public void addSeriesPresent(Object object) {
        this.seriesPresentList.add(object);
    }

    public void addCategoryPresent(Object object) {
        this.categoryPresentList.add(object);
    }

    public void clearCate() {
        this.categoryPresentList.clear();
    }

    public Object getCategoryPresentLabel(int n) {
        if (this.categoryPresentList != null && n < this.categoryPresentList.size()) {
            return this.categoryPresentList.get(n);
        }
        return this.getCategoryOriginalLabel(n);
    }

    public abstract void dealPresent(Present var1, Present var2, Calculator var3);

    protected Object[] getSeriesItems() {
        return new Object[0];
    }

    protected Object[][] getXValue2D() {
        return new Object[0][0];
    }

    public Number getX(int n, int n2) {
        return this.getDataValue(n, n2, this.getXValue2D());
    }

    public Object getPresentItem(int n) {
        if (this.seriesPresentList != null && n < this.seriesPresentList.size()) {
            return this.seriesPresentList.get(n);
        }
        return this.getOriginalItem(n);
    }

    public Object getOriginalItem(int n) {
        Object[] objectArray = this.getSeriesItems();
        if (objectArray != null && n < objectArray.length) {
            return objectArray[n];
        }
        return null;
    }

    public int getItemCount() {
        return this.getSeriesItems() == null ? 0 : this.getSeriesItems().length;
    }

    public abstract void dealHugeData();

    public abstract void dealDiscard(int var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6);

    protected void dealDiscardOther2DValue(int n, int n2, boolean bl, boolean bl2, List list) {
        List list2;
        List list3;
        int n3;
        int n4 = list.size();
        int n5 = n4 > 0 ? ((List)list.get(0)).size() : 0;
        n = n != -1 && n < n5 ? n : n5;
        int n6 = n2 = n2 != -1 && n2 < n4 ? n2 : n4;
        if (bl2) {
            for (n3 = n4 - 1; n3 >= n2 && n3 < list.size(); --n3) {
                list.remove(n3);
            }
        } else {
            for (n3 = n4 - 1; n3 > n2 && n3 < list.size(); --n3) {
                list3 = (List)list.remove(n3);
                list2 = (List)list.get(n3 - 1);
                SumFunction sumFunction = new SumFunction();
                for (int i = 0; list2 != null && i < list2.size(); ++i) {
                    sumFunction.reset();
                    if (i < list3.size()) {
                        sumFunction.addData(list3.get(i));
                    }
                    if (i < list2.size()) {
                        sumFunction.addData(list2.remove(i));
                    }
                    if (n2 == n4) continue;
                    list2.add(i, sumFunction.getResult());
                }
            }
        }
        if (bl) {
            for (n3 = 0; n3 < n2 && n3 < list.size(); ++n3) {
                list3 = (List)list.get(n3);
                for (int i = n5 - 1; i >= n && list3 != null && i < list3.size(); --i) {
                    list3.remove(i);
                }
            }
        } else {
            for (n3 = 0; n3 < n2 && n3 < list.size(); ++n3) {
                list3 = (List)list.get(n3);
                list2 = new SumFunction();
                for (int i = n5 - 1; i >= n && list3 != null && i < list3.size(); --i) {
                    list2.addData(list3.remove(i));
                }
                if (n == n5 || list3 == null) continue;
                list3.add(list2.getResult());
            }
        }
    }

    protected void dealDiscardOtherList(int n, boolean bl, List list, boolean bl2) {
        int n2 = list.size();
        int n3 = n = n != -1 ? n : n2;
        if (bl) {
            for (int i = n2 - 1; i >= n; --i) {
                list.remove(i);
            }
        } else if (list.size() > n) {
            if (bl2) {
                for (int i = n2 - 1; i >= n; --i) {
                    list.remove(i);
                }
                if (n != n2) {
                    list.add(Inter.getLocText((String)"ParameterD-The_Other"));
                }
            } else {
                SumFunction sumFunction = new SumFunction();
                for (int i = n2 - 1; i >= n; --i) {
                    sumFunction.addData(list.remove(i));
                }
                if (n != n2) {
                    list.add(sumFunction.getResult());
                }
            }
        }
    }

    protected Number getDataValue(int n, int n2, Object[][] objectArray) {
        if (objectArray == null || objectArray.length <= n || n < 0) {
            return null;
        }
        Object[] objectArray2 = objectArray[n];
        if (objectArray2.length <= n2) {
            return null;
        }
        return this.getObjectNumber(n2, objectArray2);
    }

    protected Number getObjectNumber(int n, Object[] objectArray) {
        if (objectArray == null || n >= objectArray.length) {
            return null;
        }
        return this.dealDataObject2Number(objectArray[n]);
    }

    protected Number dealDataObject2Number(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            Double d = new Double(number.doubleValue());
            if (d.isInfinite()) {
                return null;
            }
            return number;
        }
        if (object == null) {
            return null;
        }
        Number number = Utils.objectToNumber((Object)object, (boolean)true);
        if (number != null) {
            return number;
        }
        Date date = DateUtils.object2Date((Object)object, (boolean)true);
        if (date != null) {
            return new Double(ChartBaseUtils.date2Int(date, 6));
        }
        try {
            return Double.valueOf(Utils.objectToString((Object)object));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        return object instanceof TopChartData && ComparatorUtils.equals((Object)((TopChartData)object).seriesPresentList, (Object)this.seriesPresentList) && ComparatorUtils.equals((Object)((TopChartData)object).categoryPresentList, (Object)this.categoryPresentList);
    }
}

