/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.present.Present;
import com.fr.chart.chartdata.TopChartData;
import com.fr.data.util.function.AverageFunction;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NormalChartData
extends TopChartData
implements ChartData {
    public static final String XML_TAG = "ReportChartData";
    private Object[] category_array = null;
    private Object[] series_array = null;
    private Object[][] series_value_2D = null;
    private Object[] secondCates = null;
    private Object[] thirdCates = null;

    public NormalChartData() {
    }

    public NormalChartData(Object[] objectArray, Object[] objectArray2, Object[][] objectArray3) {
        this.initsData(objectArray, objectArray2, objectArray3);
    }

    public void initsData(Object[] objectArray, Object[] objectArray2, Object[][] objectArray3) {
        this.setCategory_array(objectArray);
        this.setSeries_array(objectArray2);
        this.setSeries_value_2D(objectArray3);
    }

    public Object getCategoryOriginalLabel(int n) {
        if (this.getCategory_array() != null && this.getCategory_array().length > n) {
            return this.getCategory_array()[n];
        }
        return "";
    }

    public int getCategoryLabelCount() {
        return this.getCategory_array() == null ? 0 : this.getCategory_array().length;
    }

    public int getSeriesCount() {
        return this.getSeries_array() == null ? 0 : this.getSeries_array().length;
    }

    public Object getSeriesPresentLabel(int n) {
        if (this.seriesPresentList != null && n < this.seriesPresentList.size() && n >= 0) {
            return this.seriesPresentList.get(n);
        }
        return this.getSeriesOriginalLabel(n);
    }

    public Object getSeriesOriginalLabel(int n) {
        if (this.getSeries_array() != null && this.getSeries_array().length > n && n >= 0) {
            return this.getSeries_array()[n];
        }
        return "";
    }

    public Number getValueAt(int n, int n2) {
        return this.getDataValue(n, n2);
    }

    public void setCategory_array(Object[] objectArray) {
        this.category_array = objectArray;
    }

    public Object[] getCategory_array() {
        return this.category_array;
    }

    public void setSecondCates(Object[] objectArray) {
        this.secondCates = objectArray;
    }

    public Object[] getSecondCates() {
        return this.secondCates;
    }

    public void setThirdCates(Object[] objectArray) {
        this.thirdCates = objectArray;
    }

    public Object[] getThirdCates() {
        return this.thirdCates;
    }

    public void setSeries_array(Object[] objectArray) {
        this.series_array = objectArray;
    }

    public Object[] getSeries_array() {
        return this.series_array;
    }

    public void setSeries_value_2D(Object[][] objectArray) {
        this.series_value_2D = objectArray;
    }

    public Object[][] getSeries_value_2D() {
        return this.series_value_2D;
    }

    public Number getDataValue(int n, int n2) {
        return this.dealDataObject2Number(this.getDataObject(n, n2));
    }

    private Object getDataObject(int n, int n2) {
        Object object = null;
        if (this.getSeries_value_2D() == null || this.getSeries_value_2D().length <= n || n < 0) {
            return null;
        }
        Object[] objectArray = this.getSeries_value_2D()[n];
        if (objectArray.length <= n2) {
            return null;
        }
        object = objectArray[n2];
        return object;
    }

    public void dealDiscard(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        List list;
        int n3;
        if (!bl3 && !bl4 && n == -1 && n2 == -1) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(this.category_array));
        ArrayList<Object> arrayList2 = new ArrayList<Object>(Arrays.asList(this.series_array));
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        boolean[] blArray = new boolean[arrayList.size()];
        Arrays.fill(blArray, true);
        boolean[] blArray2 = new boolean[arrayList2.size()];
        Arrays.fill(blArray2, true);
        for (n3 = 0; n3 < this.series_value_2D.length; ++n3) {
            list = new ArrayList<Object>();
            arrayList3.add(list);
            for (int i = 0; i < this.series_value_2D[n3].length; ++i) {
                list.add(this.series_value_2D[n3][i]);
                boolean bl5 = false;
                if (Utils.objectToNumber((Object)this.series_value_2D[n3][i], (boolean)true) == null) {
                    bl5 = true;
                }
                if (n3 < blArray2.length) {
                    boolean bl6 = blArray2[n3] = blArray2[n3] && bl5;
                }
                if (i >= blArray.length) continue;
                blArray[i] = blArray[i] && bl5;
            }
        }
        this.removeNullCateAndNullSeries(bl3, bl4, blArray, blArray2, arrayList3, arrayList2, arrayList);
        this.dealDiscardOther2DValue(n, n2, bl, bl2, arrayList3);
        this.dealDiscardOtherList(n2, bl2, arrayList2, true);
        this.dealDiscardOtherList(n, bl, arrayList, true);
        for (n3 = 0; n3 < arrayList3.size(); ++n3) {
            list = (List)arrayList3.remove(n3);
            arrayList3.add(n3, list.toArray());
        }
        this.category_array = arrayList.toArray();
        this.series_array = arrayList2.toArray();
        this.series_value_2D = (Object[][])arrayList3.toArray((T[])new Object[arrayList3.size()][]);
    }

    private void removeNullCateAndNullSeries(boolean bl, boolean bl2, boolean[] blArray, boolean[] blArray2, List list, List list2, List list3) {
        int n;
        if (bl2) {
            for (n = blArray2.length - 1; n >= 0; --n) {
                if (!blArray2[n]) continue;
                list2.remove(n);
                list.remove(n);
            }
        }
        if (bl) {
            for (n = blArray.length - 1; n >= 0; --n) {
                if (!blArray[n]) continue;
                list3.remove(n);
                for (int i = 0; i < list.size(); ++i) {
                    List list4 = (List)list.get(i);
                    list4.remove(n);
                }
            }
        }
    }

    public void dealPresent(Present present, Present present2, Calculator calculator) {
        int n;
        if (present != null) {
            this.clearCate();
            for (n = 0; n < this.getCategoryLabelCount(); ++n) {
                this.addCategoryPresent(Utils.objectToString((Object)present.present(this.getCategoryOriginalLabel(n), calculator)));
            }
            if (this.secondCates != null) {
                for (n = 0; n < this.secondCates.length; ++n) {
                    this.secondCates[n] = Utils.objectToString((Object)present.present(this.secondCates[n], calculator));
                }
            }
            if (this.thirdCates != null) {
                for (n = 0; n < this.thirdCates.length; ++n) {
                    this.thirdCates[n] = Utils.objectToString((Object)present.present(this.thirdCates[n], calculator));
                }
            }
        }
        if (present2 != null) {
            this.clearSeries();
            for (n = 0; n < this.getSeriesCount(); ++n) {
                this.addSeriesPresent(Utils.objectToString((Object)present2.present(this.getSeriesOriginalLabel(n), calculator)));
            }
        }
    }

    public void dealHugeData() {
        List<Object> list;
        int n;
        if (this.category_array.length < 1000) {
            return;
        }
        int n2 = (int)Math.ceil((double)this.category_array.length / 1000.0);
        AverageFunction averageFunction = new AverageFunction();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n = 0; n < this.series_array.length; ++n) {
            list = new ArrayList();
            arrayList2.add(list);
            averageFunction.reset();
            boolean bl = false;
            for (int i = 0; i < this.category_array.length; ++i) {
                averageFunction.addData(this.series_value_2D[n][i]);
                if (StableUtils.isNull((Object)this.series_value_2D[n][i]) || StringUtils.isEmpty((String)Utils.objectToString((Object)this.series_value_2D[n][i]))) {
                    bl = true;
                }
                if (i != this.category_array.length - 1 && (i + 1) % n2 != 0) continue;
                if (bl) {
                    list.add(null);
                } else {
                    list.add(averageFunction.getResult());
                    averageFunction.reset();
                }
                bl = false;
            }
        }
        for (n = 0; n < this.category_array.length; ++n) {
            if (n != this.category_array.length - 1 && (n + 1) % n2 != 0) continue;
            arrayList.add(this.category_array[n]);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            list = (List)arrayList2.remove(n);
            arrayList2.add(n, list.toArray());
        }
        this.category_array = arrayList.toArray();
        this.series_value_2D = (Object[][])arrayList2.toArray((T[])new Object[arrayList2.size()][]);
    }
}

