/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.calculate.SuperExecutor;
import com.fr.calculate.cell.BoxCEProvider;
import com.fr.chart.chartdata.BaseMapAreaValue;
import com.fr.chart.chartdata.BaseMapTitleValue;
import com.fr.chart.chartdata.BaseSeriesDefinition;
import com.fr.chart.chartdata.GisMapChartData;
import com.fr.chart.chartdata.ReportDataDefinition;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GisMapReportDefinition
extends ReportDataDefinition {
    public static final String XML_TAG = "GisMapReportDefiniton";
    private static final long serialVersionUID = -5820049286411893167L;
    private List list = new ArrayList();
    private Object addressName;
    private boolean isAddress;
    private boolean isLngFirst;

    public GisMapReportDefinition() {
        this.setAddressType(true);
        this.setLnglatOrder(true);
    }

    public void setAddressType(boolean bl) {
        this.isAddress = bl;
    }

    public boolean isLngFirst() {
        return this.isLngFirst;
    }

    public void setLnglatOrder(boolean bl) {
        this.isLngFirst = bl;
    }

    public void addTitleValue(SeriesDefinition seriesDefinition) {
        this.list.add(seriesDefinition);
    }

    public void clearTitleValue() {
        this.list.clear();
    }

    public void setAddressName(Object object) {
        this.addressName = object;
    }

    public Object getAddressName() {
        return this.addressName;
    }

    public boolean isAddress() {
        return this.isAddress;
    }

    public int getTitleValueSize() {
        return this.list.size();
    }

    public List getTittleValue() {
        return this.list;
    }

    public BaseSeriesDefinition getTitleValueWithIndex(int n) {
        if (n >= 0 && n < this.list.size()) {
            return (SeriesDefinition)this.list.get(n);
        }
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof GisMapReportDefinition && super.equals(object) && ((GisMapReportDefinition)object).isAddress == this.isAddress && ((GisMapReportDefinition)object).isLngFirst == this.isLngFirst && ComparatorUtils.equals((Object)this.addressName, (Object)((GisMapReportDefinition)object).getAddressName()) && ComparatorUtils.equals((Object)this.list, (Object)((GisMapReportDefinition)object).getTittleValue());
    }

    public ChartData createChartData(Calculator calculator) {
        GisMapChartData gisMapChartData = this.getGisMapDataObject();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.dealDefinition4Gis(hashMap, hashMap2, this, calculator);
        gisMapChartData.addGisMapData(hashMap, hashMap2, this.isAddress(), this.isLngFirst());
        return gisMapChartData;
    }

    private GisMapChartData getGisMapDataObject() {
        return new GisMapChartData();
    }

    private void dealDefinition4Gis(HashMap hashMap, HashMap hashMap2, GisMapReportDefinition gisMapReportDefinition, Calculator calculator) {
        Object object;
        int n;
        ArrayList arrayList = this.getAddressWithDefinition(gisMapReportDefinition, calculator);
        int n2 = gisMapReportDefinition.getTitleValueSize();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (n = 0; n < n2; ++n) {
            BaseSeriesDefinition baseSeriesDefinition = gisMapReportDefinition.getTitleValueWithIndex(n);
            arrayList3.add(baseSeriesDefinition.getSeriesName());
            object = new ArrayList();
            FArray fArray = this.calculateChartDataDefinition(baseSeriesDefinition.getValue(), calculator);
            this.dealFArrayInList((ArrayList)object, fArray, calculator);
            arrayList2.add(object);
        }
        n = Math.min(arrayList3.size(), arrayList2.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (BaseMapAreaValue)StableFactory.getMarkedInstanceObjectFromClass((String)"BaseMapAreaValue", BaseMapAreaValue.class);
            hashMap2.put(arrayList.get(i).toString(), object);
            if (n <= 0) continue;
            for (int j = 0; j < n; ++j) {
                Object e = arrayList3.get(j);
                ArrayList arrayList4 = (ArrayList)arrayList2.get(j);
                if (i >= arrayList4.size()) continue;
                Object e2 = arrayList4.get(i);
                if (e == null || !StringUtils.isNotEmpty((String)e.toString())) continue;
                BaseMapTitleValue baseMapTitleValue = (BaseMapTitleValue)StableFactory.getMarkedInstanceObjectFromClass((String)"BaseMapTitleValue", BaseMapTitleValue.class);
                baseMapTitleValue.setTitle(e.toString());
                baseMapTitleValue.setStringValue(Utils.objectToString(e2));
                object.addTitleValue(baseMapTitleValue);
            }
        }
        ArrayList arrayList5 = this.getAddressNameWithDefinition(gisMapReportDefinition, calculator);
        if (arrayList.size() == arrayList5.size()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                hashMap.put(arrayList.get(i).toString(), arrayList5.get(i).toString());
            }
        }
    }

    private ArrayList getAddressWithDefinition(GisMapReportDefinition gisMapReportDefinition, Calculator calculator) {
        ArrayList arrayList = new ArrayList();
        if (gisMapReportDefinition != null) {
            FArray fArray = this.calculateChartDataDefinition(gisMapReportDefinition.getCategoryName(), calculator);
            this.dealFArrayInList(arrayList, fArray, calculator);
        }
        return arrayList;
    }

    private ArrayList getAddressNameWithDefinition(GisMapReportDefinition gisMapReportDefinition, Calculator calculator) {
        ArrayList arrayList = new ArrayList();
        if (gisMapReportDefinition != null) {
            FArray fArray = this.calculateChartDataDefinition(gisMapReportDefinition.getAddressName(), calculator);
            this.dealFArrayInList(arrayList, fArray, calculator);
        }
        return arrayList;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.getAddressName() != null) {
            xMLPrintWriter.startTAG("AddressName");
            GeneralXMLTools.writeObject((XMLPrintWriter)xMLPrintWriter, (Object)this.getAddressName());
            xMLPrintWriter.end();
        }
        super.writeXML(xMLPrintWriter);
        int n = this.list.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                xMLPrintWriter.startTAG("DefinitionList");
                SeriesDefinition seriesDefinition = (SeriesDefinition)this.list.get(i);
                seriesDefinition.writeXML(xMLPrintWriter);
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.startTAG("AddressType").attr("addressType", this.isAddress).attr("latLngOrder", this.isLngFirst).end();
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals((String)"DefinitionList", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        SeriesDefinition seriesDefinition = (SeriesDefinition)xMLableReader.readXMLObject((XMLReadable)new SeriesDefinition());
                        GisMapReportDefinition.this.addTitleValue(seriesDefinition);
                    }
                });
            } else if (ComparatorUtils.equals((String)"AddressName", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && ComparatorUtils.equals((String)"O", (String)xMLableReader.getTagName())) {
                            GisMapReportDefinition.this.addressName = GeneralXMLTools.readObject((XMLableReader)xMLableReader);
                        }
                    }
                });
            } else if (ComparatorUtils.equals((String)"AddressType", (String)string)) {
                this.setAddressType(xMLableReader.getAttrAsBoolean("addressType", true));
                this.setLnglatOrder(xMLableReader.getAttrAsBoolean("latLngOrder", true));
            }
        }
    }

    public ChartData executeData(SuperExecutor superExecutor, BoxCEProvider boxCEProvider, Calculator calculator, CalculatorKey calculatorKey) {
        GisMapChartData gisMapChartData = this.getGisMapDataObject();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.dealDefinition4Gis(hashMap, hashMap2, this, calculator);
        gisMapChartData.addGisMapData(hashMap, hashMap2, this.isAddress(), this.isLngFirst());
        return gisMapChartData;
    }
}

