/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RectanglePlot
extends Plot {
    private static final long serialVersionUID = -8131636357726026781L;
    private boolean interactiveAxisTooltip = false;
    private Axis xAxis;
    private Axis yAxis;
    private Axis secondAxis;
    private Color horizontalIntervalBackgroundColor = null;
    private Color verticalIntervalBackgroundColor = null;

    public void install4PlotGlyph(RectanglePlotGlyph rectanglePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(rectanglePlotGlyph, chartData);
        rectanglePlotGlyph.setInteractiveAxisTooltip(this.interactiveAxisTooltip);
        rectanglePlotGlyph.setHorizontalIntervalBackgroundColor(this.horizontalIntervalBackgroundColor);
        rectanglePlotGlyph.setVerticalIntervalBackgroundColor(this.verticalIntervalBackgroundColor);
    }

    public void installAxisGlyph(RectanglePlotGlyph rectanglePlotGlyph, ChartData chartData) {
    }

    @Override
    public void setInteractiveAxisTooltip(boolean bl) {
        this.interactiveAxisTooltip = bl;
    }

    @Override
    public boolean isInteractiveAxisTooltip() {
        return this.interactiveAxisTooltip;
    }

    @Override
    public void setxAxis(Axis axis) {
        this.xAxis = axis;
        this.xAxis.axisData.isLabelWrapShow = this.isSupportAxisLabelWrapShow();
    }

    @Override
    public Axis getxAxis() {
        return this.xAxis;
    }

    @Override
    public void setyAxis(Axis axis) {
        this.yAxis = axis;
        this.yAxis.axisData.isLabelWrapShow = this.isSupportAxisLabelWrapShow();
    }

    @Override
    public Axis getyAxis() {
        return this.yAxis;
    }

    @Override
    public void setSecondAxis(Axis axis) {
        this.secondAxis = axis;
    }

    @Override
    public Axis getSecondAxis() {
        return this.secondAxis;
    }

    public void setHorizontalIntervalBackgroundColor(Color color) {
        this.horizontalIntervalBackgroundColor = color;
    }

    public Color getHorizontalIntervalBackgroundColor() {
        return this.horizontalIntervalBackgroundColor;
    }

    public void setVerticalIntervalBackgroundColor(Color color) {
        this.verticalIntervalBackgroundColor = color;
    }

    public Color getVerticalIntervalBackgroundColor() {
        return this.verticalIntervalBackgroundColor;
    }

    @Override
    public boolean isSupportIntervalBackground() {
        return true;
    }

    @Override
    public boolean isSupportAxisTip() {
        return !this.isSupport3D();
    }

    @Override
    public boolean isSupportBorder() {
        return true;
    }

    @Override
    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        super.dependence(calculatorProvider, list);
        if (this.xAxis != null) {
            this.xAxis.dependence(calculatorProvider, list);
        }
        if (this.yAxis != null) {
            this.yAxis.dependence(calculatorProvider, list);
        }
        if (this.secondAxis != null) {
            this.secondAxis.dependence(calculatorProvider, list);
        }
    }

    @Override
    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.xAxis != null) {
            this.xAxis.dealFormula(calculator);
        }
        if (this.yAxis != null) {
            this.yAxis.dealFormula(calculator);
        }
        if (this.secondAxis != null) {
            this.secondAxis.dealFormula(calculator);
        }
    }

    @Override
    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.xAxis != null) {
            this.xAxis.buidExecuteSequenceList(list, calculator);
        }
        if (this.yAxis != null) {
            this.yAxis.buidExecuteSequenceList(list, calculator);
        }
        if (this.secondAxis != null) {
            this.secondAxis.buidExecuteSequenceList(list, calculator);
        }
    }

    @Override
    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.xAxis != null) {
            this.xAxis.modFormulaString(mOD_COLUMN_ROW);
        }
        if (this.yAxis != null) {
            this.yAxis.modFormulaString(mOD_COLUMN_ROW);
        }
        if (this.secondAxis != null) {
            this.secondAxis.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (ComparatorUtils.equals((String)string2, (String)"RectanglePlotAttr")) {
                this.interactiveAxisTooltip = xMLableReader.getAttrAsBoolean("interactiveAxisTooltip", false);
                this.verticalIntervalBackgroundColor = xMLableReader.getAttrAsColor("verticalIntervalBackgroundColor", null);
                this.horizontalIntervalBackgroundColor = xMLableReader.getAttrAsColor("horizontalIntervalBackgroundColor", null);
            } else if (ComparatorUtils.equals((String)string2, (String)"Attr")) {
                this.interactiveAxisTooltip = xMLableReader.getAttrAsBoolean("interactiveAxisTooltip", false);
            } else if (ComparatorUtils.equals((String)string2, (String)"xAxis")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        RectanglePlot.this.xAxis = ChartXMLUtils.readAxis(xMLableReader);
                    }
                });
            } else if (ComparatorUtils.equals((String)string2, (String)"yAxis")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        RectanglePlot.this.yAxis = ChartXMLUtils.readAxis(xMLableReader);
                    }
                });
            } else if (ComparatorUtils.equals((String)string2, (String)"secondAxis")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        RectanglePlot.this.secondAxis = ChartXMLUtils.readAxis(xMLableReader);
                    }
                });
            } else if (this.isOldAxisCom(string2)) {
                this.comOldAxis(xMLableReader);
            } else if (ComparatorUtils.equals((String)string2, (String)"DateAxis") && (string = xMLableReader.getAttrAsString("class", null)) != null && (string.endsWith(".CategoryAxis") || string.endsWith(".DateAxis"))) {
                this.xAxis = (CategoryAxis)xMLableReader.readXMLObject((XMLReadable)new CategoryAxis());
            }
            this.xAxis.axisData.isLabelWrapShow = this.isSupportAxisLabelWrapShow();
            this.yAxis.axisData.isLabelWrapShow = this.isSupportAxisLabelWrapShow();
        }
    }

    private boolean isOldAxisCom(String string) {
        return ComparatorUtils.equals((String)string, (String)"CategoryAxis") || ComparatorUtils.equals((String)string, (String)"ValueAxis") || ComparatorUtils.equals((String)string, (String)"Axis");
    }

    private void comOldAxis(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.endsWith(".CategoryAxis")) {
                this.xAxis = (CategoryAxis)xMLableReader.readXMLObject((XMLReadable)new CategoryAxis());
            }
            if (string.endsWith(".ValueAxis")) {
                boolean bl = this.yAxis.isPercentage();
                this.yAxis = (ValueAxis)xMLableReader.readXMLObject((XMLReadable)new ValueAxis());
                if (bl) {
                    this.yAxis.setPercentage(true);
                }
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("RectanglePlotAttr").attr("interactiveAxisTooltip", this.interactiveAxisTooltip);
        if (this.horizontalIntervalBackgroundColor != null) {
            xMLPrintWriter.attr("horizontalIntervalBackgroundColor", this.horizontalIntervalBackgroundColor.getRGB());
        }
        if (this.verticalIntervalBackgroundColor != null) {
            xMLPrintWriter.attr("verticalIntervalBackgroundColor", this.verticalIntervalBackgroundColor.getRGB());
        }
        xMLPrintWriter.end();
        if (this.xAxis != null) {
            xMLPrintWriter.startTAG("xAxis");
            this.xAxis.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.yAxis != null) {
            xMLPrintWriter.startTAG("yAxis");
            this.yAxis.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.secondAxis != null) {
            xMLPrintWriter.startTAG("secondAxis");
            this.secondAxis.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof RectanglePlot && super.equals(object) && ComparatorUtils.equals((Object)((RectanglePlot)object).getxAxis(), (Object)this.xAxis) && ComparatorUtils.equals((Object)((RectanglePlot)object).getSecondAxis(), (Object)this.secondAxis) && ComparatorUtils.equals((Object)((RectanglePlot)object).getVerticalIntervalBackgroundColor(), (Object)this.verticalIntervalBackgroundColor) && ComparatorUtils.equals((Object)((RectanglePlot)object).getHorizontalIntervalBackgroundColor(), (Object)this.horizontalIntervalBackgroundColor) && ComparatorUtils.equals((Object)((RectanglePlot)object).getyAxis(), (Object)this.yAxis) && ((RectanglePlot)object).interactiveAxisTooltip == this.interactiveAxisTooltip;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RectanglePlot rectanglePlot = (RectanglePlot)super.clone();
        if (this.xAxis != null) {
            rectanglePlot.xAxis = (Axis)this.xAxis.clone();
        }
        if (this.yAxis != null) {
            rectanglePlot.yAxis = (Axis)this.yAxis.clone();
        }
        if (this.secondAxis != null) {
            rectanglePlot.secondAxis = (Axis)this.secondAxis.clone();
        }
        return rectanglePlot;
    }
}

