/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Formula;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.base.chart.BaseChart;
import com.fr.base.chart.BaseChartCollection;
import com.fr.base.chart.BaseChartGlyph;
import com.fr.base.chart.BaseChartPainter;
import com.fr.base.chart.BasePlot;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.TopDefinitionProvider;
import com.fr.chart.base.AttrChangeConfig;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.ChartPainter;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.SwitchState;
import com.fr.chart.chartdata.ReportDataDefinition;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.chart.chartdata.TopDefinition;
import com.fr.chart.chartglyph.AbstractChartPainter;
import com.fr.chart.charttypes.ChartTypeManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.NameObject;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.parser.BlockIntervalLiteral;
import com.fr.plugin.ExtraClassManager;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.StableUtils;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ChartCollection
extends AbstractChartPainter
implements BaseChartCollection {
    private static final long serialVersionUID = 1265398996017104404L;
    private transient String ID = "";
    private transient int sheetIndex;
    private transient String ecName;
    private transient SwitchState state = SwitchState.DEFAULT;
    private AttrChangeConfig changeConfigAttr = new AttrChangeConfig();
    private double fontScale = 1.0;

    public ChartCollection() {
    }

    public void setFontScale(double d) {
        this.fontScale = d;
    }

    public double getFontScale() {
        return this.fontScale;
    }

    public String getRepresentChartID() {
        return this.getSelectedChart().getPriority();
    }

    public SwitchState getState() {
        return this.state;
    }

    public void setState(SwitchState switchState) {
        this.state = switchState;
    }

    public AttrChangeConfig getChangeConfigAttr() {
        return this.changeConfigAttr;
    }

    public void setChangeConfigAttr(AttrChangeConfig attrChangeConfig) {
        this.changeConfigAttr = attrChangeConfig;
    }

    public void calculateMultiChartMode() {
        this.changeConfigAttr.setEnable(this.changeEnable());
        if (this.nameObjectList.size() > 1) {
            this.setState(SwitchState.CHANGE);
        } else {
            this.setState(SwitchState.DEFAULT);
        }
    }

    public ChartCollection(Chart chart) {
        this.addChart(chart);
    }

    public Chart getChangeStateNewChart() {
        Chart chart = this.getSelectedChart();
        String string = chart.getPriority();
        ChartTypeManager.getInstance();
        return ChartTypeManager.getFirstChart(string);
    }

    public void addChart(BaseChart baseChart) {
        if (baseChart instanceof Chart) {
            this.addNamedChart(Inter.getLocText((String)"Chart-Default_Name"), (Chart)baseChart);
            this.addFunctionRecord(baseChart);
        }
    }

    public void addFunctionRecord(BaseChart baseChart) {
        FunctionProcessor functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor();
        if (functionProcessor != null) {
            functionProcessor.recordFunction(((Chart)baseChart).getPlot().getFunctionToRecord());
        }
    }

    public String getPlotType() {
        return this.getSelectedChart() == null ? "" : this.getSelectedChart().getPlotType();
    }

    public void addNamedChart(String string, Chart chart) {
        this.nameObjectList.add(new NameObject(string, (Object)chart));
    }

    public void addNamedChartAtIndex(String string, Chart chart, int n) {
        this.nameObjectList.add(n, new NameObject(string, (Object)chart));
    }

    public int getChartCount() {
        return this.nameObjectList.size();
    }

    public void setECName(String string) {
        this.ecName = string;
    }

    public String getChartName(int n) {
        return ((NameObject)this.nameObjectList.get(n)).getName();
    }

    public void setChartName(int n, String string) {
        ((NameObject)this.nameObjectList.get(n)).setName(string);
    }

    public Chart getChart(int n) {
        return (Chart)((NameObject)this.nameObjectList.get(n)).getObject();
    }

    public BaseChart getChartWithIndex(int n) {
        return (BaseChart)((NameObject)this.nameObjectList.get(n)).getObject();
    }

    public void setID(String string) {
        this.ID = string.replaceAll("-", "_");
    }

    public String getID() {
        return this.ID;
    }

    public void setSheetIndex(int n) {
        this.sheetIndex = n;
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getChartCount();
        for (int i = 0; i < n; ++i) {
            Chart chart = this.getChart(i);
            if (chart == null) continue;
            chart.dependence(calculatorProvider, arrayList);
        }
        HashSet hashSet = new HashSet(arrayList);
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public Chart getSelectedChart() {
        int n = Math.max(0, this.getSelectedIndex());
        if (n >= 0 && this.getChartCount() > 0) {
            return n < this.getChartCount() ? this.getChart(n) : this.getChart(0);
        }
        return null;
    }

    public void switchPlot(BasePlot basePlot) {
        if (basePlot instanceof Plot) {
            this.getSelectedChart().switchPlot((Plot)basePlot);
        }
    }

    public BaseChartPainter createChartPainterNoData(Calculator calculator, int n, int n2) {
        ChartPainter chartPainter = new ChartPainter();
        chartPainter.setChangeConfig(this.getChangeConfigAttr());
        chartPainter.setFontScale(this.getFontScale());
        chartPainter.setSelectedIndex(this.getSelectedIndex());
        chartPainter.setWidth(n);
        chartPainter.setHeight(n2);
        chartPainter.setID(this.getID());
        chartPainter.setWidgetDependenced(this.dependence((CalculatorProvider)calculator));
        chartPainter.setSheetIndex(this.sheetIndex);
        chartPainter.setECName(this.ecName);
        return chartPainter;
    }

    public void dealFormula(Calculator calculator) {
        for (int i = 0; i < this.getChartCount(); ++i) {
            this.getChart(i).dealFormula(calculator);
            this.doFormulaChartName(i, calculator);
        }
    }

    private void doFormulaChartName(int n, Calculator calculator) {
        String string = ((NameObject)this.nameObjectList.get(n)).getName();
        if (StableUtils.maybeFormula((String)string)) {
            Formula formula = new Formula(string);
            Utils.dealFormulaValue((Object)formula, (Calculator)calculator);
            string = formula.getResult().toString();
            ((NameObject)this.nameObjectList.get(n)).setName(string);
        }
    }

    public List buidExecuteSequenceList(Calculator calculator) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.getChartCount(); ++i) {
            this.getChart(i).buidExecuteSequenceList(arrayList, calculator);
        }
        return arrayList;
    }

    public BaseChartPainter createChartPainterJustTableDataAndDealFormual(Calculator calculator, int n, int n2) {
        this.dealFormula(calculator);
        return this.createChartPainterJustTableData(calculator, n, n2);
    }

    public List getCalculatorBlockAttr(Calculator calculator) {
        return (List)calculator.getAttribute(BlockIntervalLiteral.KEY);
    }

    private BaseChartPainter createChartPainterJustTableData(Calculator calculator, int n, int n2) {
        if (this == null || this.getChartCount() == 0) {
            return null;
        }
        ColumnRow columnRow = calculator.getCurrentFromColumnRow();
        calculator.setCurrentFromColumnRow(null);
        BaseChartPainter baseChartPainter = this.createChartPainterNoData(calculator, n, n2);
        int n3 = this.getChartCount();
        for (int i = 0; i < n3; ++i) {
            TopDefinition topDefinition;
            Chart chart = this.getChart(i);
            TopDefinitionProvider topDefinitionProvider = chart.getFilterDefinition();
            ChartData chartData = null;
            if (topDefinitionProvider instanceof TableDataDefinition) {
                topDefinition = (TableDataDefinition)topDefinitionProvider;
                chartData = ((TableDataDefinition)topDefinition).calcu4ChartData(calculator, chart.getDataProcessor());
            } else if (topDefinitionProvider instanceof ReportDataDefinition) {
                topDefinition = (ReportDataDefinition)topDefinitionProvider;
                chartData = ((ReportDataDefinition)topDefinition).calculateChartDataWithFormCalculator(calculator);
            }
            if (chartData == null) {
                chartData = chart.createNullChartData();
            }
            topDefinition = chart.createGlyph(chartData);
            topDefinition.setUseChangeChart(this.getChartCount() > 1);
            topDefinition.setUseDragRefresh(this.isNeedRefreshButton());
            baseChartPainter.addNamedGlyph(this.getChartName(i), (Object)topDefinition);
        }
        if (columnRow != null) {
            calculator.setCurrentFromColumnRow(columnRow);
        }
        return baseChartPainter;
    }

    public boolean isNeedRefreshButton() {
        int n = this.getChartCount();
        boolean bl = false;
        for (int i = 0; i < n && !bl; ++i) {
            if (this.getChart(i).getPlot() == null) {
                return false;
            }
            bl = this.getChart(i).getPlot().isSeriesDragEnable() || bl;
        }
        return bl || n > 1;
    }

    public boolean changeEnable() {
        return this.getChartCount() > 1 && this.getSelectedChart().supportChange();
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.nameObjectList != null && this.getChartCount() > 0) {
            for (int i = 0; i < this.getChartCount(); ++i) {
                Chart chart = this.getChart(i);
                if (chart == null) continue;
                chart.modFormulaString(mOD_COLUMN_ROW);
            }
        }
    }

    public void paint(Graphics graphics, int n, int n2, int n3, Style style) {
        if (this.getSelectedChart() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Chart chart = this.getSelectedChart();
        ChartData chartData = chart.defaultChartData();
        BaseChartGlyph baseChartGlyph = chart.createGlyph(chartData);
        Image image = baseChartGlyph.toImage(n, n2, n3);
        graphics.drawImage(image, 0, 0, null);
        image = null;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.removeAllNameObject();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            this.changeConfigAttr.readXML(xMLableReader);
            if ("Chart".equals(string)) {
                Chart chart;
                try {
                    chart = (Chart)Class.forName(xMLableReader.getAttrAsString("chartClass", Chart.class.getName())).newInstance();
                }
                catch (Exception exception) {
                    chart = new Chart();
                    FRLogger.getLogger().error(exception.getMessage());
                }
                this.addNamedChart(xMLableReader.getAttrAsString("name", ""), chart);
                xMLableReader.readXMLObject((XMLReadable)chart);
            } else if (string.endsWith("Definition")) {
                TopDefinition topDefinition = ChartXMLUtils.deal65XMLDefinition(this.getChart(0), ChartXMLCompatibleUtils.readDefinition(xMLableReader));
                int n = this.getChartCount();
                for (int i = 0; i < n; ++i) {
                    Chart chart = this.getChart(i);
                    if (chart == null) continue;
                    if (topDefinition != null) {
                        try {
                            chart.setFilterDefinition((TopDefinition)topDefinition.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            chart.setFilterDefinition(topDefinition);
                        }
                    } else {
                        chart.setFilterDefinition(null);
                    }
                    Chart.comChange4PiePlot(chart, xMLableReader);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        this.changeConfigAttr.writeXML(xMLPrintWriter);
        int n = this.getChartCount();
        for (int i = 0; i < n; ++i) {
            Chart chart = this.getChart(i);
            xMLPrintWriter.startTAG(chart.getXmlTag()).attr("name", this.getChartName(i)).attr("chartClass", chart.getClass().getName());
            chart.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ChartCollection chartCollection = (ChartCollection)((Object)super.clone());
        chartCollection.setChangeConfigAttr((AttrChangeConfig)this.changeConfigAttr.clone());
        chartCollection.setState(this.getState());
        chartCollection.setFontScale(this.getFontScale());
        return chartCollection;
    }

    public void removeAllNameObject() {
        this.changeConfigAttr = new AttrChangeConfig();
        this.nameObjectList.clear();
    }

    public boolean equals(Object object) {
        return object instanceof ChartCollection && ComparatorUtils.equals((Object)this.getChangeConfigAttr(), (Object)((ChartCollection)((Object)object)).getChangeConfigAttr()) && ComparatorUtils.equals((Object)this.getFontScale(), (Object)((ChartCollection)((Object)object)).getFontScale()) && super.equals(object);
    }
}

