/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseXMLUtils;
import com.fr.chart.base.ChartDefaultConfig;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.HashMap;

public class TextAttr
implements XMLable {
    private static final long serialVersionUID = -4216006140409740068L;
    public static final String XML_TAG = "TextAttr";
    private FRFont frFont = null;
    private int rotation = 0;
    private int alignText = 0;

    public TextAttr() {
    }

    public TextAttr(FRFont fRFont) {
        this.frFont = fRFont;
    }

    public FRFont getFRFont() {
        return this.frFont;
    }

    public void setFRFont(FRFont fRFont) {
        this.frFont = fRFont;
    }

    public void setFRFontColor(Color color) {
        if (this.frFont == null) {
            return;
        }
        this.frFont.setForeground(color);
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n) {
        this.rotation = n;
    }

    public void setAlignText(int n) {
        this.alignText = n;
    }

    public int getAlignText() {
        return this.alignText;
    }

    public boolean equals(Object object) {
        return object instanceof TextAttr && ((TextAttr)object).getAlignText() == this.getAlignText() && ((TextAttr)object).getRotation() == this.getRotation() && ComparatorUtils.equals((Object)((TextAttr)object).getFRFont(), (Object)this.getFRFont());
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            if ("FRFont".equals(xMLableReader.getTagName())) {
                this.frFont = BaseXMLUtils.readFRFont((XMLableReader)xMLableReader);
            } else if (xMLableReader.getTagName().equals("Attr")) {
                this.setRotation(xMLableReader.getAttrAsInt("rotation", 0));
                this.setAlignText(xMLableReader.getAttrAsInt("alignText", 0));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr");
        if (this.getRotation() != 0) {
            xMLPrintWriter.attr("rotation", this.getRotation());
        }
        xMLPrintWriter.attr("alignText", this.getAlignText());
        if (this.getFRFont() != null) {
            BaseXMLUtils.writeFRFont((XMLPrintWriter)xMLPrintWriter, (FRFont)this.getFRFont());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        TextAttr textAttr = (TextAttr)super.clone();
        if (this.frFont != null) {
            textAttr.frFont = (FRFont)this.frFont.clone();
        }
        return textAttr;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.frFont != null) {
            jSONObject.put("font", (Object)this.frFont.toJSONObject());
        }
        jSONObject.put("alignText", this.alignText);
        jSONObject.put("rotation", this.rotation);
        return jSONObject;
    }

    public JSONObject changedAttrToJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        HashMap<String, Object> hashMap = ChartDefaultConfig.TEXT_ATTR_DEFAULT;
        if (!ComparatorUtils.equals((Object)hashMap.get("alignText"), (Object)this.alignText)) {
            jSONObject.put("alignText", this.alignText);
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("rotation"), (Object)this.rotation)) {
            jSONObject.put("rotation", this.rotation);
        }
        if (this.frFont != null && !ComparatorUtils.equals((Object)hashMap.get("font"), (Object)this.frFont)) {
            jSONObject.put("font", (Object)this.frFont.changedAttrToJSONObject());
        }
        return jSONObject;
    }
}

