/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.memoryUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class JavaToIfxType {
    public static final int IFX_INT_SIZE = 4;
    public static final int BYTESHIFT = 8;
    public static final int BYTEMASK = 255;
    public static final int IFX_LGINT_SIZE = 10;
    public static final int IFX_SMINT_SIZE = 2;
    public static final int IFX_SMFLOAT_SIZE = 4;
    public static final int IFX_LONG_SIZE = 8;
    public static final int IFX_DOUBLE_SIZE = 8;
    public static final int DefDblScale = 10;
    public static final int DefFltScale = 10;
    private static Calendar Cal = Calendar.getInstance();
    protected static final boolean TruncateFractSec = true;
    static final int NanosPerSecond = 1000000000;
    static final int MilliPerSecond = 1000;
    static final int SecondsPerMinute = 60;
    static final int SecondsPerHour = 3600;
    static final int SecondsPerDay = 86400;
    static final int MonthsPerYear = 12;
    public static byte[] DATETIME_PREC = new byte[2];
    public static short DP_SHORT;

    public static byte[] JavaToIfxInt(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public static byte[] JavaToIfxChar(String string) {
        int n = string.length();
        byte[] byArray = new byte[n + 2];
        byte[] byArray2 = string.getBytes();
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        System.arraycopy(byArray2, 0, byArray, 2, n);
        return byArray;
    }

    public static byte[] JavaToIfxChar(String string, String string2) throws IOException {
        byte[] byArray = null;
        byArray = string2 != null ? string.getBytes(string2) : string.getBytes();
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 2];
        byArray2[0] = (byte)(n >> 8 & 0xFF);
        byArray2[1] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 2, n);
        return byArray2;
    }

    public static byte[] JavaToIfxVarChar(String string, String string2, int n) throws IOException {
        byte[] byArray = null;
        byArray = string2 != null ? string.getBytes(string2) : string.getBytes();
        byte[] byArray2 = new byte[n + 1];
        memoryUtil.byfill(byArray2, (byte)0);
        int n2 = byArray.length;
        int n3 = Math.min(n2, n);
        byArray2[0] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 1, n3);
        return byArray2;
    }

    public static byte[] JavaToIfxDate(Date date) {
        int n = IfxToJavaType.convertDateToDays(date);
        return JavaToIfxType.JavaToIfxInt(n);
    }

    public static String convertNanosToFract(int n) {
        char[] cArray = new char[5];
        double d = (double)n / 10000.0 + 0.0;
        String string = Integer.toString((int)d);
        Decimal.charfill(cArray, 0, 4, '0');
        int n2 = string.length() - 6;
        int n3 = 4;
        int n4 = string.length() - 1;
        while (n4 >= 0 && n4 >= n2) {
            cArray[n3] = string.charAt(n4);
            --n4;
            --n3;
        }
        return new String(cArray);
    }

    public static synchronized String convertTimestampToString(Timestamp timestamp) {
        Cal.setTime(timestamp);
        int n = Cal.get(1);
        int n2 = Cal.get(2) + 1;
        int n3 = Cal.get(5);
        int n4 = Cal.get(11);
        int n5 = Cal.get(12);
        int n6 = Cal.get(13);
        int n7 = timestamp.getNanos();
        String string = String.valueOf(n);
        string = n2 < 10 ? String.valueOf(string) + "0" + n2 : String.valueOf(string) + n2;
        string = n3 < 10 ? String.valueOf(string) + "0" + n3 : String.valueOf(string) + n3;
        string = n4 < 10 ? String.valueOf(string) + "0" + n4 : String.valueOf(string) + n4;
        string = n5 < 10 ? String.valueOf(string) + "0" + n5 : String.valueOf(string) + n5;
        string = n6 < 10 ? String.valueOf(string) + "0" + n6 : String.valueOf(string) + n6;
        string = String.valueOf(string) + "." + JavaToIfxType.convertNanosToFract(n7);
        return string;
    }

    public static synchronized String convertTimeToString(Time time) {
        Cal.setTime(time);
        int n = Cal.get(11);
        int n2 = Cal.get(12);
        int n3 = Cal.get(13);
        String string = "";
        string = n < 10 ? String.valueOf(string) + "0" + n : String.valueOf(string) + n;
        string = n2 < 10 ? String.valueOf(string) + "0" + n2 : String.valueOf(string) + n2;
        string = n3 < 10 ? String.valueOf(string) + "0" + n3 : String.valueOf(string) + n3;
        return string;
    }

    public static String convertIntervalToString(IntervalDF intervalDF) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        long l = intervalDF.getSeconds();
        long l2 = intervalDF.getNanoSeconds();
        if (l < 0L || l == 0L && l2 < 0L) {
            bl = true;
            l = -l;
            l2 = -l2;
        }
        if (l > 0L) {
            int n = (int)Math.floor(l / 86400L);
            l %= 86400L;
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
            int n2 = (int)Math.floor(l / 3600L);
            l %= 3600L;
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            int n3 = (int)Math.floor(l / 60L);
            l %= 60L;
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n3);
            if (l < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l);
        }
        stringBuffer.append('.');
        String string = JavaToIfxType.convertNanosToFract((int)l2);
        stringBuffer.append(string);
        if (bl) {
            String string2 = stringBuffer.toString();
            string2 = "-" + string2;
            return string2;
        }
        return stringBuffer.toString();
    }

    public static String convertIntervalToString(IntervalYM intervalYM) {
        boolean bl = false;
        long l = intervalYM.getMonths();
        if (l < 0L) {
            l = -l;
            bl = true;
        }
        String string = String.valueOf(l / 12L);
        int n = string.length();
        string.trim();
        String string2 = String.valueOf(l % 12L);
        n = string2.length();
        if (n < 2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < 2 - n) {
                stringBuffer.append("0");
                ++n2;
            }
            stringBuffer.append(string2);
            string2 = stringBuffer.toString();
        }
        String string3 = bl ? "-" + string + string2 : String.valueOf(string) + string2;
        return string3;
    }

    public static byte[] JavaToIfxDateTime(Timestamp timestamp) {
        String string = JavaToIfxType.convertTimestampToString(timestamp);
        byte[] byArray = new Decimal(string).javaToIfx();
        return byArray;
    }

    public static byte[] JavaToIfxDateTime(Time time) {
        String string = JavaToIfxType.convertTimeToString(time);
        byte[] byArray = new Decimal(string).javaToIfx();
        return byArray;
    }

    public static byte[] JavaToIfxInterval(IntervalDF intervalDF) {
        byte[] byArray = new byte[2];
        long l = intervalDF.getSeconds();
        if (l < 0L) {
            l = -l;
        }
        String string = JavaToIfxType.convertIntervalToString(intervalDF);
        if (l <= 0L) {
            byArray = Decimal.encodeIntervalPrecision(byArray, (byte)2, (byte)12, (byte)15);
        } else {
            byte by = string.charAt(0) == '-' ? (byte)(string.length() - 13) : (byte)(string.length() - 12);
            byArray = Decimal.encodeIntervalPrecision(byArray, by, (byte)4, (byte)15);
        }
        short s = (short)(byArray[0] * 256 + byArray[1]);
        Decimal decimal = new Decimal(string, s);
        byte[] byArray2 = decimal.javaToIfx();
        return byArray2;
    }

    public static byte[] JavaToIfxInterval(IntervalYM intervalYM) {
        byte[] byArray = new byte[2];
        String string = JavaToIfxType.convertIntervalToString(intervalYM);
        long l = intervalYM.getMonths();
        if (l < 0L) {
            l = -l;
        }
        String string2 = new Long(l /= 12L).toString();
        string2.trim();
        byArray = Decimal.encodeIntervalPrecision(byArray, (byte)string2.length(), (byte)0, (byte)2);
        short s = (short)(byArray[0] * 256 + byArray[1]);
        byte[] byArray2 = new Decimal(string, s).javaToIfx();
        return byArray2;
    }

    public static final byte[] JavaToIfxDecimalNull(short s) {
        byte by = (byte)(s >> 8 & 0xFF);
        byte by2 = (byte)(s & 0xF);
        byte by3 = (byte)((by + (by2 & 1) + 1) / 2);
        byte[] byArray = new byte[by3 + 1];
        memoryUtil.byfill(byArray, (byte)0);
        return byArray;
    }

    public static final byte[] JavaToIfxDecimal(BigDecimal bigDecimal) {
        Decimal decimal = new Decimal(bigDecimal);
        return decimal.javaToIfx();
    }

    public static final byte[] JavaToIfxDouble(Double d) {
        return JavaToIfxType.JavaToIfxDouble((double)d);
    }

    public static final byte[] JavaToIfxDouble(double d) {
        byte[] byArray = new byte[8];
        long l = Double.doubleToLongBits(d);
        byArray[0] = (byte)(l >> 56 & 0xFFL);
        byArray[1] = (byte)(l >> 48 & 0xFFL);
        byArray[2] = (byte)(l >> 40 & 0xFFL);
        byArray[3] = (byte)(l >> 32 & 0xFFL);
        byArray[4] = (byte)(l >> 24 & 0xFFL);
        byArray[5] = (byte)(l >> 16 & 0xFFL);
        byArray[6] = (byte)(l >> 8 & 0xFFL);
        byArray[7] = (byte)(l & 0xFFL);
        return byArray;
    }

    public static final byte[] JavaToIfxReal(Float f) {
        return JavaToIfxType.JavaToIfxReal(f.floatValue());
    }

    public static byte[] JavaToIfxReal(float f) {
        int n = Float.floatToIntBits(f);
        return JavaToIfxType.JavaToIfxInt(n);
    }

    public static byte[] JavaToIfxSmallInt(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8), (byte)s};
        return byArray;
    }

    public static byte[] JavaToIfxLongInt(long l) {
        byte[] byArray = new byte[10];
        short s = 1;
        if (l < 0L) {
            s = -1;
            l = -l;
        }
        byte[] byArray2 = JavaToIfxType.JavaToIfxSmallInt(s);
        System.arraycopy(byArray2, 0, byArray, 0, 2);
        long l2 = l & 0xFFFFFFFFL;
        byte[] byArray3 = JavaToIfxType.JavaToIfxInt((int)l2);
        System.arraycopy(byArray3, 0, byArray, 2, 4);
        int n = (int)(l >> 32);
        byte[] byArray4 = JavaToIfxType.JavaToIfxInt(n);
        System.arraycopy(byArray4, 0, byArray, 6, 4);
        return byArray;
    }

    static {
        Decimal.encodeDateTimePrecision(DATETIME_PREC, (byte)0, (byte)15);
        DP_SHORT = (short)(DATETIME_PREC[0] * 256 + DATETIME_PREC[1]);
    }
}

