/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRowColumn;
import com.informix.jdbc.IfxStatement;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;

public class IfxScrollableResultSet
extends IfxResultSet {
    Vector insertRowVector;
    boolean insertMode = false;
    IfxRowColumn rowColumn;

    IfxScrollableResultSet() throws SQLException {
    }

    IfxScrollableResultSet(IfxStatement ifxStatement) throws SQLException {
        super(ifxStatement);
    }

    public void moveToInsertRow() throws SQLException {
        this.insertMode = true;
    }

    public int getRow() throws SQLException {
        return this.curRowID;
    }

    IfxObject getValue(int n) throws SQLException {
        try {
            if (this.insertRowVector == null) {
                this.insertRowVector = new Vector();
                if (this.rsmd == null) {
                    this.rsmd = (IfxResultSetMetaData)this.getMetaData();
                }
                this.insertRowVector.setSize(this.rsmd.getColumnCount());
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (n < 1 || n > this.insertRowVector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        IfxObject ifxObject = (IfxObject)this.insertRowVector.elementAt(n - 1);
        if (ifxObject == null) {
            if (this.rowColumn == null) {
                this.rowColumn = new IfxRowColumn(this.conn, this.rsmd);
            }
            ifxObject = this.rowColumn.getColumn(n);
            this.insertRowVector.setElementAt(ifxObject, n - 1);
        }
        this.lastColWasNull = ifxObject.isNull();
        return ifxObject;
    }

    public int findColumn(String string) throws SQLException {
        Integer n;
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                this.getMetaData();
            }
            if (this.rsmd == null) {
                throw IfxErrMsg.getSQLException(-79737, this.conn);
            }
            int n2 = this.rsmd.getColumnCount();
            this.nameToIdxTable = new Hashtable(n2);
            int n3 = 1;
            while (n3 <= n2) {
                if (!this.conn.isDelimIdentSet()) {
                    this.nameToIdxTable.put(this.rsmd.getColumnName(n3).toLowerCase(), new Integer(n3));
                } else {
                    this.nameToIdxTable.put(this.rsmd.getColumnName(n3), new Integer(n3));
                }
                ++n3;
            }
        }
        if ((n = !this.conn.isDelimIdentSet() ? (Integer)this.nameToIdxTable.get(string.toLowerCase()) : (Integer)this.nameToIdxTable.get(string)) == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        return n;
    }

    public void updateNull(int n) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.nullify();
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromBoolean(bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromByte(by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(int n, short s) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromShort(s);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromInt(n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromLong(l);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(int n, float f) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromFloat(f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(int n, double d) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromDouble(d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromDecimal(bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromString(string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromBytes(byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromDate(date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromTime(time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromTimestamp(timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromAsciiStream(inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromBinaryStream(inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateObject(int n, Object object) throws SQLException {
        IfxObject ifxObject = this.insertMode ? this.getValue(n) : super.getValue(n);
        ifxObject.fromObject(object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    protected void finalize() {
        if (this.insertRowVector != null) {
            this.insertRowVector.removeAllElements();
            this.insertRowVector = null;
        }
    }
}

