package com.jshx.yzssfgl.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzssfgl.dao.YzsdicglDao;
import com.jshx.yzssfgl.entity.Yzsdicgl;
import com.jshx.yzssfgl.service.YzsdicglService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("yzsdicglService")
public class YzsdicglServiceImpl extends BaseServiceImpl implements YzsdicglService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("yzsdicglDao")
	private YzsdicglDao yzsdicglDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return yzsdicglDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzsdicgl getById(String id)
	{
		return yzsdicglDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param yzsdicgl 信息
	 */
	@Transactional
	public void save(Yzsdicgl yzsdicgl)
	{
		yzsdicglDao.save(yzsdicgl);
	}

	/**
	 * 修改信息
	 * @param yzsdicgl 信息
	 */
	@Transactional
	public void update(Yzsdicgl yzsdicgl)
	{
		yzsdicglDao.update(yzsdicgl);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects= yzsdicglDao.findYzsdicgl(paraMap);
		yzsdicglDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					yzsdicglDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Yzsdicgl> findYzsdicgl(Map<String, Object> paraMap) {

		return yzsdicglDao.findYzsdicgl(paraMap);

	}

    /**
     * 获取一站式事项类型
     */
    @Override
    public List<String> getYzssxlx(Map<String,Object> paramMap){
        return yzsdicglDao.getYzssxlx(paramMap);
    }

    /**
     * 获取一站式事项名称
     */
    @Override
    public List<String> getYzssxmc(Map<String,Object> paramMap){
        return yzsdicglDao.getYzssxmc(paramMap);
    }

	/**
	 * 根据一站式码获取一站式事项名称
	 */
	@Override
	public Yzsdicgl getBySflxm(String sflxm){
		Map<String,Object> paramMap = new HashMap<>();
		paramMap.put("sflxm",sflxm);
		Yzsdicgl yzsdicgl =  (Yzsdicgl)yzsdicglDao.findObjectByFieldsMap(Yzsdicgl.class,paramMap);
		return yzsdicgl;
	}
}
