package com.jshx.yzsjfhc.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzsjfhc.dao.PaymentVerificationDao;
import com.jshx.yzsjfhc.entity.PaymentVerification;
import com.jshx.zzhgl.entity.Zzh;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;

import java.util.List;
import java.util.Map;

@Component("paymentVerificationDao")
public class PaymentVerificationDaoImpl extends BaseDaoImpl implements PaymentVerificationDao
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPaymentVerificationByMap", paraMap, page);
	}

	public List<String> findPaymentVerification(Map<String,Object> paraMap){
		return this.findListBySqlId("findPaymentVerification", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentVerification getById(String id)
	{
		return (PaymentVerification)this.getObjectById(Zzh.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PaymentVerification model)
	{
		model.setId(null);
		this.saveOrUpdateObject(model);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PaymentVerification model)
	{
		this.saveOrUpdateObject(model);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(PaymentVerification.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		PaymentVerification model = (PaymentVerification)this.getObjectById(Zzh.class, id);
		model.setDelFlag(1);
		this.saveObject(model);
	}

}
