package com.jshx.yzscw.yzscwkmgl.web;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.module.admin.entity.User;
import com.jshx.yzscw.yzscwfzhskm.entity.YzscwkjkmYzscwfzhskm;
import com.jshx.yzscw.yzscwfzhskm.service.YzscwkjkmYzscwfzhskmService;
import com.jshx.yzscw.yzscwkmgl.entity.Yzscwkmgl;
import com.jshx.yzscw.yzscwkmgl.service.YzscwkmglService;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.struts2.ServletActionContext;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;
import java.util.Date;

public class YzscwkmglAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	private String selKmgl;

	private InputStream excelFile;

	private String fileName;

	/**
	 * 实体类
	 */
	private Yzscwkmgl yzscwkmgl = new Yzscwkmgl();

	/**
	 * 业务类
	 */
	@Autowired
	private YzscwkmglService yzscwkmglService;
	@Autowired
	private YzscwkjkmYzscwfzhskmService yzscwkjkmYzscwfzhskmService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;



	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 跳转到会计科目页面
	 */
	public String kjkmglInit() {
		return SUCCESS;
	}

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(StringUtils.isNotBlank(yzscwkmgl.getKmmc())){
			paraMap.put("kmmc", "%" + yzscwkmgl.getKmmc() + "%");
		}
		if(StringUtils.isNotBlank(yzscwkmgl.getKmdm())){
			//x科目代码前缀都一样且冗长,可以通过只输入后面唯一码来查询
			paraMap.put("kmdm", "%" + yzscwkmgl.getKmdm() + "%");
		}

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(true){

		    //设置查询条件，开发人员可以在此增加过滤条件
			/*if ((null != yzssfgl.getYzsqy()) && (0 < yzssfgl.getYzsqy().trim().length())){
				paraMap.put("yzsqy", "%" + yzssfgl.getYzsqy().trim() + "%");
			}
			*/
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|showName|kmdm|kmmc|kmlx|parentKm|parentKmdm|parentKmmc|hasChild|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		//排序
		/*paraMap.put("sortBy", 1);*/
		paraMap.put("parentId", yzscwkmgl.getId());
		if (StringUtils.isBlank(yzscwkmgl.getId())) {
			paraMap.put("root", 1);
//			paraMap.put("parents", 1);
		}
		pagination = yzscwkmglService.findByPage(pagination, paraMap);

//		pagination = yzssfglService.findByPage(pagination, paraMap);
		convObjectToJson(pagination, config);
	}

	/**
	 * 部门树的节点查询，封装成树的节点信息返回：<br>
	 * 初始化时：[{"id":"","text":"","state":"","children":[{"id":"","text":"","state":""}]}]<br>
	 * 非初始化时：[{"id":"","text":"","state":""}]
	 *
	 * @throws Exception
	 */
	public void findChildKjkmglByCurrUser() throws Exception{
		User user = this.getLoginUser();
		Map<String, Object> paraMap = new HashMap<>();
		// 初始化部门树
		List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
		Map<String, Object> root = new HashMap<String, Object>();
		root.put("id", "");
		root.put("text", "会计科目管理");
		root.put("state", "opened");
		// todo
		paraMap.put("root", "1");
		List<Yzscwkmgl> kmglList = yzscwkmglService.findYzscwkmgl(paraMap);
		kmglList.sort((o1, o2) -> o1.getKmdm().compareToIgnoreCase(o2.getKmdm()));

		List<Map<String, Object>> elements = new ArrayList<Map<String, Object>>();

		elements = toTreeData(kmglList, elements);
		root.put("children", elements);
		items.add(root);

		JSONArray json = JSONArray.fromObject(elements);
		HttpServletResponse response = ServletActionContext
				.getResponse();
		response.setContentType("application/json;charset=UTF-8");
		response.setCharacterEncoding("utf-8");
		response.setHeader("Charset", "utf-8");
		response.setHeader("Cache-Control", "no-cache");
		response.getWriter().print(json.toString());

	}


	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if (null != yzscwkmgl && StringUtils.isNotBlank(yzscwkmgl.getId())) {
			yzscwkmgl = yzscwkmglService.getById(yzscwkmgl.getId());
			if (StringUtils.isNotBlank(yzscwkmgl.getParentId())) {
				Yzscwkmgl parent = yzscwkmglService.getById(yzscwkmgl.getParentId());
				yzscwkmgl.setParentYzscwkm(parent);
			}
		}
		return VIEW;
	}

	/**
	 * 	初始化修改信息
	 */
	public String initEdit() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		if (null != yzscwkmgl && null != yzscwkmgl.getId()) {
			paraMap.put("id", yzscwkmgl.getId());
			yzscwkmgl = yzscwkmglService.getById(yzscwkmgl.getId());
			if (StringUtils.isNotBlank(yzscwkmgl.getParentId())) {
				Yzscwkmgl parent = yzscwkmglService.getById(yzscwkmgl.getParentId());
				yzscwkmgl.setParentYzscwkm(parent);
			}
		}
	    return EDIT;
	}
	/**
	 * 	初始化添加信息
	 */
	public String initAdd() throws Exception{
		Map<String, Object> paraMap = new HashMap<>();
		if (null != yzscwkmgl && null != yzscwkmgl.getId()) {
			Yzscwkmgl kmglById = new Yzscwkmgl();
			if ("undefind".equals(yzscwkmgl.getKmdm()) || "".equals(yzscwkmgl.getKmdm())) {
				//说明未选择或者为顶级
			}else {
//				paraMap.put("id", yzscwkmgl.getId());
//				kmglById = yzscwkmglService.findKmglByKmdm(yzscwkmgl.getKmdm());
				kmglById = yzscwkmglService.getById(yzscwkmgl.getId());
			}
			yzscwkmgl.setParentYzscwkm(kmglById);
		}
	    return EDIT;
	}

	/**
	 * 	保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try {
			//设置Blob字段
			setBlobField(in);
		}
		finally {
			if (null != in) {
				try {
					in.close();
				}
				catch (Exception ex) {

				}
			}
		}
		if ("add".equalsIgnoreCase(this.flag)){
			if (null != yzscwkmgl) {
				yzscwkmgl.setDelFlag(0);
				yzscwkmgl.setHasChild(0);
				//如果存在相同的科目代码则不允许添加	2019-8-16 start
				Map<String, Object> paraMap = new HashMap<>();
				paraMap.put("kmdm", yzscwkmgl.getKmdm());
				paraMap.put("delFlag", 0);
				List<Yzscwkmgl> exist = yzscwkmglService.findYzscwkmgl(paraMap);
//				Yzscwkmgl kmgl = yzscwkmglService.findKmglByKmdm(this.yzscwkmgl.getKmdm());
				if (CollectionUtils.isNotEmpty(exist)) {
					this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "已存在相同的科目代码!" + "\"}");
					return null;
				}
				// 2019-8-16 end
				if (StringUtils.isNotBlank(this.yzscwkmgl.getKmdm())){
					this.yzscwkmgl.setShowName("("+ this.yzscwkmgl.getKmdm()+")"+ this.yzscwkmgl.getKmmc());
				}else {
					this.yzscwkmgl.setShowName(this.yzscwkmgl.getKmmc());
				}
				if (StringUtils.isNotBlank(this.yzscwkmgl.getParentId())) {
					//非分类
					Yzscwkmgl parentById = yzscwkmglService.getById(this.yzscwkmgl.getParentId());
					this.yzscwkmgl.setParentKmmc(parentById.getKmmc());
				} else {
					//顶级分类,无parent
				}
				yzscwkmglService.save(this.yzscwkmgl);
				this.getResponse().getWriter().println("{\"result\":" + true + ",\"message\":\"" + "新增成功!" + "\"}");
				return null;
			}

		}else{
			if (null != yzscwkmgl) {
				try {
					Yzscwkmgl byId = yzscwkmglService.getById(yzscwkmgl.getId());
					if(StringUtils.isNotBlank(yzscwkmgl.getKmdm())) {
						Yzscwkmgl exist = yzscwkmglService.findKmglByKmdm(yzscwkmgl.getKmdm());
						if (null != exist) {
							this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "已存在相同的科目代码!" + "\"}");
							return null;
						}
						byId.setKmdm(yzscwkmgl.getKmdm());
					}
					if (StringUtils.isNotBlank(yzscwkmgl.getKmmc())) {
						byId.setKmmc(yzscwkmgl.getKmmc());
					}

					if (StringUtils.isNotBlank(yzscwkmgl.getKmdm())){
						byId.setShowName("("+yzscwkmgl.getKmdm()+")"+yzscwkmgl.getKmmc());
					}else {
						byId.setShowName(yzscwkmgl.getKmmc());
					}

					yzscwkmglService.updateAndChildren(byId);
					this.getResponse().getWriter().println("{\"result\":" + true + ",\"message\":\"" + "修改成功!" + "\"}");
					return null;
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	*/
	private void setBlobField(FileInputStream in)
	{
		if (true)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到zsdw中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	*/
	public String delete() throws Exception{
		List<String> list = new ArrayList<>();
		boolean tag = false;
	    try{
//			yzscwkmglService.deleteWithFlag(ids);
			String[] idArray = ids.split(",");
			if(null != idArray) {
				for (String id : idArray) {
					findChildrenIds(id.trim(), list);
					list.add(id.trim());
//					list.addAll(childrenIds);
				}
			}
			for (String s : list) {
				Map<String, Object> paraMap = new HashMap<>();
				paraMap.put("kjkmId", s);
				List<YzscwkjkmYzscwfzhskm> hasLinked = yzscwkjkmYzscwfzhskmService.findYzscwkjkmYzscwfzhskm(paraMap);
				//说明已经被关联,不允许删除
				if (hasLinked.size()>0) {
					this.getResponse().getWriter().println("{\"result\":" + false + ",\"message\":\"" + "当前会计科目已被关联,不允许删除!" + "\"}");
					return null;
				}

			}
			yzscwkmglService.deleteWithFlag(list);
			this.getResponse().getWriter().println("{\"result\":true}");
			return null;
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
			return null;
		}
	}

	/**
	 * 异步获取单个节点信息
	 */
	public void getNodeById() throws IOException {
		if (StringUtils.isNotBlank(ids)) {
			Yzscwkmgl byId = yzscwkmglService.getById(ids);
			this.getResponse().getWriter().println("{\"result\":" + true + ",\"code\":\"" + byId.getKmdm()+ "\",\"message\":\"" + "获取成功!" + "\"}");
		}
	}

	/**
	 * 获取传入科目列表id下的所有子科目的id
	 */
	public List<String> findChildrenIds(String id, List<String> list) {
		Map<String, Object> paraMap = new HashMap<>();
		List<Yzscwkmgl> kmgls = yzscwkmglService.findYzscwkmglListByParentId(id);
		paraMap.put("parentId", id);
		List<Yzscwkmgl> kmgles = yzscwkmglService.findYzscwkmgl(paraMap);
		for (Yzscwkmgl kmgl : kmgles) {
			if(kmgl.getHasChild()>0 && yzscwkmglService.findYzscwkmglListByParentId(id).size()>0){
				List<String> childrenIds = findChildrenIds(kmgl.getId(), new ArrayList<>());
				list.addAll(childrenIds);
			}
			list.add(kmgl.getId());
		}
//		list.add(id);
		return list;
	}

	/**
	 * 遍历目录树
	 * @return
	 */
	private List<Map<String, Object>> toTreeData(List<Yzscwkmgl> list, List<Map<String, Object>> elements) {
		for (Yzscwkmgl kmgl : list) {
			Map<String, Object> item = new HashMap<String, Object>();
			item.put("id", kmgl.getId());
			item.put("text", kmgl.getShowName());
			List<Yzscwkmgl> childList = new ArrayList<>();
//					if (StringUtils.isNotBlank(kmgl.getParentId())) {
			Map<String, Object> paraMap1 = new HashMap<>();
			paraMap1.put("parentId",kmgl.getId());
			childList = yzscwkmglService.findKmListByParentKmdm(paraMap1);
			childList.sort((o1, o2) -> o1.getKmdm().compareToIgnoreCase(o2.getKmdm()));
//					}
			if (childList.size() > 0) {
				item.put("state", "opened");
				List<Map<String, Object>> element = new ArrayList<>();
				List<Map<String, Object>> mapList = toTreeData(childList, element);
				item.put("children", mapList);
			}
			elements.add(item);
		}
		return elements;
	}

	/**
	 * 导出到Excel
	 */
	public String exportExcel() {
		try {
			List<Yzscwkmgl> list = yzscwkmglService.findYzscwkmgl(new HashMap<>());
			//排序
			list.sort((o1, o2) -> o1.getKmdm().compareToIgnoreCase(o2.getKmdm()));
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			// 声明一个工作薄
			HSSFWorkbook workbook = new HSSFWorkbook();
			// 生成一个表格
			HSSFSheet sheet = workbook.createSheet();

			// 设置Excel样式 start-------------------------------
			HSSFCellStyle cellStyle = workbook.createCellStyle(); // 单元格样式
			Font fontStyle = workbook.createFont(); // 字体样式
//			fontStyle.setBold(true); // 加粗
			fontStyle.setFontName("黑体"); // 字体
			fontStyle.setFontHeightInPoints((short) 11); // 大小
			// 将字体样式添加到单元格样式中
			cellStyle.setFont(fontStyle);
			// 边框，居中
			cellStyle.setBorderBottom(BorderStyle.THIN);
			cellStyle.setBorderLeft(BorderStyle.THIN);
			cellStyle.setBorderRight(BorderStyle.THIN);
			cellStyle.setBorderTop(BorderStyle.THIN);
			HSSFCellStyle cellStyleNotCenter = cellStyle;
			cellStyle.setAlignment(HorizontalAlignment.CENTER);	//居中
//			cellB2.setCellStyle(cellStyle); // 为B2单元格添加样式
			// 设置Excel样式 end---------------------------------

			// 产生表格标题行
			HSSFRow row = sheet.createRow(0);
			HSSFCell title0 = row.createCell(0);
			title0.setCellValue("序号");
			HSSFCell title1 = row.createCell(1);
			title1.setCellValue("科目代码");
			HSSFCell title2 = row.createCell(2);
			title2.setCellValue("科目名称");
			HSSFCell title3 = row.createCell(3);
			title3.setCellValue("备注");
			// 设置样式
			title0.setCellStyle(cellStyle);
			title1.setCellStyle(cellStyle);
			title2.setCellStyle(cellStyle);
			title3.setCellStyle(cellStyle);
			Iterator<Yzscwkmgl> iterator = list.iterator();

			int index = 0;
			while (iterator.hasNext()) {
				Yzscwkmgl kjkm = iterator.next();
				if (StringUtils.isNotBlank(kjkm.getParentId())) {
					index ++;
					row = sheet.createRow(index);

					HSSFCell cell0 = row.createCell(0);
					cell0.setCellValue(index);
					HSSFCell cell = row.createCell(1);
					cell.setCellValue(kjkm.getKmdm());
					HSSFCell cell2 = row.createCell(2);
					cell2.setCellValue(kjkm.getKmmc());
					HSSFCell cell3 = row.createCell(3);
					cell3.setCellValue(kjkm.getDescription());

					//样式
					cell0.setCellStyle(cellStyle);
					cell.setCellStyle(cellStyleNotCenter);	//科目代码
					cell2.setCellStyle(cellStyle);
					cell3.setCellStyle(cellStyle);
				}
			}

			// 设置列自适应宽度
			for (int i = 0; i < 4; i++) {
				sheet.autoSizeColumn(i);
				sheet.setColumnWidth(i,sheet.getColumnWidth(i)*17/10);
			}
			workbook.write(out);
			out.close();

			fileName = new String("会计科目列表".getBytes(), "iso-8859-1") + ".xls";

			excelFile = new ByteArrayInputStream(out.toByteArray());

			logger.debug("导出会计科目Excel成功!");
			return "exportExcel";
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(e.getMessage(), e);
			return ERROR;
		}
	}


	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Yzscwkmgl getYzscwkmgl() {
		return yzscwkmgl;
	}

	public void setYzscwkmgl(Yzscwkmgl yzscwkmgl) {
		this.yzscwkmgl = yzscwkmgl;
	}

	public YzscwkmglService getYzscwkmglService() {
		return yzscwkmglService;
	}

	public void setYzscwkmglService(YzscwkmglService yzscwkmglService) {
		this.yzscwkmglService = yzscwkmglService;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public String getSelKmgl() {
		return selKmgl;
	}

	public void setSelKmgl(String selKmgl) {
		this.selKmgl = selKmgl;
	}

	public InputStream getExcelFile() {
		return excelFile;
	}

	public void setExcelFile(InputStream excelFile) {
		this.excelFile = excelFile;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

}
