package com.jshx.yzscw.yzscwkmgl.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwkmgl.dao.YzscwkmglDao;
import com.jshx.yzscw.yzscwkmgl.entity.Yzscwkmgl;
import com.jshx.yzscw.yzscwkmgl.service.YzscwkmglService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("yzscwkmglService")
public class YzscwkmglServiceImpl extends BaseServiceImpl implements YzscwkmglService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("yzscwkmglDao")
	private YzscwkmglDao yzscwkmglDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return yzscwkmglDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzscwkmgl getById(String id)
	{
		return yzscwkmglDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param yzscwkmgl 信息
	 */
	@Transactional
	public void save(Yzscwkmgl yzscwkmgl)
	{
		yzscwkmglDao.save(yzscwkmgl);
		//如果父节点部位空则更新父节点hasChild字段
		if (StringUtils.isNotBlank(yzscwkmgl.getParentId())) {
			Yzscwkmgl parentKmgl = yzscwkmglDao.getById(yzscwkmgl.getParentId());

			parentKmgl.setHasChild(parentKmgl.getHasChild()+1);

			yzscwkmglDao.update(parentKmgl);
		}
	}

	/**
	 * 修改信息
	 * @param yzscwkmgl 信息
	 */
	@Transactional
	public void update(Yzscwkmgl yzscwkmgl)
	{
		yzscwkmglDao.update(yzscwkmgl);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects= yzscwkmglDao.findYzscwkmgl(paraMap);
		yzscwkmglDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(List<String> ids) {
		for (String id : ids) {
			yzscwkmglDao.deleteWithFlag(id);
		}

	}

	@Override
	public List<Yzscwkmgl> findYzscwkmgl(Map<String, Object> paraMap) {

		return yzscwkmglDao.findYzscwkmgl(paraMap);

	}

	@Override
	public List<Yzscwkmgl> findKmListByParentKmdm(Map<String, Object> paraMap) {
		return yzscwkmglDao.findKmListByParentKmdm(paraMap);
	}

	@Override
	public Yzscwkmgl findKmglByKmdm(String s) {
		return yzscwkmglDao.findKmglByKmdm(s);
	}

	@Override
	@Transactional
	public void updateAndChildren(Yzscwkmgl yzscwkmgl) {
		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("parentId", yzscwkmgl.getId());
		List<Yzscwkmgl> children = yzscwkmglDao.findYzscwkmgl(paraMap);
		//修改同时修改对应的children的parentId
		if (CollectionUtils.isNotEmpty(children)) {
			for (Yzscwkmgl child : children) {
				child.setParentKmmc(yzscwkmgl.getKmmc());
				child.setParentKmdm(yzscwkmgl.getParentKmdm());
				yzscwkmglDao.update(child);
			}
		}
		yzscwkmglDao.update(yzscwkmgl);
	}

	@Override
	public List<Yzscwkmgl> findYzscwkmglListByParentId(String parentId) {
		return yzscwkmglDao.findListBy(Yzscwkmgl.class, "parentId", parentId);
	}

	/**
	 * 根据科目码获取科目
	 * @param kmdm
	 * @return
	 */
	@Override
	public Yzscwkmgl getByKmdm(String kmdm){
		Map<String,Object> paramMap = new HashMap<>();
		paramMap.put("kmdm",kmdm);
		Yzscwkmgl yzscwkmgl = (Yzscwkmgl) yzscwkmglDao.findObjectByFieldsMap(Yzscwkmgl.class,paramMap);
		return yzscwkmgl;
	}
}
