package com.jshx.tfspb.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.tfspb.dao.TfspbDao;
import com.jshx.tfspb.entity.Tfspb;
import com.jshx.tfspb.service.TfspbService;

@Service("tfspbService")
public class TfspbServiceImpl extends BaseServiceImpl implements TfspbService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("tfspbDao")
	private TfspbDao tfspbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return tfspbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Tfspb getById(String id)
	{
		return tfspbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Tfspb tfspb)
	{
		tfspbDao.save(tfspb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Tfspb tfspb)
	{
		tfspbDao.update(tfspb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=tfspbDao.findTfspb(paraMap);
		
		tfspbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    tfspbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public Tfspb getBYslbh(String slbh) {
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("slbh", slbh);
		paraMap.put("delFlag", 0);
		Tfspb tfspb = (Tfspb)tfspbDao.findObjectByFieldsMap(Tfspb.class, paraMap);
		return tfspb;
	}
}
