package com.jshx.sdjd.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.jshx.core.utils.StringUtil;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.tbshxk.entity.Tbshxk;
import com.jshx.tbshxk.service.TbshxkService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.common.utils.Constant;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.jsdwinfo.entity.Jsdwinfo;
import com.jshx.jsdwinfo.service.JsdwinfoService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.sdjd.entity.Sdjd;
import com.jshx.sdjd.service.SdjdService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;

public class SdjdAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Sdjd sdjd = new Sdjd();

	/**
	 * 业务类
	 */
	@Autowired
	private SdjdService sdjdService;
	@Autowired
	private TbshxkService tbshxkService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private JsdwinfoService jsdwinfoService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private GenericManager genericManager;
    @Autowired
    private IdentityService identityService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    private FawenAttachService fawenAttachService;
	@Autowired
	private UserService userService;
	@Autowired
	private CktzsService cktzsService;
	@Autowired
	private PaymentItemDelayService paymentItemDelayService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
	private String urldz;
	private String  xmxxbid;
	private String danweidm;
	private String liushuihao;
	private String oldxmxxb;
	private String xxylb;
	
	private List<FawenAttach> attach;
	private List<File> file1 ;  
	 private List<String> file1FileName ;
	private String allFileName;
	private String originFileName;
	private String jsdwwk;
	
	

	public String getJsdwwk() {
		return jsdwwk;
	}

	public void setJsdwwk(String jsdwwk) {
		this.jsdwwk = jsdwwk;
	}

	public List<FawenAttach> getAttach() {
		return attach;
	}

	public void setAttach(List<FawenAttach> attach) {
		this.attach = attach;
	}

	public List<File> getFile1() {
		return file1;
	}

	public void setFile1(List<File> file1) {
		this.file1 = file1;
	}

	public List<String> getFile1FileName() {
		return file1FileName;
	}

	public void setFile1FileName(List<String> file1FileName) {
		this.file1FileName = file1FileName;
	}

	public String getAllFileName() {
		return allFileName;
	}

	public void setAllFileName(String allFileName) {
		this.allFileName = allFileName;
	}

	public String getOriginFileName() {
		return originFileName;
	}

	public void setOriginFileName(String originFileName) {
		this.originFileName = originFileName;
	}

	public String getXxylb() {
		return xxylb;
	}

	public void setXxylb(String xxylb) {
		this.xxylb = xxylb;
	}

	public String getOldxmxxb() {
		return oldxmxxb;
	}

	public void setOldxmxxb(String oldxmxxb) {
		this.oldxmxxb = oldxmxxb;
	}

	public String getDanweidm() {
		return danweidm;
	}

	public void setDanweidm(String danweidm) {
		this.danweidm = danweidm;
	}

	public String getXmxxbid() {
		return xmxxbid;
	}

	public void setXmxxbid(String xmxxbid) {
		this.xmxxbid = xmxxbid;
	}

	public String getUrldz() {
		return urldz;
	}

	public void setUrldz(String urldz) {
		this.urldz = urldz;
	}

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	private String excel_Name ;
	
	
	public String getExcel_Name() {
		return excel_Name;
	}

	public void setExcel_Name(String excel_Name) {
		this.excel_Name = excel_Name;
	}

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		//0意见提交,1复核成功,2退回
		if(pagination==null){
		    pagination = new Pagination(this.getRequest());
		}
		  if(!this.getLoginUser().getIsSuperAdmin()){
        	  String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
  			  paraMap.put("dwdm", dwdm.trim());
          }
		if(null != sdjd){
		    //设置查询条件，开发人员可以在此增加过滤条件
			// 添加通过id过滤条件, 2019-5-22  start
			if (null != sdjd.getId() && (0 < sdjd.getXmbh().trim().length())) {
				paraMap.put("id", sdjd.getId());
			}
			// 2019-5-22  end
			if ((null != sdjd.getXmbh()) && (0 < sdjd.getXmbh().trim().length())){
				paraMap.put("xmbh", "%" + sdjd.getXmbh().trim() + "%");
			}
			if ((null != sdjd.getStarts()) && (0 < sdjd.getStarts().trim().length())){
				if("0".equals(sdjd.getStarts())){
					paraMap.put("abc", "asd");
				}else if("1".equals(sdjd.getStarts())){
					paraMap.put("starts", "1");
					
				}
			}
//			else{
//				//没有选择状态的时候,默认为0
//				paraMap.put("starts", "%0%");
//			}

			if ((null != sdjd.getJsdw()) && (0 < sdjd.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + sdjd.getJsdw().trim() + "%");
			}

			if ((null != sdjd.getXxbbh()) && (0 < sdjd.getXxbbh().trim().length())){
				paraMap.put("xxbbh", "%" + sdjd.getXxbbh().trim() + "%");
			}

			if ((null != sdjd.getXmmc()) && (0 < sdjd.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + sdjd.getXmmc().trim() + "%");
			}

			if ((null != sdjd.getLxr()) && (0 < sdjd.getLxr().trim().length())){
				paraMap.put("lxr", "%" + sdjd.getLxr().trim() + "%");
			}
			if ((null != sdjd.getJsdd()) && (0 < sdjd.getJsdd().trim().length())){
				paraMap.put("jsdd", "%" + sdjd.getJsdd().trim() + "%");
			}
			if ((null != sdjd.getMjyj()) && (0 < sdjd.getMjyj().trim().length())&&!"999".equals(sdjd.getMjyj().trim())){
				paraMap.put("mjyj", "%" + sdjd.getMjyj().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|createTime|jzmj27|jsmj8ys|jzmjds|zjzmj|xmbh|jsdw|xxbbh|xmmc|jsdd|lxr|lxdh|xkzh|gcmc|zyjzxz|jzcsds|jzcsdx|jzmjdx|jzmjdc|starts|mjyj|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = sdjdService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 复核
	 */
	public void list2() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null){
		    pagination = new Pagination(this.getRequest());
		}
		  if(!this.getLoginUser().getIsSuperAdmin()){
        	  String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
  			  paraMap.put("dwdm", dwdm.trim());
          }
		if(null != sdjd){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != sdjd.getXmbh()) && (0 < sdjd.getXmbh().trim().length())){
				paraMap.put("xmbh", "%" + sdjd.getXmbh().trim() + "%");
			}
			if ((null != sdjd.getStarts()) && (0 < sdjd.getStarts().trim().length())){
				paraMap.put("starts", "%" + sdjd.getStarts().trim() + "%");
			}else{
				//没有选择状态的时候,默认为0
				paraMap.put("starts", "%0%");
				
			}

			if ((null != sdjd.getJsdw()) && (0 < sdjd.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + sdjd.getJsdw().trim() + "%");
			}

			if ((null != sdjd.getXxbbh()) && (0 < sdjd.getXxbbh().trim().length())){
				paraMap.put("xxbbh", "%" + sdjd.getXxbbh().trim() + "%");
			}

			if ((null != sdjd.getXmmc()) && (0 < sdjd.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + sdjd.getXmmc().trim() + "%");
			}

			if ((null != sdjd.getLxr()) && (0 < sdjd.getLxr().trim().length())){
				paraMap.put("lxr", "%" + sdjd.getLxr().trim() + "%");
			}
			if ((null != sdjd.getJsdd()) && (0 < sdjd.getJsdd().trim().length())){
				paraMap.put("jsdd", "%" + sdjd.getJsdd().trim() + "%");
			}
			if ((null != sdjd.getMjyj()) && (0 < sdjd.getMjyj().trim().length())&&!"999".equals(sdjd.getMjyj().trim())){
				paraMap.put("mjyj", "%" + sdjd.getMjyj().trim() + "%");
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|createTime|createUserID|jzmj27|jsmj8ys|jzmjds|zjzmj|xmbh|jsdw|xxbbh|xmmc|jsdd|lxr|lxdh|xkzh|gcmc|zyjzxz|jzcsds|jzcsdx|jzmjdx|mjyj|jzmjdc|starts|lxpw|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = sdjdService.findByPage(pagination, paraMap);
		List<Sdjd> lsd=pagination.list;
		List<Sdjd> lsdnew=new ArrayList<>();
		for (Sdjd s : lsd) {
			if(null!=s.getCreateUserID()){
				User u=userService.findUserById(s.getCreateUserID());
				 s.setCreateUserID(u.getDisplayName());
				lsdnew.add(s);
			}
		}
		pagination.setList(lsdnew);
		convObjectToJson(pagination, config);
	}	
	
	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != sdjd)&&(null != sdjd.getId())){
			sdjd = sdjdService.getById(sdjd.getId());
		}
		Map<String, Object> paraMap = new HashMap<String, Object>();
		if ((null != sdjd.getXxbbh()) && (0 < sdjd.getXxbbh().trim().length())){
			paraMap.put("xxylb", sdjd.getXxbbh().trim() );
		}
		 List<Xmxxb> li=xmxxbService.findXmxxb(paraMap);
		 if(li.size()>0){
			 liushuihao=li.get(0).getXmlsh();
		 }
		 Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", sdjd.getXxbbh());
			paramMap.put("xmType", "手动建档");
			attach= fawenAttachService.queryAttachListByTempleId(paramMap);
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		   danweidm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
		   if("".equals(danweidm)){
			   danweidm="sf";
		   }
			
		view();
	    return EDIT;
	}
	public String initEditadd() throws Exception{
		   System.out.println(Constant.CONSTANT_MAP.get("ptf"));
		
		   danweidm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
		   if("".equals(danweidm)){
			   danweidm="sf";
		   }
		view();
		return EDIT;
	}
	public String initEdit2() throws Exception{
		view();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
		if ("add".equalsIgnoreCase(this.flag)){
			 Map<String, String> paraMapfj = new HashMap<String, String>();
			 
				//将附件相关信息放到附件表中
//			 String a=System.getProperty("user.dir").replace("bin", "webapps");
//		        String path = this.getRequest().getSession().getServletContext()
//						.getRealPath(File.separator)
//						+ File.separator+ "uploads" + File.separator + Constant.ZSLC_SDJD + File.separator;
//
//		        File f = new File(path);
//		        String ab=f.getParent();
//		        String cc=new File(ab).getParent();
			    //获取项目绝对路径
//		        String jdlj = this.getRequest().getSession().getServletContext()
//						.getRealPath(File.separator);
//		        File fil = new File(jdlj);
//		        //上一级目录
//		        String zsyj=fil.getParent();
		        //再上一级目录+新建文件夹名
		        String path=SysPropertiesUtil.jdlj(this.getRequest())+File.separator+ "uploads" + File.separator + Constant.ZSLC_SDJD + File.separator;

		     // 写到指定的路径中  
		        JSONObject jsonObject = JSONObject.fromObject(allFileName); 
		        JSONObject jsonObject1= JSONObject.fromObject(originFileName);
		    	String fileName = "";
						if(file1!=null)
						{
						  for(int i = 0 ; i < file1.size() ; i++ )  
					        {  
//							  fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path);
							  fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path,UUID.randomUUID().toString());
							  String attachType = jsonObject.getString(file1FileName.get(i));
							  paraMapfj.put("attachType", attachType);
							  paraMapfj.put("bizrowid", sdjd.getXxbbh());//无项目编号主键,先用手动建档的ID
//							  paraMapfj.put("xmType", "手动建档");
							 List list = fawenAttachService.queryAttachListByTempleId(paraMapfj);
							 if(list.size()>0)
							 {
								 FawenAttach fawenAttach = (FawenAttach) list.get(0);
								 fawenAttach.setAttachname(file1FileName.get(i));
								 fawenAttach.setAttachpath(fileName);
//								 fawenAttach.setWdno(jsonObject1.getString(file1FileName.get(i)));
								 fawenAttachService.update(fawenAttach);
							 }
							 else
							 {
							  FawenAttach att = new FawenAttach();
								att.setDelFlag(0);
								att.setAttachname(file1FileName.get(i));
								att.setAttachpath(fileName);
								att.setBizrowid(sdjd.getXxbbh());
								att.setCreateTime(new Date());
								att.setAttachType(attachType);
								att.setXmType("手动建档");
//								att.setWdno(jsonObject1.getString(file1FileName.get(i)));
								fawenAttachService.save(att);
							 }
					             
					              
					        } 	
						}
//			MultiPartRequestWrapper request = (MultiPartRequestWrapper) this
//					.getRequest();
//			Enumeration enu = request.getFileParameterNames();
//			String fileName = "";
//			String pathFile = this.getRequest().getSession().getServletContext()
//					.getRealPath("/")
//					+ "upload" +File.separator;
//			while (enu.hasMoreElements()) {
//				fileName = FileUtils.uploadFile(request, enu, pathFile,UUID.randomUUID().toString());
//			}
			sdjd.setDeptId(this.getLoginUserDepartmentId());
			sdjd.setDelFlag(0);
////			String[] jiaose=this.getLoginUser().getRoleIds();
			sdjd.setStarts("0");
//			if(!fileName.equals("")){
//			sdjd.setUrldz("/upload/"+fileName);
//			}else{
//				sdjd.setUrldz("1");
//			}
			if("001".equals(sdjd.getMjyj())||"005".equals(sdjd.getMjyj())){
			String dxmj="0";//地下面积
			String dsmj="0";//地上面积
			String zmj="0";//总面积
			//地下面积
			if(null!=sdjd.getJzmjdx()&&!"".equals(sdjd.getJzmjdx())){
				dxmj=sdjd.getJzmjdx();
				sdjd.setJzmjdx(dxmj);
			}
			//总地上面积
			if(null!=sdjd.getJzmjds()&&!"".equals(sdjd.getJzmjds())){
				dsmj=sdjd.getJzmjds();
				sdjd.setJzmjds(dsmj);
			}
			zmj=SysPropertiesUtil.add(dxmj,dsmj);
			sdjd.setZjzmj(zmj);
			//sdjd.setBxzd1("0");
			}else{
				sdjd.setJzmjdx("");
				sdjd.setJzmjds("");
				if(null!=sdjd.getZjzmj()&&!"".equals(sdjd.getZjzmj())){
					String tem=sdjd.getZjzmj();
					sdjd.setZjzmj(tem);
				}
			}
			 if(!this.getLoginUser().getIsSuperAdmin()){
	        	  Zsdw zs=zsdwService.getzsdw(this.getLoginUserDepartmentId());
	        	  sdjd.setDwdm(zs.getZsdm());
	        	  sdjd.setZsdw(zs.getZsdw());
	          }else{
	        	  sdjd.setDwdm("sf");
	        	  sdjd.setZsdw("收费处");  
	          }
			Map<String, Object> paraMap = new HashMap<String, Object>();
            paraMap.put("xxbbh",sdjd.getXxbbh().trim());
            List<Sdjd> sdlist=sdjdService.findSdjd(paraMap);
            Sdjd bean=null;
            if(sdlist.size()>0){
              bean=sdlist.get(0);
             }
			      // Sdjd bean = sdjdService.getById(sdjd.getId());
						//判断项目向信息表是否存在相同
						if(selectxminfo(sdjd)){
							throw new Exception ("项目已建档并审核通过");
						}
						//判断是否存在相同信息一览表
						 if(null==bean){
							 sdjdService.save(sdjd);
						 }else{
							 throw new Exception ("项目已建档");
						 }
						//sdjdService.update(sdjd);
		}else{
			savexg();
		}
			    return RELOAD;
	}
	
	

	/**
	 * 退回后修改
	 */
	public void savexg() throws Exception{
//		MultiPartRequestWrapper request = (MultiPartRequestWrapper) this
//				.getRequest();
//		Enumeration enu = request.getFileParameterNames();
//		String fileName = "";
//		String pathFile = this.getRequest().getSession().getServletContext()
//				.getRealPath("/")
//				+ "upload" +File.separator;
//		while (enu.hasMoreElements()) {
//			fileName = FileUtils.uploadFile(request, enu, pathFile,UUID.randomUUID().toString());
//		}
		if((null != sdjd)&&(null != sdjd.getId())){
			
			 Map<String, String> paraMapfj = new HashMap<String, String>();
			 
				//将附件相关信息放到附件表中
//		        String path = this.getRequest().getSession().getServletContext()
//						.getRealPath(File.separator)
//						+ File.separator+ "uploads" +File.separator;
			   String cc = this.getRequest().getSession().getServletContext()
						.getRealPath(File.separator);
		        File ff = new File(cc);
		        String ab=ff.getParent();
		        String path=new File(ab).getParent()+File.separator+ "uploads" + File.separator + Constant.ZSLC_SDJD + File.separator;
		     // 写到指定的路径中  
		        JSONObject jsonObject = JSONObject.fromObject(allFileName); 
//		        JSONObject jsonObject1= JSONObject.fromObject(originFileName);
		    	String fileName = "";
						if(file1!=null)
						{
						  for(int i = 0 ; i < file1.size() ; i++ )  
					        {  
//							  fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path);
							  fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path,UUID.randomUUID().toString());
							  String attachType = jsonObject.getString(file1FileName.get(i));
							  paraMapfj.put("attachType", attachType);
							  paraMapfj.put("bizrowid", sdjd.getXxbbh());//无项目编号主键,先用手动建档的ID
							 List list = fawenAttachService.queryAttachListByTempleId(paraMapfj);
							 if(list.size()>0)
							 {
								 FawenAttach fawenAttach = (FawenAttach) list.get(0);
								 fawenAttach.setAttachname(file1FileName.get(i));
								 fawenAttach.setAttachpath(fileName);
//								 fawenAttach.setWdno(jsonObject1.getString(file1FileName.get(i)));
								 fawenAttachService.update(fawenAttach);
							 }
							 else
							 {
							  FawenAttach att = new FawenAttach();
								att.setDelFlag(0);
								att.setAttachname(file1FileName.get(i));
								att.setAttachpath(fileName);
								att.setBizrowid(sdjd.getXxbbh());
								att.setCreateTime(new Date());
								att.setAttachType(attachType);
								att.setXmType("手动建档");
//								att.setWdno(jsonObject1.getString(file1FileName.get(i)));
								fawenAttachService.save(att);
							 }
					             
					        } 	
						}
			
			  
			   Sdjd s=new Sdjd();
			 s = sdjdService.getById(sdjd.getId());
	      	s.setStarts("0");
	      	s.setMjyj(sdjd.getMjyj());
		
	      	if(!s.getXxbbh().equals(sdjd.getXxbbh())){
	      		 Map<String, String> paraMapxxg = new HashMap<String, String>();
	      		paraMapxxg.put("bizrowid", s.getXxbbh());//无项目编号主键,先用手动建档的ID
				 List<FawenAttach> list = fawenAttachService.queryAttachListByTempleId(paraMapxxg);
				 if(list.size()>0)
				 {
					 for (FawenAttach f : list) {
						 f.setBizrowid(sdjd.getXxbbh());
						 fawenAttachService.update(f);
					}
				 }
	      	}
	      	
	      	
		//项目编号
		if(null!=sdjd.getXmbh()&&!"".equals(sdjd.getXmbh())){
		 s.setXmbh(sdjd.getXmbh());
		}
		//信息表编号
		if(null!=sdjd.getXxbbh()&&!"".equals(sdjd.getXxbbh())){
			s.setXxbbh(sdjd.getXxbbh());
		}
		//建设单位
		if(!"".equals(sdjd.getJsdw())&&null!=sdjd.getJsdw()){
			s.setJsdw(sdjd.getJsdw());
		}
		//项目名称
		if(!"".equals(sdjd.getXmmc())&&null!=sdjd.getXmmc()){
			s.setXmmc(sdjd.getXmmc());
		}
		//建设地点
		if(!"".equals(sdjd.getJsdd())&&null!=sdjd.getJsdd()){
			s.setJsdd(sdjd.getJsdd());
		}
		//地上面积小计
		if(null!=sdjd.getJzmjds()&&!"".equals(sdjd.getJzmjds())){
			double ds=Double.valueOf(sdjd.getJzmjds());
			s.setJzmjds(String.valueOf(ds));
		}
		//地下面积小计
		if(null!=sdjd.getJzmjdx()&&!"".equals(sdjd.getJzmjdx())){
			double dx=Double.valueOf(sdjd.getJzmjdx());
			s.setJzmjdx(String.valueOf(dx));
		}
		//联系人
		if(null!=sdjd.getLxr()&&!"".equals(sdjd.getLxr())){
			s.setLxr(sdjd.getLxr());
		}
		//建筑面积底层
		if(null!=sdjd.getJzmjdc()&&!"".equals(sdjd.getJzmjdc())){
			s.setJzmjdc(sdjd.getJzmjdc());
		}
		//建筑面积2至7
		if(null!=sdjd.getJzmj27()&&!"".equals(sdjd.getJzmj27())){
			s.setJzmj27(sdjd.getJzmj27());
		}
		if(null!=sdjd.getJsmj8ys()&&!"".equals(sdjd.getJsmj8ys())){
			//建筑面积8以上
			s.setJsmj8ys(sdjd.getJsmj8ys());
		}
		//联系电话
		if(null!=sdjd.getLxdh()&&!"".equals(sdjd.getLxdh())){
			s.setLxdh(sdjd.getLxdh());
		}
		//许可证号
		if(null!=sdjd.getXkzh()&&!"".equals(sdjd.getXkzh())){
			s.setXkzh(sdjd.getXkzh());
		}
		//备注
		if(null!=sdjd.getBeizhu()&&!"".equals(sdjd.getBeizhu())){
			s.setBeizhu(sdjd.getBeizhu());
		}
		//规划许可证
		if(null!=sdjd.getGhxkzmj()&&!"".equals(sdjd.getGhxkzmj())){
			s.setGhxkzmj(sdjd.getGhxkzmj());
		}
		if(null!=sdjd.getXmbawh()&&!"".equals(sdjd.getXmbawh())){
			s.setXmbawh(sdjd.getXmbawh());
		}
		if(null!=sdjd.getZsfw()&&!"".equals(sdjd.getZsfw())){
			s.setZsfw(sdjd.getZsfw());
		}
		
		
	     s.setDwdm(sdjd.getDwdm());
	     s.setZsdw(sdjd.getZsdw());
		if("001".equals(sdjd.getMjyj())||"005".equals(sdjd.getMjyj())){
		String dxmj="0";//地下面积
		String dsmj="0";//地上面积
		String zmj="0";//总面积
		//地下面积
		if(null!=sdjd.getJzmjdx()&&!"".equals(sdjd.getJzmjdx())){
			dxmj=sdjd.getJzmjdx();
		}
		//总地上面积
		if(null!=sdjd.getJzmjds()&&!"".equals(sdjd.getJzmjds())){
			dsmj=sdjd.getJzmjds();
		}
		//zmj=dxmj+dsmj;
		zmj=SysPropertiesUtil.add(dxmj,dsmj);
		s.setZjzmj(zmj);
		}else{
		     if(null!=sdjd.getZjzmj()&&!"".equals(sdjd.getZjzmj())){
		    	 String a=sdjd.getZjzmj();
		    	 s.setZjzmj(a);
		     }
		}
		sdjdService.update(s);
		}
	}

	/**
	 * 通过审核保存
	 */
	public String tgsave() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		
		if((null != sdjd)&&(null != sdjd.getId())){
			  String start=sdjd.getStarts();
			   Sdjd s=new Sdjd();
			 s = sdjdService.getById(sdjd.getId());
			 s.setUpdateTime(new Date());
			 s.setUpdateUserID(this.getLoginUserId());
			 s.setBxzd1(sdjd.getBxzd1());
			 if("0".equals(start)){
				 //退回操作
				 s.setStarts("2");
				 String tem="";
				 if(null!=s.getBxzd1()&&!"".equals(s.getBxzd1())){
					 tem=s.getBxzd1()+".";
				 }
				 s.setBxzd1(this.getLoginUser().getDisplayName()+":"+sdjd.getBxzd1());
				 sdjdService.update(s);
				 this.getResponse().getWriter().println("{\"result\":\"true\",\"info\":\"操作成功！\"}");
//				 return "{\"result\":\"true\",\"info\":\"操作成功！\"}";
				 return null;
			 }
			//插入项目信息表
			if(("1".equals(start))&&!selectxminfo(s)){
				//加入项目信息表
				Boolean b = jlxxinfo(s);
				if(!b)
				{
					this.getResponse().getWriter().println("{\"result\":\"false\",\"info\":\"同步施工系统出错！\"}");
					return null;
				}
                //建立单位信息库
				jldwinfo(s);

			} else{
				 Sdjd ss1 =	sdjdService.getById(s.getId());
			 	if(ss1!=null && ("1".equals(ss1.getStarts())))
				{
					this.getResponse().getWriter().println("{\"result\":\"true\",\"info\":\"重复操作！\"}");
					return null;
				}
				else {
					s.setStarts("2");
					s.setBxzd1("已存在相同信息一览表项目");
					sdjdService.update(s);
				}
			}
		}

		this.getResponse().getWriter().println("{\"result\":\"true\",\"info\":\"操作成功！\"}");
		return null;
	}
	
    private Boolean  jlxxinfo(Sdjd s) {
    	//获取单位平方的金额
//    	String danjia=SysPropertiesUtil.getProperty("danweijine");
    	String danjia=(String) Constant.CONSTANT_MAP.get("ptf");
    	Xmxxb xmb=new Xmxxb();
    	xmb.setXxylb(s.getXxbbh());
    	xmb.setXkzh(s.getXkzh());
    	xmb.setLxpw(s.getLxpw());
    	xmb.setXmbh(s.getXmbh());
    	xmb.setJsdw(s.getJsdw());
    	xmb.setXmmc(s.getXmmc());
    	xmb.setJsdd(s.getJsdd());
    	xmb.setLianxiren(s.getLxr());
    	xmb.setPhone(s.getLxdh());
    	if(!"".equals(s.getJzmjdx())&&null!=s.getJzmjdx()){
    		xmb.setJzmjdx(s.getJzmjdx());
    	}
    	xmb.setZsfw(s.getZsfw());
    	
    	if(null!=s.getXkzh()){
    		xmb.setXkzh(s.getXkzh());
    	}
    	if(null!=s.getJbcs()){
    		xmb.setJbcs(s.getJbcs());
    	}
    	if(null!=s.getJzmjdc()){
    		xmb.setJzmjdc(s.getJzmjdc());
    	}
    	if(null!=s.getJzmj27()){
    		xmb.setJzmj27(s.getJzmj27());
    	}
    	if(null!=s.getJsmj8ys()){
    		xmb.setJzmj8ys(s.getJsmj8ys());
    	}
    	//地上总建筑面积
    	if(null!=s.getJzmjds()){
    		xmb.setZjzmjds(s.getJzmjds());
    	}
    	//总建筑面积
    	if(null!=s.getZjzmj()&&!"".equals(s.getZjzmj())){
    		xmb.setZjsmj(s.getZjzmj());
    		xmb.setYsdmj(s.getZjzmj());
    		 //建档时预审金额,
			  String tem=SysPropertiesUtil.jinehuoqu(xmb.getZjsmj(), danjia);
    		xmb.setSlmj(tem);
    	}else{
    		xmb.setZjsmj("0");
    	}
    	//建档时总建筑面积,应缴金额
//    	String tem=SysPropertiesUtil.jinehuoqu(xmb.getZjsmj(), danjia);
//    	xmb.setBxzd1(tem);
//    	xmb.setYjje(tem);
    	//单位代码
//    	Map<String, Object>  pmp= new HashMap<String, Object>();
//		pmp.put("zsdw", "%"+this.getLoginUserDepartment().getDeptName().trim()+"%");
//    	List<Zsdw> listzsdw=zsdwService.findZsdw(pmp);
    	
//    	String daima="sf";
    	//执收单位
//    	if("402880e92db726b5012db729f65f0001".equals(this.getLoginUserId())){
    	//管理员默认收费处
    		xmb.setDwdm(s.getDwdm());
    		xmb.setZsdw(s.getZsdw());
//    	}else{
//    	    xmb.setDwdm(listzsdw.get(0).getZsdm());
//    	    xmb.setZsdw(listzsdw.get(0).getZsdw());
//    	    daima=listzsdw.get(0).getZsdm();
//    	}
    	//项目流水号
    	String lsh=genericManager.getSN("lsh");
    	xmb.setXmlsh(lsh);
    	//项目受理编号
//    String sli=genericManager.getSN(daima);
//    xmb.setSlbh(lsh+daima+sli);
    	//手动建档标识
    	xmb.setHfsz("5");
    	//监控流程状态
    	xmb.setLcjk("0");
    	xmb.setDelFlag(0);
    	xmb.setMjyj(s.getMjyj());
    	xmb.setIsxmcx("2");
		String dwdm = "";
		if (!this.getLoginUser().getIsSuperAdmin())
		{
			dwdm =StringUtil.isEmpty(xmb.getDwdm())? zsdwService.getDwdm(this.getLoginUserDepartmentId()):xmb.getDwdm();
		}
		if("001".equals(s.getMjyj())||"005".equals(s.getMjyj()))
		{
			String result  =	CommonAction.send2wwSGXK(xmb,null,dwdm,null);
			if("false".equals(result) || StringUtil.isEmpty(result))
			{
				return Boolean.FALSE;
			}
		}

		if(StringUtil.isEmpty(xmb.getId()))
		{
			xmxxbService.save(xmb);
		}
		else
		{
			xmxxbService.update(xmb);
		}
    	
    	 Map<String, String> paraMapxxg = new HashMap<String, String>();
   		paraMapxxg.put("bizrowid", s.getXxbbh());//无项目编号主键,先用手动建档的ID
			 List<FawenAttach> list = fawenAttachService.queryAttachListByTempleId(paraMapxxg);
			 if(list.size()>0)
			 {
				 for (FawenAttach f : list) {
					 f.setBizrowid(xmb.getId());
					 fawenAttachService.update(f);
				}
			 }
    	
    	
    	s.setJcbzj(lsh);
    	s.setStarts("1");
    	sdjdService.update(s);
    	    return  Boolean.TRUE;
    	//启动工作流
//    	   String businessKey = xmb.getId();
//           Map<String, Object> variables = new HashMap<String, Object>();
//           variables.put("outcome", "0");
//           try {
//               identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
//               ProcessInstance processInstance = runtimeService.startProcessInstanceByKey("zslc", businessKey, variables);
//           } finally {
//               identityService.setAuthenticatedUserId(null);
//           }


	}

	//建立单位信息库	
	private void jldwinfo(Sdjd s) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("dwmc","%"+s.getJsdw().trim()+"%");
		List li = jsdwinfoService.findJsdwinfo(paraMap);
		if(li.size()==0){
			Jsdwinfo jsdwinfo=new Jsdwinfo();
			jsdwinfo.setDeptId(this.getLoginUserDepartmentId());
			jsdwinfo.setDelFlag(0);
			jsdwinfo.setDwmc(s.getJsdw());
			if(null!=s.getLxr()){
				jsdwinfo.setLianxiren(s.getLxr());
			}
			if(null!=s.getLxdh()){
				jsdwinfo.setLxdh(s.getLxdh());
			}
			jsdwinfoService.save(jsdwinfo);
		}
	}

	//查询是否项目信息表存在相同一览表
	private Boolean selectxminfo(Sdjd s) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("xxylb",   s.getXxbbh().trim());
		List<Xmxxb> lixxb=xmxxbService.findXmxxb(paraMap);
		if(lixxb.size()==0){
			return false;
		}
		return true;
		//xmxxbService.save();		
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != sdjd)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到sdjd中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }
	
	/**
	 * 验证
	 */
	
	public String yanzheng() throws Exception{
		if(xmxxbid.equals("")){
			this.getResponse().getWriter().println("{\"result\":false}");
			 return null;
		}else{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("xxylb",   xmxxbid);
		List<Xmxxb> lixxb=xmxxbService.findXmxxb(paraMap);
		Map<String, Object> paraMap2 = new HashMap<String, Object>();
        paraMap2.put("xxbbh",xmxxbid);
        List<Sdjd> sdlist=sdjdService.findSdjd(paraMap2);
        String message="";
       if(lixxb.size()>0){
        	String zt=lixxb.get(0).getHfsz();
        	  if("0".equals(zt)){
        		  message="待划分经办";
      	    }else if("1".equals(zt)){
      	    	message="待划分复核";
      	    }else if("2".equals(zt)){
      	    	message="待数字初审";
      	    }else if("3".equals(zt)){
      	    	message="待数字复核";
      	    }else if("4".equals(zt)||"5".equals(zt)||"6".equals(zt)){
      	    	message="待受理";
      	    }
        	this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+message+"\"}");
       	 return null;
        } else  if(sdlist.size()>0){
        	message="已建档(手动建档)";
        	this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+message+"\"}");
        	 return null;
        }else{
           this.getResponse().getWriter().println("{\"result\":true}");
          }
		}
        return null;
	}
	public String yanzheng3() throws Exception{
		if(xmxxbid.equals("")){
			this.getResponse().getWriter().println("{\"result\":false}");
		}else{
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("xxylb",   xmxxbid);
			List<Xmxxb> lixxb=xmxxbService.findXmxxb(paraMap);
			List<Sdjd> sdlist=new ArrayList<>();
			if(!oldxmxxb.equals(xmxxbid)){
			 Map<String, Object> paraMap2 = new HashMap<String, Object>();
			 paraMap2.put("xxbbh",xmxxbid);
			 sdlist=sdjdService.findSdjd(paraMap2);
			}
			if(sdlist.size()>0||lixxb.size()>0){
				this.getResponse().getWriter().println("{\"result\":false}");
			}else{
				
				this.getResponse().getWriter().println("{\"result\":true}");
			}
		}
		return null;
	}
	public String yanzheng1() throws Exception{
		boolean bul=true;
			if("0".equals(xmxxbid)){
				//无抵扣
				if(!oldxmxxb.equals(xxylb)){
					//更改了信息一览表编号
				Map<String, Object> paraMap3 = new HashMap<String, Object>();
				paraMap3.put("xxylb",   xxylb);
				List<Xmxxb> xxylblist=xmxxbService.findXmxxb(paraMap3);
				if(xxylblist.size()!=0){
					bul=false;
				  }
				}
			}else{
				//校验是否抵扣的项目为已审批结束的
//				Map<String, Object> paraMap = new HashMap<String, Object>();
//				paraMap.put("slbh",   xmxxbid);
//				List<Xmxxb> lixxb=xmxxbService.findXmxxb(paraMap);
//				if(lixxb.size()==0||!"0".equals(lixxb.get(0).getIssptg())){
//					bul=false;
//				}
				if(bul){
					if(!oldxmxxb.equals(xxylb)){
					Map<String, Object> paraMap3 = new HashMap<String, Object>();
					paraMap3.put("xxylb",   xxylb);
					List<Xmxxb> xxylblist=xmxxbService.findXmxxb(paraMap3);
					if(xxylblist.size()!=0){
						bul=false;
					}
    			  }
				}
			}
			if(bul){
				String ckhj="0";
				String message="";
				if(null!=jsdwwk&&!"".equals(jsdwwk)){
				Map<String, Object> sjk = new HashMap<String, Object>();
				sjk.put("dwmc", jsdwwk);
                  List<PaymentItemDelay> pas=paymentItemDelayService.findall(sjk);
				sjk.put("isjk", "0");
				List<Cktzs> cks=cktzsService.findByall(sjk);
				    if(pas.size()>0){
				    	//缓缴项目
				    	for (PaymentItemDelay pbean : pas) {
							if(!"0".equals(pbean.getHjye())){
								ckhj="1";
                               message+="存在缓缴项目:"+pbean.getSlbh()+". ";								
							}
						}
				    	
				    }
				    if(cks.size()>0){
				    	//超时项目
				    	ckhj="1";
				    	for (Cktzs cbean : cks) {
                           message+=" 超时未缴款项目:"+cbean.getSlbh()+". ";					
						}
				    	
				    }
				}
//				this.getResponse().getWriter().println("{\"result\":true}");
				
				this.getResponse().getWriter().println("{\"result\":true,\"ckhj\":\"" + ckhj + "\",\"message\":\"" + message + "\"}");
			}else{
				this.getResponse().getWriter().println("{\"result\":false}");
			}
		return null;
	}
	

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			sdjdService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	/**
	 * 下载图片
	 */
	public void downloadTemplate()
	 {
		 String excelName = excel_Name+"信息一览表.jpg";
	     try
	     {
	         excelName = new String(excelName.getBytes("GBK"), "ISO8859-1");
	     }
	     catch (UnsupportedEncodingException e)
	     {
	         excelName = excel_Name;
	     }
	     getResponse().setContentType("application/csv");
	     getResponse().setCharacterEncoding("UTF-8");
	     getResponse().addHeader("Content-Disposition", "attachment;filename=" + excelName);
//	     String dir = this.getRequest().getRealPath("") + File.separator + "WEB-INF" + File.separator + "download"
//	             + File.separator + excel_Name;
	 	String dir = this.getRequest().getSession().getServletContext()
				.getRealPath(File.separator)+urldz;
	     java.io.FileInputStream in = null;
	     OutputStream out = null;
	     try
	     {
	         in = new java.io.FileInputStream(dir);
	         out = this.getResponse().getOutputStream();
	       
	         int t = in.read();
	         while (t != -1)
	         {
	             out.write(t);
	             t = in.read();
	         }
	         in.close();
	         out.flush();
	         out.close();
	     }
	     catch (Exception e)
	     {
	    	 e.printStackTrace();
	     }
	     finally
	     {
	         if (null != in)
	         {
	             try
	             {
	                 in.close();
	             }
	             catch (IOException e)
	             {
	            	 e.printStackTrace();
	             }
	         }
	         if (null != out)
	         {
	             try
	             {
	                 out.close();
	             }
	             catch (IOException e)
	             {
	            	 e.printStackTrace();
	             }
	         }
	     }
	 }
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Sdjd getSdjd(){
		return this.sdjd;
	}

	public void setSdjd(Sdjd sdjd){
		this.sdjd = sdjd;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getLiushuihao() {
		return liushuihao;
	}

	public void setLiushuihao(String liushuihao) {
		this.liushuihao = liushuihao;
	}
       
    
}
