package com.jshx.rutaskinfo.web;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.activiti.service.ActivitiService;
import com.jshx.activiti.service.NotificationService;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.SpringContextHolder;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.rutaskinfo.entity.RuTaskInfo;

public class RuTaskInfoAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private RuTaskInfo ruTaskInfo = new RuTaskInfo();


	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
    
    @Autowired
	protected transient TaskService taskService;
    
    @Autowired
    protected ActivitiService activitiService;
	
    @Autowired
	protected UserService userService;
	
    @Autowired
	protected RuntimeService runtimeService;
    @Autowired
    protected RuTaskInfoUtil ruTaskInfoUtil;
    

    
	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryStartTimeStart;

	private Date queryStartTimeEnd;

	private Date queryClaimTimeStart;

	private Date queryClaimTimeEnd;

	private Date queryDueDateStart;

	private Date queryDueDateEnd;

	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		ruTaskList();
	}
	
	public void ruTaskList(){
		SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		
		//1.从jdbc.propertise文件获取JDBC配置信息
//		RuTaskInfoUtil ruTaskInfoUtil = new RuTaskInfoUtil();
		ruTaskInfoUtil.loadProperty();
		ruTaskInfoUtil.getConnection();
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		
		if(null != ruTaskInfo){
			if ((null != ruTaskInfo.getTaskState()) && (0 < ruTaskInfo.getTaskState().trim().length())){
				paraMap.put("taskState", ruTaskInfo.getTaskState().trim());
			}
			if ((null != ruTaskInfo.getBusinessKey()) && (0 < ruTaskInfo.getBusinessKey().trim().length())){
				paraMap.put("businessKey", ruTaskInfo.getBusinessKey().trim());
			}
			if(null != queryStartTimeStart){				
				paraMap.put("queryStartTimeStart", sDateFormat.format(queryStartTimeStart));
			}
			if(null != queryStartTimeEnd){
				paraMap.put("queryStartTimeEnd", sDateFormat.format(queryStartTimeEnd));
			}
			if(null != queryDueDateStart){
				paraMap.put("queryDueDateStart", sDateFormat.format(queryDueDateStart));
			}
			if(null != queryDueDateEnd){
				paraMap.put("queryDueDateEnd", sDateFormat.format(queryDueDateEnd));
			}
		}		
		
		//int total = 0;
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|businessKey|procDefId|startUserId|startTime|taskDefKey|taskState|claimTime|assignee|dueDate|procInstId|taskId|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		
		//2.创建JDBC查询语句
		try {
			//获取总数
//			total = ruTaskInfoUtil.getTotalCount(pagination,paraMap);
//			pagination.setTotalCount(total);
			//获取查询分页结果	
			ruTaskInfoUtil.getPageList(pagination,paraMap);
			convObjectToJson(pagination, config);
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}

	}
	
	public String sendMail() throws Exception{
		if(null != ruTaskInfo && null != ruTaskInfo.getAssignee() && !ruTaskInfo.getAssignee().isEmpty()){
			
			User user = userService.findUserByLoginId(ruTaskInfo.getAssignee());
			if(null != user && null != user.getEmail() && !user.getEmail().isEmpty()){
				NotificationService notificationService = SpringContextHolder.getBean("activitiMailService");
				if (notificationService != null) {					
					notificationService.sendNotification(ruTaskInfo.getProcInstId(), ruTaskInfo.getTaskId(), null);
				}	
				this.getResponse().getWriter().println("{\"result\":true}");
			}else{
				this.getResponse().getWriter().println("{\"result\":false}");
			}
		}else{
			this.getResponse().getWriter().println("{\"result\":false}");
		}		
		return null;
	}	
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public RuTaskInfo getRuTaskInfo(){
		return this.ruTaskInfo;
	}

	public void setRuTaskInfo(RuTaskInfo ruTaskInfo){
		this.ruTaskInfo = ruTaskInfo;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryStartTimeStart(){
		return this.queryStartTimeStart;
	}

	public void setQueryStartTimeStart(Date queryStartTimeStart){
		this.queryStartTimeStart = queryStartTimeStart;
	}

	public Date getQueryStartTimeEnd(){
		return this.queryStartTimeEnd;
	}

	public void setQueryStartTimeEnd(Date queryStartTimeEnd){
		this.queryStartTimeEnd = queryStartTimeEnd;
	}

	public Date getQueryClaimTimeStart(){
		return this.queryClaimTimeStart;
	}

	public void setQueryClaimTimeStart(Date queryClaimTimeStart){
		this.queryClaimTimeStart = queryClaimTimeStart;
	}

	public Date getQueryClaimTimeEnd(){
		return this.queryClaimTimeEnd;
	}

	public void setQueryClaimTimeEnd(Date queryClaimTimeEnd){
		this.queryClaimTimeEnd = queryClaimTimeEnd;
	}

	public Date getQueryDueDateStart(){
		return this.queryDueDateStart;
	}

	public void setQueryDueDateStart(Date queryDueDateStart){
		this.queryDueDateStart = queryDueDateStart;
	}

	public Date getQueryDueDateEnd(){
		return this.queryDueDateEnd;
	}

	public void setQueryDueDateEnd(Date queryDueDateEnd){
		this.queryDueDateEnd = queryDueDateEnd;
	}

}
