package com.jshx.rfxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmfshxxDao;
import com.jshx.rfxm.dao.RfxmqfhtkDao;
import com.jshx.rfxm.entity.Rfxmfshxx;
import com.jshx.rfxm.entity.Rfxmqfhtk;
import com.jshx.rfxm.service.RfxmfshxxService;
import com.jshx.rfxm.service.RfxmqfhtkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("rfxmqfhtkService")
public class RfxmqfhtkServiceImpl extends BaseServiceImpl implements RfxmqfhtkService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("rfxmqfhtkDao")
	private RfxmqfhtkDao rfxmqfhtkDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return rfxmqfhtkDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Rfxmqfhtk getById(String id)
	{
		return rfxmqfhtkDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param rfxmqfhtk 信息
	 */
	@Transactional
	public void save(Rfxmqfhtk rfxmqfhtk)
	{
		rfxmqfhtkDao.save(rfxmqfhtk);
	}

	/**
	 * 修改信息
	 * @param rfxmqfhtk 信息
	 */
	@Transactional
	public void update(Rfxmqfhtk rfxmqfhtk)
	{
		rfxmqfhtkDao.update(rfxmqfhtk);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=rfxmqfhtkDao.findRfxmqfhtk(paraMap);

		rfxmqfhtkDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					rfxmqfhtkDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Rfxmqfhtk> findRfxmqfhtk(Map<String, Object> paraMap) {

		return rfxmqfhtkDao.findRfxmqfhtk(paraMap);

	}

	@Override
	public Rfxmqfhtk getByYbjksbh(String ybjksbh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("ybjksbh",ybjksbh);
		Rfxmqfhtk rfxmqfhtk = (Rfxmqfhtk)rfxmqfhtkDao.findObjectByFieldsMap(Rfxmqfhtk.class,paramMap);
		return rfxmqfhtk;
	}

	@Override
	public Rfxmqfhtk getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		Rfxmqfhtk rfxmqfhtk = (Rfxmqfhtk)rfxmqfhtkDao.findObjectByFieldsMap(Rfxmqfhtk.class,paramMap);
		return rfxmqfhtk;
	}
}
