package com.jshx.rfxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmfshxxDao;
import com.jshx.rfxm.entity.Rfxmfshxx;
import com.jshx.rfxm.service.RfxmfshxxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("rfxmfshxxService")
public class RfxmfshxxServiceImpl extends BaseServiceImpl implements RfxmfshxxService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("rfxmfshxxDao")
	private RfxmfshxxDao rfxmfshxxDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return rfxmfshxxDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Rfxmfshxx getById(String id)
	{
		return rfxmfshxxDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param rfxmfshxx 信息
	 */
	@Transactional
	public void save(Rfxmfshxx rfxmfshxx)
	{
		rfxmfshxxDao.save(rfxmfshxx);
	}

	/**
	 * 修改信息
	 * @param rfxmfshxx 信息
	 */
	@Transactional
	public void update(Rfxmfshxx rfxmfshxx)
	{
		rfxmfshxxDao.update(rfxmfshxx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=rfxmfshxxDao.findRfxmfshxx(paraMap);

		rfxmfshxxDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					rfxmfshxxDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Rfxmfshxx> findRfxmfshxx(Map<String, Object> paraMap) {

		return rfxmfshxxDao.findRfxmfshxx(paraMap);

	}

	@Override
	public Rfxmfshxx getByYbjksbh(String ybjksbh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("ybjksbh",ybjksbh);
		Rfxmfshxx rfxmfshxx = (Rfxmfshxx)rfxmfshxxDao.findObjectByFieldsMap(Rfxmfshxx.class,paramMap);
		return rfxmfshxx;
	}

	@Override
	public Rfxmfshxx getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		Rfxmfshxx rfxmfshxx = (Rfxmfshxx)rfxmfshxxDao.findObjectByFieldsMap(Rfxmfshxx.class,paramMap);
		return rfxmfshxx;
	}
}
