package com.jshx.rfxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmJktzsDao;
import com.jshx.rfxm.dao.RfxmJktzsHistoryDao;
import com.jshx.rfxm.entity.RfxmJktzs;
import com.jshx.rfxm.entity.RfxmJktzsHistory;
import com.jshx.rfxm.service.RfxmJktzsHistoryService;
import com.jshx.rfxm.service.RfxmJktzsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("rfxmJktzsHistoryService")
public class RfxmJktzsHistoryServiceImpl extends BaseServiceImpl implements RfxmJktzsHistoryService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("rfxmJktzsHistoryDao")
	private RfxmJktzsHistoryDao rfxmJktzsHistoryDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return rfxmJktzsHistoryDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmJktzsHistory getById(String id)
	{
		return rfxmJktzsHistoryDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param rfxmJktzs 信息
	 */
	@Transactional
	public void save(RfxmJktzsHistory rfxmJktzsHistory)
	{
		rfxmJktzsHistoryDao.save(rfxmJktzsHistory);
	}

	/**
	 * 修改信息
	 * @param rfxmJktzs 信息
	 */
	@Transactional
	public void update(RfxmJktzsHistory rfxmJktzs)
	{
		rfxmJktzsHistoryDao.update(rfxmJktzs);
	}
	@Transactional
	@Override
	public void updateNotSave(RfxmJktzsHistory rfxmJktzs)
	{
		rfxmJktzsHistoryDao.update(rfxmJktzs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=rfxmJktzsHistoryDao.findRfxmJktzsHistory(paraMap);

		rfxmJktzsHistoryDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					rfxmJktzsHistoryDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<RfxmJktzsHistory> findRfxmJktzsHistory(Map<String, Object> paraMap) {

		return rfxmJktzsHistoryDao.findRfxmJktzsHistory(paraMap);

	}

	@Override
	public RfxmJktzsHistory getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		RfxmJktzsHistory rfxmJktzsHistory = (RfxmJktzsHistory) rfxmJktzsHistoryDao.findObjectByFieldsMap(RfxmJktzsHistory.class,paramMap);
		return rfxmJktzsHistory;
	}

	@Override
	public RfxmJktzsHistory getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		RfxmJktzsHistory rfxmJktzsHistory = (RfxmJktzsHistory) rfxmJktzsHistoryDao.findObjectByFieldsMap(RfxmJktzsHistory.class,paramMap);
		return rfxmJktzsHistory;
	}

	/**
	 * 根据缴款通知编号查询信息
	 * @param jktzsbh
	 */
	public RfxmJktzsHistory getByJktzsbh(String jktzsbh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jktzsbh",jktzsbh);
		RfxmJktzsHistory zzhqfdz = (RfxmJktzsHistory) rfxmJktzsHistoryDao.findObjectByFieldsMap(RfxmJktzsHistory.class,paramMap);
		return zzhqfdz;
	};
}
