package com.jshx.rfxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfxm.dao.RfxmEntityHistoryDao;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.entity.RfxmEntityHistory;
import com.jshx.rfxm.service.RfxmEntityHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("rfxmEntityHistoryService")
public class RfxmEntityHistoryServiceImpl extends BaseServiceImpl implements RfxmEntityHistoryService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("rfxmEntityHistoryDao")
	private RfxmEntityHistoryDao rfxmDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return rfxmDao.findByPage(page, paraMap);
	}

	@Override
	public Pagination findByPageReview(Pagination page, Map<String, Object> paraMap) {
		return rfxmDao.findByPageReview(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmEntityHistory getById(String id)
	{
		return rfxmDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param rfxm 信息
	 */
	@Transactional
	public void save(RfxmEntityHistory rfxm)
	{
		rfxmDao.save(rfxm);
	}

	/**
	 * 修改信息
	 * @param rfxm 信息
	 */
	@Transactional
	public void update(RfxmEntityHistory rfxm)
	{
		rfxmDao.update(rfxm);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = rfxmDao.findRfxm(paraMap);

		rfxmDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					rfxmDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<RfxmEntityHistory> findRfxm(Map<String, Object> paraMap) {

		return rfxmDao.findRfxm(paraMap);

	}

	@Override
	public RfxmEntityHistory getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		RfxmEntityHistory rfxm = (RfxmEntityHistory) rfxmDao.findObjectByFieldsMap(Rfxm.class,paramMap);
		return rfxm;
	}

	@Override
	public RfxmEntityHistory getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		RfxmEntityHistory rfxm = (RfxmEntityHistory) rfxmDao.findObjectByFieldsMap(Rfxm.class,paramMap);
		return rfxm;
	}
}
