package com.jshx.rfxm.service;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.zzhgl.entity.Zzh;
import com.jshx.rfxm.entity.*;

import java.util.List;
import java.util.Map;

public interface RfxmJktzsService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public List<RfxmJktzs> findRfxmJktzs(Map<String, Object> paraMap);
	public RfxmJktzs getByXmdm(String xmdm);

	public RfxmJktzs getByJfdmwybh(String jfdmwybh);
	public RfxmJktzs getByJktzsbh(String jktzsbh);

	/**
	 * 根据清分缴款联系id查询信息
	 * @param qfjklxid
	 */
	public RfxmJktzs getByQfjklxid(String qfjklxid);


	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RfxmJktzs getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(RfxmJktzs model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(RfxmJktzs model);

	public void updateNotSave(RfxmJktzs model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);

	/**
	 * 接口1保存信息
	 * @param rfxmJktzs
	 * @param rfxmSfxxListzl
	 * @param zzh
	 */
	public void saveJK1(RfxmJktzs rfxmJktzs,List<RfxmSfxx> rfxmSfxxListzl,Zzh zzh);

	/**
	 * 接口2保存信息
	 * @param zzh
	 * @param rfxmJktzs
	 */
	public void saveJK2(Zzh zzh,RfxmJktzs rfxmJktzs);

	void saveByTrans(RfxmJktzs jktzs, List<RfxmSfxx> rfxmSfxx, Rfxm rfxm, Zzh zzhgl);

    int invalidNotice(RfxmJktzs jktzs, RfxmJktzsHistory jktzsHistory, List<RfxmSfxxHistory> sfxxHistories, Zzh accountDetail);
}
