package com.jshx.rfxm.entity;

import com.jshx.core.base.entity.BaseModel;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="RFXM_JKTZS_HISTORY")
public class RfxmJktzsHistory extends BaseModel {

    /**
     * 部门代码
     */
    private String deptId;

    /**
     * 删除标记
     */
    private Integer delFlag;

    /**
     * 缴费代码唯一编号
     */
    private String jfdmwybh;

    /**
     * 子账户名称
     */
    private String accountName;

    /**
     * 子账户账号
     */
    private String accountDetail;

    /**
     * 子账户状态
     */
    private String accountStatus;

    /**
     * 缴费通知书编号
     */
    private String jktzsbh;

    /**
     * 代收单位
     */
    private String dsdw;

    /**
     * 项目代码
     */
    private String xmdm;

    /**
     * 规划许可证编号
     */
    private String ghxkzbh;

    /**
     * 规划项目编号
     */
    private String ghxmbh;

    /**
     * 建设单位名称
     */
    private String jsdwmc;

    /**
     * 工程项目名称
     */
    private String gcxmmc;

    /**
     * 应缴金额合计（元）
     */
    private String yjhjje;

    /**
     * 子账户合计到账金额
     */
    private String zzhhjdzje;

    /**
     * 清分确认流水号
     */
    private String qfqrlsh;

    /**
     * 清分行缴款总金额
     */
    private String qfhjkzje;

    /**
     * 缴费通知应缴额
     */
    private String jftzyje;

    /**
     * rfxm关联id
     */
    private String rfxmid;

    /**
     * 能否开票(0:不能开票，1:可开票)
     */
    private String nfkp;

    /**
     * 开票状态(0:未开票，1:已开票)
     */
    private String kpzt;

    /**
     * 清分状态(0:未清分，1:已清分)
     */
    private String qfzt;

    /**
     * 清分缴款联系id；
     */
    private String qfjklxid;

    /**
     * 暂不开票
     */
    private String zbkp;

    /**
     * 操作人
     */
    private String czr;

    /**
     * 承诺缴费环节类型
     * 0 施工许可前
     * 1 竣工验收前
     * 2 n日内
     */
    private Integer statusCnjfhj;

    private String khh;

    // 2019-7-16 start---------------
    /**
     * 区分是接口录入还是页面录入
     * 	 0    接口录入
     * 	 1    页面录入
     */
    private Integer insertType;
    // 2019-7-16 end ----------------

    /**
     * 作废状态标记
     */
    private Integer invalidStatus;

    public RfxmJktzsHistory() {
    }

    public RfxmJktzsHistory(Integer invalidStatus, Integer insertType, String czr,String zbkp,String qfjklxid, String qfzt, String khh, String deptId, Integer delFlag, String jfdmwybh, String accountName, String accountDetail, String accountStatus, String jktzsbh, String dsdw, String xmdm, String ghxkzbh, String ghxmbh, String jsdwmc, String gcxmmc, String yjhjje, String zzhhjdzje, String qfqrlsh, String qfhjkzje, String jftzyje, String nfkp, String rfxmid, Integer statusCnjfhj) {
        this.khh = khh;
        this.deptId = deptId;
        this.delFlag = delFlag;
        this.jfdmwybh = jfdmwybh;
        this.accountName = accountName;
        this.accountDetail = accountDetail;
        this.accountStatus = accountStatus;
        this.jktzsbh = jktzsbh;
        this.dsdw = dsdw;
        this.xmdm = xmdm;
        this.ghxkzbh = ghxkzbh;
        this.ghxmbh = ghxmbh;
        this.jsdwmc = jsdwmc;
        this.gcxmmc = gcxmmc;
        this.yjhjje = yjhjje;
        this.zzhhjdzje = zzhhjdzje;
        this.qfqrlsh = qfqrlsh;
        this.qfhjkzje = qfhjkzje;
        this.jftzyje = jftzyje;
        this.nfkp = nfkp;
        this.rfxmid = rfxmid;
        this.statusCnjfhj = statusCnjfhj;
        this.qfjklxid = qfjklxid;
        this.qfzt = qfzt;
        this.qfzt = zbkp;
        this.czr = czr;
        this.insertType = insertType;
        this.invalidStatus = invalidStatus;
    }

    @Column
    public String getDeptId()
    {
        return deptId;
    }

    public void setDeptId(String deptId)
    {
        this.deptId = deptId;
    }

    @Column
    public Integer getDelFlag()
    {
        return delFlag;
    }

    public void setDelFlag(Integer delFlag)
    {
        this.delFlag = delFlag;
    }

    @Column(name = "jktzsbh")
    public String getJktzsbh() {
        return jktzsbh;
    }

    public void setJktzsbh(String jktzsbh) {
        this.jktzsbh = jktzsbh;
    }

    @Column(name = "dsdw")
    public String getDsdw() {
        return dsdw;
    }

    public void setDsdw(String dsdw) {
        this.dsdw = dsdw;
    }

    @Column(name = "xmdm")
    public String getXmdm() {
        return xmdm;
    }

    public void setXmdm(String xmdm) {
        this.xmdm = xmdm;
    }

    @Column(name = "ghxkzbh")
    public String getGhxkzbh() {
        return ghxkzbh;
    }

    public void setGhxkzbh(String ghxkzbh) {
        this.ghxkzbh = ghxkzbh;
    }

    @Column(name = "ghxmbh")
    public String getGhxmbh() {
        return ghxmbh;
    }

    public void setGhxmbh(String ghxmbh) {
        this.ghxmbh = ghxmbh;
    }

    @Column(name = "jsdwmc")
    public String getJsdwmc() {
        return jsdwmc;
    }

    public void setJsdwmc(String jsdwmc) {
        this.jsdwmc = jsdwmc;
    }

    @Column(name = "gcxmmc")
    public String getGcxmmc() {
        return gcxmmc;
    }

    public void setGcxmmc(String gcxmmc) {
        this.gcxmmc = gcxmmc;
    }

    @Column(name = "yjhjje")
    public String getYjhjje() {
        return yjhjje;
    }

    public void setYjhjje(String yjhjje) {
        this.yjhjje = yjhjje;
    }

    @Column(name = "zzhhjdzje")
    public String getZzhhjdzje() {
        return zzhhjdzje;
    }

    public void setZzhhjdzje(String zzhhjdzje) {
        this.zzhhjdzje = zzhhjdzje;
    }

    @Column(name = "qfqrlsh")
    public String getQfqrlsh() {
        return qfqrlsh;
    }

    public void setQfqrlsh(String qfqrlsh) {
        this.qfqrlsh = qfqrlsh;
    }

    @Column(name = "qfhjkzje")
    public String getQfhjkzje() {
        return qfhjkzje;
    }

    public void setQfhjkzje(String qfhjkzje) {
        this.qfhjkzje = qfhjkzje;
    }

    @Column(name = "jftzyje")
    public String getJftzyje() {
        return jftzyje;
    }

    public void setJftzyje(String jftzyje) {
        this.jftzyje = jftzyje;
    }

    @Column(name = "jfdmwybh")
    public String getJfdmwybh() {
        return jfdmwybh;
    }

    public void setJfdmwybh(String jfdmwybh) {
        this.jfdmwybh = jfdmwybh;
    }

    @Column(name = "accountName")
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    @Column(name = "accountDetail")
    public String getAccountDetail() {
        return accountDetail;
    }

    public void setAccountDetail(String accountDetail) {
        this.accountDetail = accountDetail;
    }

    @Column(name = "accountStatus")
    public String getAccountStatus() {
        return accountStatus;
    }

    public void setAccountStatus(String accountStatus) {
        this.accountStatus = accountStatus;
    }

    @Column(name = "nfkp",columnDefinition="varchar2(255) default '0'")
    public String getNfkp() {
        return nfkp;
    }

    public void setNfkp(String nfkp) {
        this.nfkp = nfkp;
    }

    @Column(name = "rfxmid")
    public String getRfxmid() {
        return rfxmid;
    }

    public void setRfxmid(String rfxmid) {
        this.rfxmid = rfxmid;
    }

    @Column(name = "kpzt",columnDefinition="varchar2(255) default '0'")
    public String getKpzt() {
        return kpzt;
    }

    public void setKpzt(String kpzt) {
        this.kpzt = kpzt;
    }

    @Column(name = "status_cnjfhj")
    public Integer getStatusCnjfhj() {
        return statusCnjfhj;
    }

    public void setStatusCnjfhj(Integer statusCnjfhj) {
        this.statusCnjfhj = statusCnjfhj;
    }

    @Column(name = "khh")
    public String getKhh() {
        return khh;
    }

    public void setKhh(String khh) {
        this.khh = khh;
    }

    @Column(name = "qfjklxid")
    public String getQfjklxid() {
        return qfjklxid;
    }

    public void setQfjklxid(String qfjklxid) {
        this.qfjklxid = qfjklxid;
    }

    @Column(name = "qfzt")
    public String getQfzt() {
        return qfzt;
    }

    public void setQfzt(String qfzt) {
        this.qfzt = qfzt;
    }

    @Column(name = "zbkp")
    public String getZbkp() {
        return zbkp;
    }

    public void setZbkp(String zbkp) {
        this.zbkp = zbkp;
    }

    @Column(name = "czr")
    public String getCzr() {
        return czr;
    }

    public void setCzr(String czr) {
        this.czr = czr;
    }

    @Column(name = "insert_type")
    public Integer getInsertType() {
        return insertType;
    }

    public void setInsertType(Integer insertType) {
        this.insertType = insertType;
    }

    @Column(name = "invalid_type")
    public Integer getInvalidStatus() {
        return invalidStatus;
    }

    public void setInvalidStatus(Integer invalidStatus) {
        this.invalidStatus = invalidStatus;
    }
}